/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.hq.product;

import java.security.MessageDigest;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Queue;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hyperic.hq.product.MeasurementPlugin;
import org.hyperic.hq.product.Metric;
import org.hyperic.hq.product.MetricInvalidException;
import org.hyperic.hq.product.MetricNotFoundException;
import org.hyperic.hq.product.MetricUnreachableException;
import org.hyperic.hq.product.MetricValue;
import org.hyperic.hq.product.PluginException;
import org.hyperic.hq.product.PluginManager;
import org.hyperic.hq.product.TypeInfo;
import org.hyperic.util.config.ConfigResponse;
import org.hyperic.util.config.ConfigSchema;
import org.hyperic.util.config.SchemaBuilder;
import org.hyperic.util.jdbc.DBUtil;

public abstract class JDBCMeasurementPlugin
extends MeasurementPlugin {
    private static Log log = LogFactory.getLog(JDBCMeasurementPlugin.class);
    protected static final String AVAIL_ATTR = "availability";
    public static final String PROP_URL = "jdbcUrl";
    public static final String PROP_USER = "jdbcUser";
    public static final String PROP_PASSWORD = "jdbcPassword";
    public static final String PROP_TABLE = "table";
    public static final String PROP_INDEX = "index";
    private static final String USER_KEY = "user";
    private static final String PASSWORD_KEY = "password";
    public static final int COL_INVALID = 0;
    private static long FIVE_MINUTES_MILLIS = 300000L;
    protected String _sqlLog;
    private Double _data;
    private HashMap _colMap = new HashMap();
    private HashMap _valMap = new HashMap();
    private int _numRows;
    private static final HashMap<String, Queue> connectionPools = new HashMap();
    private static final Timer poolsShrinkTimer = new Timer("JDBCMeasurementPlugin.poolsShrink");

    public ConfigSchema getConfigSchema(TypeInfo info, ConfigResponse config) {
        ConfigSchema schema = super.getConfigSchema(info, config);
        if (schema.getOptions().size() > 0) {
            return schema;
        }
        SchemaBuilder builder = new SchemaBuilder(config);
        builder.add(PROP_URL, "JDBC URL", this.getDefaultURL());
        builder.add(PROP_USER, "Database username", "username");
        builder.addSecret(PROP_PASSWORD, "Database password").setOptional(true);
        return builder.getSchema();
    }

    public void init(PluginManager manager) throws PluginException {
        super.init(manager);
        try {
            this.getDriver();
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() throws PluginException {
        super.shutdown();
        poolsShrinkTimer.cancel();
        HashMap<String, Queue> hashMap = connectionPools;
        synchronized (hashMap) {
            Set<Map.Entry<String, Queue>> pools = connectionPools.entrySet();
            for (Map.Entry<String, Queue> entry : pools) {
                Connection conn;
                Queue pool = entry.getValue();
                while ((conn = (Connection)pool.poll()) != null) {
                    DBUtil.closeJDBCObjects((Object)log, (Connection)conn, null, null);
                }
            }
            connectionPools.clear();
        }
    }

    public MetricValue getValue(Metric metric) throws PluginException, MetricUnreachableException, MetricInvalidException, MetricNotFoundException {
        double value = this.getQueryValue(metric);
        MetricValue mValue = new MetricValue(value, System.currentTimeMillis());
        return mValue;
    }

    protected abstract void initQueries();

    protected abstract String getQuery(Metric var1);

    protected abstract void getDriver() throws ClassNotFoundException;

    protected abstract Connection getConnection(String var1, String var2, String var3) throws SQLException;

    protected abstract String getDefaultURL();

    protected int getColumn(Metric jdsn) {
        return 1;
    }

    protected String getColumnName(Metric jdsn) {
        return "";
    }

    protected Connection getCachedConnection(Metric metric) throws SQLException {
        Properties props = metric.getProperties();
        String url = props.getProperty(PROP_URL);
        String user = props.getProperty(PROP_USER);
        String pass = props.getProperty(PROP_PASSWORD);
        return this.getCachedConnection(url, user, pass);
    }

    private static String calculateKey(String url, String user, String pass) {
        if (pass == null) {
            pass = "";
        }
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            byte[] thedigest = md.digest(pass.getBytes("UTF-8"));
            pass = new String(thedigest, "UTF-8");
        }
        catch (Exception ex) {
            log.debug((Object)ex, (Throwable)ex);
        }
        String cacheKey = url + ":" + pass + "@" + user;
        return cacheKey;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Connection getCachedConnection(String url, String user, String pass) throws SQLException {
        Connection conn;
        ConcurrentLinkedQueue pool;
        String cacheKey = JDBCMeasurementPlugin.calculateKey(url, user, pass);
        HashMap<String, Queue> hashMap = connectionPools;
        synchronized (hashMap) {
            pool = connectionPools.get(cacheKey);
            if (pool == null) {
                pool = new ConcurrentLinkedQueue();
                connectionPools.put(cacheKey, pool);
                log.debug((Object)("[getCC] Pool for '" + cacheKey + "' created"));
            }
        }
        int count = 0;
        while ((conn = (Connection)pool.poll()) == null && count++ < 5) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException ex) {
                log.error((Object)ex, (Throwable)ex);
            }
        }
        if (conn == null) {
            conn = this.getConnection(url, user, pass);
            log.debug((Object)("[getCC] Connection for '" + cacheKey + "' created (pool.size=" + pool.size() + ")"));
        }
        log.debug((Object)("[getCC] Connection for '" + cacheKey + "' used (pool.size=" + pool.size() + ")"));
        return conn;
    }

    protected void removeCachedConnection(String url, String user, String pass) {
        String cacheKey = JDBCMeasurementPlugin.calculateKey(url, user, pass);
        Queue pool = connectionPools.get(cacheKey);
        if (pool != null) {
            Connection conn;
            while ((conn = (Connection)pool.poll()) != null) {
                DBUtil.closeJDBCObjects((Object)log, (Connection)conn, null, null);
                log.debug((Object)("[remCC] Connection for '" + cacheKey + "' closed (pool.size=" + pool.size() + ")"));
            }
            connectionPools.remove(cacheKey);
        } else {
            log.debug((Object)("[remCC] Pool for '" + cacheKey + "' not found"));
        }
    }

    protected void returnCachedConnection(String url, String user, String pass, Connection conn) {
        String cacheKey = JDBCMeasurementPlugin.calculateKey(url, user, pass);
        Queue pool = connectionPools.get(cacheKey);
        if (pool != null) {
            pool.add(conn);
            log.debug((Object)("[retCC] Connection for '" + cacheKey + "' returned (pool.size=" + pool.size() + ")"));
        } else {
            DBUtil.closeJDBCObjects((Object)log, (Connection)conn, null, null);
            log.debug((Object)("[retCC] Pool for '" + cacheKey + "' not found, closing connection"));
        }
    }

    protected double getQueryValue(Metric jdsn) throws MetricNotFoundException, PluginException, MetricUnreachableException {
        return this.getQueryValue(jdsn, false);
    }

    /*
     * Unable to fully structure code
     */
    protected double getQueryValue(Metric jdsn, boolean logSql) throws MetricNotFoundException, PluginException, MetricUnreachableException {
        block13: {
            block12: {
                block16: {
                    block11: {
                        this.initQueries();
                        query = this.getQuery(jdsn);
                        attr = jdsn.getAttributeName();
                        if (query == null) {
                            msg = "No SQL query mapped to: " + attr;
                            throw new PluginException(msg);
                        }
                        isAvail = attr.equalsIgnoreCase("availability");
                        props = jdsn.getProperties();
                        url = props.getProperty("jdbcUrl");
                        user = props.getProperty("jdbcUser");
                        pass = props.getProperty("jdbcPassword");
                        conn = null;
                        stmt = null;
                        rs = null;
                        conn = this.getCachedConnection(url, user, pass);
                        stmt = conn.createStatement();
                        stmt.execute(query);
                        if (!isAvail) break block11;
                        var13_14 = 1.0;
                        this.returnCachedConnection(url, user, pass, conn);
                        DBUtil.closeJDBCObjects((Object)JDBCMeasurementPlugin.log, null, (Statement)stmt, (ResultSet)rs);
                        return var13_14;
                    }
                    column = this.getColumn(jdsn);
                    if (!logSql) break block16;
                    this._data = null;
                    this._sqlLog = this.getSqlRow(stmt);
                    ** GOTO lbl43
                }
                if (column == 0) ** GOTO lbl43
                rs = stmt.getResultSet();
                if (rs == null || !rs.next()) break block12;
                var14_17 = rs.getDouble(column);
                this.returnCachedConnection(url, user, pass, conn);
                DBUtil.closeJDBCObjects((Object)JDBCMeasurementPlugin.log, null, (Statement)stmt, (ResultSet)rs);
                return var14_17;
            }
            throw new MetricNotFoundException(attr);
lbl43:
            // 2 sources

            if (this._data == null) break block13;
            var14_18 = this._data;
            this.returnCachedConnection(url, user, pass, conn);
            DBUtil.closeJDBCObjects((Object)JDBCMeasurementPlugin.log, null, (Statement)stmt, (ResultSet)rs);
            return var14_18;
        }
        try {
            var14_19 = rs.getDouble(this.getColumnName(jdsn));
            this.returnCachedConnection(url, user, pass, conn);
        }
        catch (SQLException e) {
            block15: {
                block14: {
                    try {
                        this.removeCachedConnection(url, user, pass);
                        if (!isAvail) break block14;
                        JDBCMeasurementPlugin.log.debug((Object)"AVAIL_DOWN", (Throwable)e);
                        var14_20 = 0.0;
                        this.returnCachedConnection(url, user, pass, conn);
                    }
                    catch (Throwable var17_23) {
                        this.returnCachedConnection(url, user, pass, conn);
                        DBUtil.closeJDBCObjects((Object)JDBCMeasurementPlugin.log, null, (Statement)stmt, rs);
                        throw var17_23;
                    }
                    DBUtil.closeJDBCObjects((Object)JDBCMeasurementPlugin.log, null, (Statement)stmt, (ResultSet)rs);
                    return var14_20;
                }
                msg = "Query failed for " + attr + ", while attempting to issue query " + query + ":" + e.getMessage();
                if (e.getErrorCode() != 1476 && e.getErrorCode() != 22012) break block15;
                var15_22 = 0.0;
                this.returnCachedConnection(url, user, pass, conn);
                DBUtil.closeJDBCObjects((Object)JDBCMeasurementPlugin.log, null, (Statement)stmt, (ResultSet)rs);
                return var15_22;
            }
            if (e.getErrorCode() == 1034 || e.getErrorCode() == 8000 || e.getErrorCode() == 8006 || e.getErrorCode() == 8001 || e.getErrorCode() == 2002 || e.getErrorCode() == 2003) {
                throw new MetricUnreachableException(msg, e);
            }
            throw new MetricNotFoundException(msg, e);
        }
        DBUtil.closeJDBCObjects((Object)JDBCMeasurementPlugin.log, null, (Statement)stmt, (ResultSet)rs);
        return var14_19;
    }

    private String getSqlRow(Statement stmt) throws SQLException {
        StringBuffer buf = new StringBuffer();
        do {
            ResultSet rs = stmt.getResultSet();
            if (stmt.getUpdateCount() != -1) continue;
            if (rs == null) break;
            this.setData(rs);
            buf.append(this.getOutput(rs.getMetaData()));
        } while (stmt.getMoreResults());
        return buf.toString();
    }

    protected void setData(ResultSet rs) throws SQLException {
        this.clearObjects();
        ResultSetMetaData md = rs.getMetaData();
        this.processColumnHeader(md);
        this.processColumns(rs);
    }

    private void clearObjects() {
        this._numRows = 0;
        this._colMap.clear();
        this._valMap.clear();
    }

    protected void processColumnHeader(ResultSetMetaData md) throws SQLException {
        for (int i = 1; i <= md.getColumnCount(); ++i) {
            Integer ind = new Integer(i);
            int length = md.getColumnName(i).trim().length();
            length = length == 0 ? 1 : length;
            this._colMap.put(ind, new Integer(length));
            this._valMap.put(ind, new ArrayList());
        }
    }

    protected void processColumns(ResultSet rs) throws SQLException {
        while (rs.next()) {
            ++this._numRows;
            ResultSetMetaData rsmd = rs.getMetaData();
            for (int i = 1; i <= rsmd.getColumnCount(); ++i) {
                Integer ind = new Integer(i);
                String val = null;
                if (rs.getObject(i) == null) {
                    val = "()";
                } else {
                    try {
                        if (rsmd.getColumnType(i) != -2) {
                            val = rs.getString(i).trim();
                        }
                        if (this._data == null) {
                            this._data = new Double(val);
                        }
                    }
                    catch (Exception e) {
                        val = "";
                    }
                }
                ((List)this._valMap.get(ind)).add(val);
                if (val.length() <= (Integer)this._colMap.get(ind)) continue;
                this._colMap.put(ind, new Integer(val.length()));
            }
        }
    }

    private String getOutput(ResultSetMetaData md) throws SQLException {
        StringBuffer rtn = new StringBuffer();
        for (int i = 1; i <= md.getColumnCount(); ++i) {
            rtn.append(md.getColumnName(i)).append("=");
            for (int j = 0; j < this._numRows; ++j) {
                Integer jnd = new Integer(i);
                String val = "";
                if (((List)this._valMap.get(jnd)).size() > 0) {
                    val = (String)((List)this._valMap.get(jnd)).remove(0);
                }
                rtn.append(val);
                if (j >= this._numRows - 1) continue;
                rtn.append(",");
            }
            rtn.append("::");
        }
        return rtn.toString();
    }

    public static Properties getJDBCConnectionProperties(String user, String password) {
        Properties info = new Properties();
        if (user != null) {
            info.put(USER_KEY, user);
        }
        if (password != null) {
            info.put(PASSWORD_KEY, password);
        }
        return info;
    }

    static {
        poolsShrinkTimer.scheduleAtFixedRate(new TimerTask(){

            public void run() {
                log.debug((Object)"[poolsShrink] run");
                Set pools = connectionPools.entrySet();
                for (Map.Entry entry : pools) {
                    Queue pool = (Queue)entry.getValue();
                    if (pool.size() <= 1) continue;
                    log.debug((Object)("[poolsShrink] '" + (String)entry.getKey() + "' pool.size()=" + pool.size()));
                    while (pool.size() > 1) {
                        Connection conn = (Connection)pool.poll();
                        DBUtil.closeJDBCObjects((Object)log, (Connection)conn, null, null);
                    }
                }
            }
        }, FIVE_MINUTES_MILLIS, FIVE_MINUTES_MILLIS);
    }
}

