/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.hq.plugin.multilogtrack;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hyperic.hq.plugin.multilogtrack.MultiLogTrackMeasurementPlugin;
import org.hyperic.hq.plugin.multilogtrack.MultiLogTrackServerDetector;
import org.hyperic.hq.product.LogFileTailPlugin;
import org.hyperic.hq.product.LogMessageFolder;
import org.hyperic.hq.product.LogTrackPlugin;
import org.hyperic.hq.product.PluginException;
import org.hyperic.hq.product.TrackEvent;
import org.hyperic.hq.product.TypeInfo;
import org.hyperic.sigar.FileInfo;
import org.hyperic.sigar.FileTail;
import org.hyperic.sigar.FileWatcher;
import org.hyperic.sigar.Sigar;
import org.hyperic.sigar.SigarException;
import org.hyperic.util.config.BooleanConfigOption;
import org.hyperic.util.config.ConfigOption;
import org.hyperic.util.config.ConfigResponse;
import org.hyperic.util.config.ConfigSchema;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MultiLogTrackPlugin
extends LogFileTailPlugin {
    private static final Log log = LogFactory.getLog(MultiLogTrackPlugin.class);
    private Pattern includePattern;
    private Pattern excludePattern;
    private Pattern includePattern_2;
    private Pattern excludePattern_2;
    private AtomicReference<FileTail> watcher = new AtomicReference();
    private Sigar sigar;
    private final Long matchSleepTime = this.getSleepTime();
    protected static final String FILE_SCAN_INTERVAL = "300000";
    private static final HashSet<String> firstTimeConfig = new HashSet();
    private static AtomicReference<Collection<MultiDirWatcher>> fileWatcherThreads = new AtomicReference();
    static final String INCLUDE_PATTERN = "includepattern";
    static final String EXCLUDE_PATTERN = "excludepattern";
    static final String SECONDARY_PATTEN_SUFFIX = "_2";
    static final String INCLUDE_PATTERN_2 = "includepattern_2";
    static final String EXCLUDE_PATTERN_2 = "excludepattern_2";

    public TrackEvent processLine(FileInfo info, String line, String basedir, String logfilepattern, int offset) {
        TrackEvent event = this.processLine(INCLUDE_PATTERN, this.includePattern, this.includePattern, this.excludePattern, info, line, basedir, logfilepattern, offset);
        TrackEvent event2 = this.processLine(INCLUDE_PATTERN_2, this.includePattern, this.includePattern_2, this.excludePattern_2, info, line, basedir, logfilepattern, offset);
        if (event != null) {
            return event;
        }
        if (event2 != null) {
            return event2;
        }
        return null;
    }

    private TrackEvent processLine(String property, Pattern primaryIncludePattern, Pattern includePattern, Pattern excludePattern, FileInfo info, String line, String basedir, String logfilepattern, int offset) {
        if (null == includePattern || !includePattern.matcher(line).find()) {
            return null;
        }
        if (null != excludePattern && excludePattern.matcher(line).find()) {
            return null;
        }
        MultiLogTrackMeasurementPlugin.incrementNumLines(property, basedir, logfilepattern, primaryIncludePattern.toString(), offset);
        return this.newTrackEvent(System.currentTimeMillis(), -1, info.getName(), line);
    }

    public void configure(ConfigResponse config) throws PluginException {
        this.config = config;
        this.setFileWatcherThread(config);
        Reference<Pattern> includePatternRef = new Reference<Pattern>();
        this.configure(config, INCLUDE_PATTERN, includePatternRef);
        this.includePattern = includePatternRef.get();
        Reference<Pattern> excludePatternRef = new Reference<Pattern>();
        this.configure(config, EXCLUDE_PATTERN, excludePatternRef);
        this.excludePattern = excludePatternRef.get();
        Reference<Pattern> includePatternRef_2 = new Reference<Pattern>();
        this.configure(config, INCLUDE_PATTERN_2, includePatternRef_2);
        this.includePattern_2 = includePatternRef_2.get();
        Reference<Pattern> excludePatternRef_2 = new Reference<Pattern>();
        this.configure(config, EXCLUDE_PATTERN_2, excludePatternRef_2);
        this.excludePattern_2 = excludePatternRef_2.get();
    }

    public void configure(ConfigResponse config, String configProp, Reference<Pattern> patternRef) throws PluginException {
        String pattern = config.getValue(configProp, "");
        String string = pattern = pattern.trim().startsWith("*") ? "." + pattern.trim() : pattern.trim();
        if (pattern != null && pattern.trim().length() != 0) {
            try {
                patternRef.set(Pattern.compile(pattern, 2));
            }
            catch (Exception e) {
                throw new PluginException("error compiling pattern " + configProp + "=" + pattern + ": " + e, (Throwable)e);
            }
        } else {
            patternRef.set(null);
        }
    }

    private void setFileWatcherThread(ConfigResponse c) {
        String basedir = MultiLogTrackServerDetector.getBasedir(c);
        String logfilepattern = MultiLogTrackServerDetector.getLogfilepattern(c);
        MultiDirWatcher thread = new MultiDirWatcher(c);
        Collection<MultiDirWatcher> threads = fileWatcherThreads.get();
        if (threads == null) {
            threads = new ArrayList<MultiDirWatcher>();
            fileWatcherThreads.set(threads);
        }
        boolean startThread = true;
        for (MultiDirWatcher t : threads) {
            if (!t.basedir.equals(basedir) || !t.logfilepattern.equals(logfilepattern)) continue;
            startThread = false;
            break;
        }
        if (startThread) {
            thread.setDaemon(true);
            thread.start();
        }
    }

    private void setFiles(ConfigResponse cfg) throws PluginException {
        try {
            HashSet<String> oldFiles = new HashSet<String>();
            String basedir = MultiLogTrackServerDetector.getBasedir(cfg);
            String includePatternBuf = cfg.getValue(INCLUDE_PATTERN);
            String logfilepattern = MultiLogTrackServerDetector.getLogfilepattern(cfg);
            String key = logfilepattern + "|" + basedir + "|" + includePatternBuf;
            if (firstTimeConfig.contains(key)) {
                MultiLogTrackServerDetector.getBasedirAndSetFilesFromCache(cfg, oldFiles, false);
            } else {
                firstTimeConfig.add(key);
            }
            List<String> files = MultiLogTrackServerDetector.getFilesCached(logfilepattern, basedir, includePatternBuf, true);
            for (String logfile : files) {
                boolean exists = oldFiles.remove(logfile);
                if (exists) continue;
                String fs = MultiLogTrackServerDetector.getFileSeparator(basedir);
                this.configureLogfile(basedir + fs + logfile, cfg);
            }
            FileTail fileWatcher = this.getFileWatcher(cfg);
            for (String nonExistentLogFile : oldFiles) {
                fileWatcher.remove(nonExistentLogFile);
            }
        }
        catch (SigarException e) {
            throw new PluginException(e.getMessage(), (Throwable)e);
        }
    }

    private void configureLogfile(String logfile, ConfigResponse cfg) throws SigarException {
        FileTail fileWatcher = this.getFileWatcher(cfg);
        if (!new File(logfile).exists()) {
            log.warn((Object)("logfile=" + logfile + " does not exist"));
            if (log.isDebugEnabled()) {
                log.debug((Object)("logfile=" + logfile + " does not exist"), new Throwable());
            }
            return;
        }
        fileWatcher.add(logfile);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Adding Multi Log Track file watchers for file=" + logfile));
        }
        try {
            Field field = LogTrackPlugin.class.getDeclaredField("folder");
            field.setAccessible(true);
            LogMessageFolder folder = new LogMessageFolder((LogTrackPlugin)this);
            folder.setRepeatMax(Long.MAX_VALUE);
            field.set((Object)this, folder);
        }
        catch (Exception e) {
            log.error((Object)e, (Throwable)e);
        }
    }

    private FileTail getFileWatcher(ConfigResponse cfg) {
        if (this.watcher.get() == null) {
            if (this.sigar == null) {
                this.sigar = new Sigar();
            }
            this.watcher.set(new MultiFileTail(this.sigar, cfg));
            this.getManager().addFileWatcher((FileWatcher)this.watcher.get());
            if (log.isDebugEnabled()) {
                log.debug((Object)("init file tail basedir=" + MultiLogTrackServerDetector.getBasedir(cfg) + ", pattern=" + MultiLogTrackServerDetector.getLogfilepattern(cfg) + ", watcher=" + this.watcher + ", this=" + (Object)((Object)this) + ", cfg=" + cfg + ", sigar=" + this.sigar));
            }
        }
        return this.watcher.get();
    }

    private Long getSleepTime() {
        String sleepTimeBuf = System.getProperty("multilogtrack.sleep");
        if (sleepTimeBuf == null) {
            return null;
        }
        try {
            return Long.parseLong(sleepTimeBuf);
        }
        catch (NumberFormatException e) {
            log.warn((Object)("multilogtrack.sleep not a number: " + sleepTimeBuf + ", plugin will not sleep btwn log matches"));
            return null;
        }
    }

    public ConfigSchema getConfigSchema(TypeInfo info, ConfigResponse config) {
        ConfigSchema schema = new ConfigSchema();
        ConfigOption enableOption = this.getEnableOption(info, config);
        if (enableOption != null) {
            schema.addOption(enableOption);
            enableOption.setDefault("true");
            enableOption.setOptional(false);
        }
        String enableProp = "server.enable_log_services";
        BooleanConfigOption option = new BooleanConfigOption("server.enable_log_services", "Enable Service Creation", false);
        option.setOptional(true);
        schema.addOption((ConfigOption)option);
        String metricsProp = "enable_only_metrics";
        option = new BooleanConfigOption("enable_only_metrics", "Only Enable Log Metrics, Do Not Send Logs To The HQ Server", false);
        option.setOptional(true);
        schema.addOption((ConfigOption)option);
        String overrideChecks = "override_file_checks";
        option = new BooleanConfigOption("override_file_checks", "Override file checks.  Validate if files do not exist", false);
        option.setOptional(true);
        schema.addOption((ConfigOption)option);
        return schema;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class Reference<T> {
        private T value;

        public Reference() {
        }

        public Reference(T initialValue) {
            this.value = initialValue;
        }

        public T get() {
            return this.value;
        }

        public void set(T value) {
            this.value = value;
        }

        public int hashCode() {
            return this.value.hashCode();
        }

        public boolean equals(Object rhs) {
            if (this == rhs) {
                return true;
            }
            return rhs.equals(this.value);
        }

        public String toString() {
            return this.value.toString();
        }
    }

    private class MultiFileTail
    extends FileTail {
        private final ConfigResponse cfg;

        private MultiFileTail(Sigar sigar, ConfigResponse cfg) {
            super(sigar);
            this.cfg = cfg;
        }

        public void tail(FileInfo info, Reader reader) {
            FileInfo previous = info.getPreviousInfo();
            if (info.getInode() == 0L || previous.getInode() == 0L) {
                long prevSize = previous.getSize();
                if (log.isDebugEnabled()) {
                    String msg = "Inode=0, will attempt to seek to previous Inode size=" + prevSize;
                    log.debug((Object)((info.getInode() != 0L ? "previous " : "") + msg));
                }
                if (info.getSize() == prevSize) {
                    log.debug((Object)"log watcher event occured but there are no lines to read since info.getSize() == previous.getSize()");
                    return;
                }
                try {
                    reader.skip(prevSize);
                }
                catch (IOException e) {
                    log.error((Object)("Could not skip to the previous offset on Inode=0: " + e), (Throwable)e);
                    return;
                }
            }
            BufferedReader buffer = new BufferedReader(reader);
            String basedir = MultiLogTrackServerDetector.getBasedir(this.cfg);
            String logfilepattern = MultiLogTrackServerDetector.getLogfilepattern(this.cfg);
            try {
                String line;
                boolean debug = log.isDebugEnabled();
                boolean first = true;
                int i = 0;
                while ((line = buffer.readLine()) != null) {
                    TrackEvent event;
                    if (!first && MultiLogTrackPlugin.this.matchSleepTime != null && MultiLogTrackPlugin.this.matchSleepTime > 0L) {
                        this.sleep(MultiLogTrackPlugin.this.matchSleepTime);
                    }
                    first = false;
                    if (debug) {
                        log.debug((Object)("processing file=" + info.getName() + ", line=" + line + ", basedir=" + MultiLogTrackServerDetector.getBasedir(this.cfg) + ", pattern=" + MultiLogTrackServerDetector.getLogfilepattern(this.cfg) + ", includepattern=" + MultiLogTrackPlugin.this.includePattern + ", this=" + ((Object)((Object)this)).toString()));
                    }
                    if ((event = MultiLogTrackPlugin.this.processLine(info, line, basedir, logfilepattern, i++)) == null || !this.reportEvents()) continue;
                    MultiLogTrackPlugin.this.getManager().reportEvent(event);
                }
            }
            catch (IOException e) {
                log.error((Object)(info.getName() + ": " + e), (Throwable)e);
            }
        }

        private void sleep(Long sleepTime) {
            try {
                Thread.sleep(sleepTime);
            }
            catch (InterruptedException e) {
                log.debug((Object)e, (Throwable)e);
            }
        }

        private boolean reportEvents() {
            String value = this.cfg.getValue("enable_only_metrics");
            return value == null || value.equalsIgnoreCase("false");
        }

        public int hashCode() {
            return this.cfg.hashCode();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o instanceof MultiFileTail) {
                MultiFileTail t = (MultiFileTail)((Object)o);
                return this.cfg.equals((Object)t.cfg);
            }
            return false;
        }
    }

    private class MultiDirWatcher
    extends Thread {
        private final ConfigResponse cfg;
        private String basedir;
        private String logfilepattern;

        private MultiDirWatcher(ConfigResponse c) {
            this.cfg = c;
            this.basedir = MultiLogTrackServerDetector.getBasedir(c);
            this.logfilepattern = MultiLogTrackServerDetector.getLogfilepattern(c);
            this.setName("MultiDirWatcher-" + this.basedir + "-" + this.logfilepattern);
        }

        public void run() {
            if (log.isDebugEnabled()) {
                log.debug((Object)("starting multi log track watcher thread for basedir=" + this.basedir + ", logfilepattern=" + this.logfilepattern));
            }
            while (true) {
                try {
                    while (true) {
                        MultiLogTrackPlugin.this.setFiles(this.cfg);
                        long sleepTime = Long.parseLong(MultiLogTrackPlugin.FILE_SCAN_INTERVAL);
                        try {
                            sleepTime = Long.parseLong(this.cfg.getValue("fileScanInterval", MultiLogTrackPlugin.FILE_SCAN_INTERVAL));
                            if (sleepTime < 60000L) {
                                log.warn((Object)("file scan interval set to " + sleepTime + ", will not scan more than once a minute.  Setting interval to one minute"));
                                sleepTime = 60000L;
                            }
                        }
                        catch (NumberFormatException e) {
                            log.debug((Object)e, (Throwable)e);
                        }
                        Thread.sleep(sleepTime);
                    }
                }
                catch (Throwable t) {
                    log.error((Object)t, t);
                    continue;
                }
                break;
            }
        }
    }
}

