/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.hq.plugin.netservices;

import java.io.IOException;
import org.hyperic.hq.plugin.netservices.SocketChecker;
import org.hyperic.hq.plugin.netservices.SocketWrapper;

public class FTPCollector
extends SocketChecker {
    private static final String ANONYMOUS_USER = "anonymous";
    private static final String ANONYMOUS_PASS = "hyperic-monitor@";

    private boolean isOK(String line) {
        return line.startsWith("1") || line.startsWith("2") || line.startsWith("3");
    }

    private boolean isERR(String line) {
        return line.startsWith("4") || line.startsWith("5");
    }

    private boolean sendCommand(SocketWrapper socket, String cmd) throws IOException {
        return this.sendCommand(socket, cmd, null);
    }

    private boolean sendCommand(SocketWrapper socket, String cmd, String val) throws IOException {
        String line;
        if (val != null) {
            cmd = cmd + " " + val;
        }
        socket.writeLine(cmd);
        try {
            boolean extendedResponse = false;
            while ((line = socket.readLine()) != null) {
                if (line.length() > 3 && line.charAt(3) == '-') {
                    extendedResponse = true;
                    continue;
                }
                if (extendedResponse && line.length() > 1 && !Character.isDigit(line.charAt(0))) {
                    continue;
                }
                break;
            }
        }
        catch (IOException e) {
            this.setErrorMessage("Reading " + cmd + " response", e);
            return false;
        }
        if (this.isOK(line)) {
            return true;
        }
        if (this.isERR(line)) {
            this.setErrorMessage(line);
            return false;
        }
        this.setErrorMessage("Unexpected " + cmd + " response: " + line);
        return false;
    }

    protected boolean check(SocketWrapper socket) throws IOException {
        String line;
        try {
            while ((line = socket.readLine()) != null) {
                this.setDebugMessage(line);
                if (line.length() > 3 && line.charAt(3) == '-') {
                    continue;
                }
                break;
            }
        }
        catch (IOException e) {
            this.setErrorMessage("Failed to read welcome banner", e);
            throw e;
        }
        if (!this.isOK(line)) {
            this.setErrorMessage("Unexpected welcome response: " + line);
            return false;
        }
        if (this.hasCredentials()) {
            if (!this.sendCommand(socket, "USER", this.getUsername())) {
                return false;
            }
            if (!this.sendCommand(socket, "PASS", this.getPassword())) {
                return false;
            }
        } else {
            if (!this.sendCommand(socket, "USER", ANONYMOUS_USER)) {
                return false;
            }
            if (!this.sendCommand(socket, "PASS", ANONYMOUS_PASS)) {
                return false;
            }
        }
        return this.sendCommand(socket, "QUIT");
    }
}

