/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.hq.plugin.ntp;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hyperic.hq.product.AutoServerDetector;
import org.hyperic.hq.product.PluginException;
import org.hyperic.hq.product.ServerDetector;
import org.hyperic.hq.product.ServerResource;
import org.hyperic.util.config.ConfigResponse;

public class NTPServerDetector
extends ServerDetector
implements AutoServerDetector {
    private static Log log = LogFactory.getLog((String)"NTPServerDetector");
    private static final String[] NTPD_PATHS = new String[]{"/usr/sbin/ntpd", "/usr/bin/ntpd", "/sbin/ntpd", "/bin/ntpd", "/usr/sbin/xntpd"};
    private static final String[] NTPD_PID_PATHS = new String[]{"/var/run/ntpd.pid"};

    private static File getPidFile() {
        for (int i = 0; i < NTPD_PID_PATHS.length; ++i) {
            File ntpdPid = new File(NTPD_PID_PATHS[i]);
            if (!ntpdPid.exists()) continue;
            return ntpdPid;
        }
        return null;
    }

    private static String getServerProcess(String query) {
        String exe;
        long[] pids = NTPServerDetector.getPids((String)query);
        if (pids.length == 1 && (exe = NTPServerDetector.getProcExe((long)pids[0], (String)"ntpd")) != null) {
            if (!exe.startsWith("/")) {
                for (int i = 0; i < NTPD_PATHS.length; ++i) {
                    File ntpd = new File(NTPD_PATHS[i]);
                    if (!ntpd.exists()) continue;
                    return NTPD_PATHS[i];
                }
                log.error((Object)"Unable to determine ntpd location from process table");
                return null;
            }
            return exe;
        }
        return null;
    }

    private String findNtpdc(String path) {
        File ntpd = new File(path);
        String program = ntpd.getName() + "c";
        File ntpdc = new File(ntpd.getParent(), program);
        if (!ntpdc.exists()) {
            ntpdc = new File("/usr/bin", program);
            if (!ntpd.exists()) {
                return program;
            }
        }
        return ntpdc.getPath();
    }

    public List getServerResources(ConfigResponse platformConfig) throws PluginException {
        ArrayList<ServerResource> servers = new ArrayList<ServerResource>();
        File ntpdPid = NTPServerDetector.getPidFile();
        String query = ntpdPid != null ? "Pid.PidFile.eq=" + ntpdPid.getAbsolutePath() : "State.Name.ew=ntpd";
        String ntpd = NTPServerDetector.getServerProcess(query);
        if (ntpd != null) {
            String ntpdc = this.findNtpdc(ntpd);
            ServerResource server = this.createServerResource(ntpd);
            ConfigResponse productConfig = new ConfigResponse();
            productConfig.setValue("ntpdc", ntpdc);
            productConfig.setValue("process.query", query);
            productConfig.setValue("timeout", "1");
            server.setProductConfig(productConfig);
            server.setMeasurementConfig();
            servers.add(server);
        }
        return servers;
    }
}

