/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.springsource.hyperic.plugin.gemfire.collectors;

import com.vmware.springsource.hyperic.plugin.gemfire.GemFireUtils;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.management.MBeanServerConnection;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hyperic.hq.product.Collector;
import org.hyperic.hq.product.PluginException;
import org.hyperic.hq.product.jmx.MxUtil;

public class GatewayCollector
extends Collector {
    static Log log = LogFactory.getLog(GatewayCollector.class);

    protected void init() throws PluginException {
        Properties props = this.getProperties();
        log.debug((Object)("[init] props=" + props));
        super.init();
    }

    public void collect() {
        Properties props = this.getProperties();
        log.debug((Object)("[collect] props=" + props));
        try {
            MBeanServerConnection mServer = MxUtil.getMBeanServer((Properties)props);
            String memberID = GemFireUtils.memberNameToMemberID(props.getProperty("member.name"), mServer);
            Map<String, Object> memberDetails = GemFireUtils.getMemberDetails(memberID, mServer);
            List gateways = (List)memberDetails.get("gemfire.member.gatewayhub.gateways.collection");
            String id = (String)props.get("gatewayID");
            for (Map gateway : gateways) {
                if (!((String)gateway.get("gemfire.member.gateway.id.string")).equals(id)) continue;
                this.setAvailability((Boolean)gateway.get("gemfire.member.gateway.isconnected.boolean"));
                this.setValue("queuesize", ((Integer)gateway.get("gemfire.member.gateway.queuesize.int")).intValue());
            }
        }
        catch (Exception ex) {
            this.setAvailability(false);
            log.debug((Object)("[collect] " + ex.getMessage()), (Throwable)ex);
        }
    }
}

