/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.hq.plugin.appha;

import com.vmware.vim25.mo.Task;
import com.vmware.vim25.mo.VirtualMachine;
import java.util.Properties;
import org.hyperic.hq.plugin.appha.VSphereUtil;
import org.hyperic.hq.product.ControlPlugin;
import org.hyperic.hq.product.PluginException;
import org.hyperic.util.config.ConfigResponse;

public class VSphereVmControlPlugin
extends ControlPlugin {
    private Properties _props;

    public void configure(ConfigResponse config) throws PluginException {
        super.configure(config);
        this._props = config.toProperties();
    }

    private String getType() {
        return "VirtualMachine";
    }

    private String getVmName() {
        return this._props.getProperty("vm");
    }

    private String getUuid() {
        return this._props.getProperty("uuid");
    }

    public void doAction(String action, String[] args) throws PluginException {
        this.setResult(-1);
        VSphereUtil vim = VSphereUtil.getInstance(this.getConfig());
        try {
            Task task;
            VirtualMachine vm = (VirtualMachine)vim.findByUuid(this.getType(), this.getUuid());
            if (action.equals("createSnapshot")) {
                if (args.length < 1 || args.length > 2) {
                    throw new PluginException("Usage: name, description");
                }
                String name = args[0];
                String description = "";
                if (args.length == 2) {
                    description = args[1];
                }
                task = vm.createSnapshot_Task(name, description, true, true);
            } else if (action.equals("removeAllSnapshots")) {
                task = vm.removeAllSnapshots_Task();
            } else if (action.equals("reset")) {
                task = vm.resetVM_Task();
            } else if (action.equals("revertToCurrentSnapshot")) {
                task = vm.revertToCurrentSnapshot_Task(null);
            } else if (action.equals("stop")) {
                task = vm.powerOffVM_Task();
            } else if (action.equals("start")) {
                task = vm.powerOnVM_Task(null);
            } else if (action.equals("suspend")) {
                task = vm.suspendVM_Task();
            } else {
                if (action.equals("rebootGuest")) {
                    vm.rebootGuest();
                    this.setResult(0);
                    return;
                }
                if (action.equals("shutdownGuest")) {
                    vm.shutdownGuest();
                    this.setResult(0);
                    return;
                }
                if (action.equals("standbyGuest")) {
                    vm.standbyGuest();
                    this.setResult(0);
                    return;
                }
                if (action.equals("guestHeartbeatStatus")) {
                    this.setMessage(vm.getGuestHeartbeatStatus().toString());
                    this.setResult(0);
                    return;
                }
                throw new PluginException("Unsupported action: " + action);
            }
            String result = task.waitForMe();
            if ("success".equals(result)) {
                this.setResult(0);
            } else {
                this.setMessage(result);
            }
        }
        catch (PluginException e) {
            this.setMessage(e.getMessage());
            throw e;
        }
        catch (Exception e) {
            this.setMessage(e.getMessage());
            throw new PluginException(action + " " + this.getType() + "[name=" + this.getVmName() + ", uuid=" + this.getUuid() + "]: " + e.getMessage(), (Throwable)e);
        }
        finally {
            VSphereUtil.dispose(vim);
        }
    }
}

