/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.hq.plugin.exchange;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hyperic.util.exec.Execute;
import org.hyperic.util.exec.ExecuteStreamHandler;
import org.hyperic.util.exec.ExecuteWatchdog;
import org.hyperic.util.exec.PumpStreamHandler;

public class ExchangeDagDetector {
    private static final Log log = LogFactory.getLog(ExchangeDagDetector.class);
    private static final String POWERSHELL_COMMAND = "C:\\Windows\\System32\\WindowsPowerShell\\v1.0\\powershell.exe";

    public static String getDagName(String exchangeInstallDir, String platformName) {
        String[] command = new String[]{POWERSHELL_COMMAND, "-command", "\". '" + exchangeInstallDir + "\\bin\\RemoteExchange.ps1'; Connect-ExchangeServer -auto ; Get-DatabaseAvailabilityGroup\""};
        String commandOutput = ExchangeDagDetector.runCommand(command);
        log.debug((Object)("DAG after run command. Output: " + commandOutput));
        String dagName = ExchangeDagDetector.getDagNameFromCommandOutput(commandOutput, platformName);
        return dagName;
    }

    private static String getDagNameFromCommandOutput(String commandOutput, String platformName) {
        Pattern dagNamePattern = Pattern.compile("^(\\S+)\\s+\\{(.*)\\}", 8);
        Matcher matcher = dagNamePattern.matcher(commandOutput);
        while (matcher.find()) {
            String[] platformsArray;
            String dagName = matcher.group(1);
            String platforms = matcher.group(2);
            log.debug((Object)("Dag name: " + dagName + " Platforms: " + platforms));
            for (String platform : platformsArray = platforms.split(",")) {
                if (!platformName.equalsIgnoreCase(platform.trim())) continue;
                log.debug((Object)("Found DAG name: " + dagName));
                return dagName;
            }
        }
        log.debug((Object)"Didn't find DAG name");
        return null;
    }

    private static String runCommand(String[] command) {
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        PumpStreamHandler pumpStreamHandler = new PumpStreamHandler((OutputStream)output);
        ExecuteWatchdog wdog = new ExecuteWatchdog(20000);
        Execute exec = new Execute((ExecuteStreamHandler)pumpStreamHandler, wdog);
        exec.setCommandline(command);
        log.debug((Object)("Running: " + exec.getCommandLineString()));
        try {
            exec.execute();
        }
        catch (Exception e) {
            log.debug((Object)("Fail to run command: " + exec.getCommandLineString() + " " + e.getMessage()));
            return null;
        }
        String out = output.toString().trim();
        return out;
    }
}

