/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.hq.plugin.sybase;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.hyperic.hq.product.JDBCMeasurementPlugin;
import org.hyperic.hq.product.Metric;
import org.hyperic.hq.product.MetricInvalidException;
import org.hyperic.hq.product.MetricNotFoundException;
import org.hyperic.hq.product.MetricUnreachableException;
import org.hyperic.hq.product.MetricValue;
import org.hyperic.hq.product.PluginException;
import org.hyperic.util.StringUtil;
import org.hyperic.util.jdbc.DBUtil;

public class SybaseMeasurementPlugin
extends JDBCMeasurementPlugin {
    private final Log log = this.getLog();
    private static final String JDBC_DRIVER = "com.sybase.jdbc3.jdbc.SybDriver";
    private static final String DEFAULT_URL = "jdbc:sybase:Tds:localhost:4100/master";
    private static final String PROP_INSTANCE = "instance";
    private static final String TYPE_SP_MONITOR_CONFIG = "sp_monitorconfig";
    private static final String TYPE_STORAGE = "storage";
    private static final String PROP_DATABASE = "database";
    private static final String PROP_SEGMENT = "segment";
    private static final String PROP_PAGESIZE = "pagesize";
    private static final String PROP_CONFIG_OPTION = "configoption";
    private static final String PERCENT_ACTIVE = "utilizationratio";
    private static final String NUM_ACTIVE = "active";
    private static final String MAX_USED = "maxused";
    private static final String NUM_FREE = "free";
    private static final String NUM_REUSED = "reuse";
    private static HashMap syb12Queries = null;
    private static HashMap genericQueries = null;
    private static HashMap connectionCache = new HashMap();

    protected void getDriver() throws ClassNotFoundException {
        Class.forName(JDBC_DRIVER);
    }

    protected Connection getConnection(String url, String user, String password) throws SQLException {
        String pass = password == null ? "" : password;
        pass = pass.matches("^\\s*$") ? "" : pass;
        Properties props = new Properties();
        props.put("CHARSET_CONVERTER_CLASS", "com.sybase.jdbc3.utils.TruncationConverter");
        props.put("user", user);
        props.put("password", pass);
        return DriverManager.getConnection(url, props);
    }

    protected String getDefaultURL() {
        return DEFAULT_URL;
    }

    protected void initQueries() {
        if (genericQueries != null) {
            return;
        }
        syb12Queries = new HashMap();
        genericQueries = new HashMap();
        String baseQuery = "SELECT ";
        String baseTxQuery = "SELECT COUNT(*) FROM systransactions ";
        String baseIndQuery = "SELECT COUNT(*) FROM sysindexes ";
        genericQueries.put("NumUserTables", baseQuery + "COUNT(*) FROM sysobjects WHERE type='U'");
        genericQueries.put("NumServers", baseQuery + "COUNT(*) FROM sysservers");
        genericQueries.put("NumTx", baseTxQuery);
        genericQueries.put("NumLocalTransactions", baseTxQuery + "WHERE type=1");
        genericQueries.put("NumExternalTransactions", baseTxQuery + "WHERE type=3");
        genericQueries.put("NumRemoteTransactions", baseTxQuery + "WHERE type=98");
        genericQueries.put("NumDtxTransactions", baseTxQuery + "WHERE type=99");
        genericQueries.put("UpTime", "SELECT MAX(datediff(ss, loggedindatetime, getdate()) * 1000) FROM sysprocesses");
        genericQueries.put("InstanceUsedSpace", "select sum(u.size) * 1024 from sysusages u, sysdevices d where u.vstart between d.low and d.high and UPPER(d.name) = UPPER('%instance%')");
        genericQueries.put("InstanceFreeSpace", "select ((d.high - d.low) + 1 - sum(u.size)) * 1024 from sysusages u, sysdevices d where u.vstart between d.low and d.high and UPPER(d.name) = UPPER('%instance%')");
        genericQueries.put("InstanceTotalSpace", "select ((d.high - d.low) + 1) * 1024 from sysusages u, sysdevices d where u.vstart between d.low and d.high and UPPER(d.name) = UPPER('%instance%')");
        genericQueries.put("NumActiveLocks", baseQuery + "COUNT(*) FROM syslocks");
        genericQueries.put("NumActivePageLocks", baseQuery + "COUNT(*) FROM syslocks WHERE type = 1 OR " + "type = 2");
        genericQueries.put("NumActiveTableLocks", baseQuery + "COUNT(*) FROM syslocks WHERE type = 4 OR " + "type = 5 OR type = 6");
        genericQueries.put("ActiveUsers", baseQuery + "COUNT(*) FROM sysprocesses WHERE suid > 0");
        genericQueries.put("NumAttachedTransactions", baseTxQuery + "WHERE connection=1");
        genericQueries.put("NumDetachedTransactions", baseTxQuery + "WHERE connection=2");
        genericQueries.put("NumTxInBegun", baseTxQuery + "WHERE state=1");
        genericQueries.put("NumTxInDoneCmd", baseTxQuery + "WHERE state=2");
        genericQueries.put("NumTxInDone", baseTxQuery + "WHERE state=3");
        genericQueries.put("NumTxInPrepared", baseTxQuery + "WHERE state=4");
        genericQueries.put("NumTxInInCmd", baseTxQuery + "WHERE state=5");
        genericQueries.put("NumTxInInAbortCmd", baseTxQuery + "WHERE state=6");
        genericQueries.put("NumTxInCommitted", baseTxQuery + "WHERE state=7");
        genericQueries.put("NumTxInInPostCommit", baseTxQuery + "WHERE state=8");
        genericQueries.put("NumTxInInAbortTran", baseTxQuery + "WHERE state=9");
        genericQueries.put("NumTxInInAbortSavept", baseTxQuery + "WHERE state=10");
        genericQueries.put("NumTxInBegunDetached", baseTxQuery + "WHERE state=65537");
        genericQueries.put("NumTxInDoneCmdDetached", baseTxQuery + "WHERE state=65538");
        genericQueries.put("NumTxInDoneDetached", baseTxQuery + "WHERE state=65539");
        genericQueries.put("NumTxInPrepareDetached", baseTxQuery + "WHERE state=65540");
        genericQueries.put("NumTxInHeurCommitted", baseTxQuery + "WHERE state=65548");
        genericQueries.put("NumTxInHeurRolledBack", baseTxQuery + "WHERE state=65549");
        genericQueries.put("NumIndexes", baseIndQuery + "WHERE NOT indid=0");
        genericQueries.put("NumLobIndexes", baseIndQuery + "WHERE indid = 255");
        genericQueries.put("NumLargeRowSize", baseQuery + "MAX(exp_rowsize) FROM sysindexes");
        genericQueries.put("NumTxLogs", baseQuery + "COUNT(*) FROM syslogs");
        genericQueries.put("LargestUpdateCountOfAnyLog", baseQuery + "MAX(op) FROM syslogs");
        genericQueries.put("Availability", genericQueries.get("NumServers"));
    }

    protected String getQuery(Metric metric) {
        String instance;
        String queryVal = metric.getAttributeName();
        String query = (String)genericQueries.get(queryVal);
        if (query == null) {
            query = (String)syb12Queries.get(queryVal);
        }
        if ((instance = metric.getObjectProperties().getProperty(PROP_INSTANCE)) == null) {
            instance = metric.getProperties().getProperty(PROP_INSTANCE);
        }
        query = StringUtil.replace((String)query, (String)"%instance%", (String)instance);
        return query;
    }

    public MetricValue getValue(Metric metric) throws PluginException, MetricUnreachableException, MetricInvalidException, MetricNotFoundException {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("[getValue] metric=" + metric));
        }
        this.initQueries();
        String objectName = metric.getObjectName();
        String alias = metric.getAttributeName();
        if (objectName.indexOf(TYPE_SP_MONITOR_CONFIG) == -1 && objectName.indexOf(TYPE_STORAGE) == -1 && !metric.isAvail()) {
            return super.getValue(metric);
        }
        Properties props = metric.getProperties();
        String url = props.getProperty("jdbcUrl");
        String user = props.getProperty("jdbcUser");
        String pass = props.getProperty("jdbcPassword");
        if (url == null) {
            throw new MetricUnreachableException("URL = null");
        }
        MetricValue res = null;
        Connection conn = null;
        try {
            conn = this.getCachedConnection(url, user, pass);
        }
        catch (SQLException e) {
            this.removeCachedConnection(url, user, pass);
            DBUtil.closeConnection((Object)"[getValue]", (Connection)conn);
            String msg = "Commection failed for '" + alias + "': " + e.getMessage();
            throw new MetricNotFoundException(msg, (Throwable)e);
        }
        try {
            if (objectName.indexOf(TYPE_SP_MONITOR_CONFIG) != -1) {
                res = this.getSP_MonitorConfigValue(metric, alias, conn);
            } else if (objectName.indexOf(TYPE_STORAGE) != -1) {
                res = this.getStorageValue(metric, alias, conn);
            } else if (metric.isAvail()) {
                res = this.getAvailability(conn);
            }
        }
        catch (SQLException e) {
            this.removeCachedConnection(url, user, pass);
            DBUtil.closeConnection(null, (Connection)conn);
            String msg = "Query failed for '" + alias + "': " + e.getMessage();
            if (metric.isAvail()) {
                res = new MetricValue(0.0);
            }
            throw new MetricNotFoundException(msg, (Throwable)e);
        }
        if (res == null) {
            throw new MetricNotFoundException("cannot find metric " + metric);
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("[getValue] alias='" + alias + "' res='" + res + "' metric=" + metric));
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MetricValue getAvailability(Connection conn) {
        Statement stmt = null;
        ResultSet rs = null;
        double res = 0.0;
        try {
            stmt = conn.createStatement();
            String sql = (String)genericQueries.get("NumServers");
            rs = stmt.executeQuery(sql);
            res = 1.0;
        }
        catch (SQLException e) {
            try {
                this.log.debug((Object)("Query failed for Availability " + e.getMessage()), (Throwable)e);
            }
            catch (Throwable throwable) {
                DBUtil.closeJDBCObjects((Object)this.log, null, (Statement)stmt, rs);
                throw throwable;
            }
            DBUtil.closeJDBCObjects((Object)this.log, null, (Statement)stmt, (ResultSet)rs);
        }
        DBUtil.closeJDBCObjects((Object)this.log, null, (Statement)stmt, (ResultSet)rs);
        return new MetricValue(res, System.currentTimeMillis());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private MetricValue getStorageValue(Metric metric, String attr, Connection conn) throws SQLException, MetricNotFoundException {
        MetricValue res;
        ResultSet rs;
        Statement stmt;
        block12: {
            String database = metric.getObjectProperty(PROP_DATABASE);
            String segment = metric.getObjectProperty(PROP_SEGMENT);
            int pagesize = Integer.parseInt(metric.getObjectProperty(PROP_PAGESIZE));
            stmt = null;
            rs = null;
            res = null;
            try {
                stmt = conn.createStatement();
                stmt.execute("use " + database);
                stmt.execute("sp_helpsegment '" + segment + "'");
                rs = this.getResultSet(stmt, "total_pages");
                if (rs.next()) {
                    long total_pages = rs.getLong("total_pages");
                    long free_pages = rs.getLong("free_pages");
                    long used_pages = rs.getLong("used_pages");
                    if (attr.equals("PercentUsed")) {
                        float percent_used = this.getSegmentSize(used_pages, pagesize) / this.getSegmentSize(total_pages, pagesize);
                        res = new MetricValue((double)percent_used, System.currentTimeMillis());
                    } else if (attr.equals("StorageUsed")) {
                        float storage_used = this.getSegmentSize(used_pages, pagesize);
                        res = new MetricValue((double)storage_used, System.currentTimeMillis());
                    } else {
                        if (!metric.isAvail()) throw new MetricNotFoundException("[getStorageValue] Metric => '" + attr + "'");
                        res = new MetricValue(1.0, System.currentTimeMillis());
                    }
                } else {
                    res = new MetricValue(0.0, System.currentTimeMillis());
                }
                if (stmt == null) break block12;
            }
            catch (SQLException e) {
                if (!metric.isAvail()) throw e;
                res = new MetricValue(0.0, System.currentTimeMillis());
                return res;
            }
            finally {
                if (stmt != null) {
                    stmt.execute("use master");
                }
                DBUtil.closeJDBCObjects((Object)this.log, null, (Statement)stmt, rs);
            }
            stmt.execute("use master");
        }
        DBUtil.closeJDBCObjects((Object)this.log, null, (Statement)stmt, (ResultSet)rs);
        return res;
    }

    private ResultSet getResultSet(Statement stmt, String col) throws SQLException {
        while (true) {
            ResultSet rs = null;
            try {
                rs = stmt.getResultSet();
                if (rs != null) {
                    rs.findColumn(col);
                    return rs;
                }
            }
            catch (SQLException e) {
                if (stmt.getMoreResults() && stmt.getUpdateCount() != -1) continue;
            }
            break;
        }
        throw new SQLException();
    }

    private void printMetaCols(ResultSetMetaData md) throws SQLException {
        for (int i = 1; i <= md.getColumnCount(); ++i) {
            System.out.println(md.getColumnName(i));
        }
    }

    private float getSegmentSize(long pages, int pagesize) {
        return pages / 1024L * (long)pagesize / 1024L;
    }

    private MetricValue getSP_MonitorConfigValue(Metric metric, String alias, Connection conn) throws SQLException, MetricNotFoundException, MetricUnreachableException {
        String configOpt = metric.getObjectProperty(PROP_CONFIG_OPTION);
        float value = -1.0f;
        if (alias.equalsIgnoreCase(MAX_USED)) {
            value = this.getMaxUsed(conn, configOpt);
        } else if (alias.equalsIgnoreCase(NUM_REUSED)) {
            value = this.getNumReuse(conn, configOpt);
        } else if (alias.equalsIgnoreCase(NUM_FREE)) {
            value = this.getNumFree(conn, configOpt);
        } else if (alias.equalsIgnoreCase(NUM_ACTIVE)) {
            value = this.getNumActive(conn, configOpt);
        } else if (alias.equalsIgnoreCase(PERCENT_ACTIVE)) {
            value = this.getPercentActive(conn, configOpt);
        } else if (metric.isAvail()) {
            value = (float)this.getAvail(conn, configOpt);
        } else {
            throw new MetricNotFoundException(alias);
        }
        return new MetricValue((double)value, System.currentTimeMillis());
    }

    private float getNumActive(Connection conn, String configOpt) throws MetricUnreachableException, MetricNotFoundException {
        return this.getMonitorConfigValue(conn, configOpt, "Num_active");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private double getAvail(Connection conn, String configOpt) {
        ResultSet rs;
        Statement stmt;
        double res;
        block4: {
            res = 0.0;
            stmt = null;
            rs = null;
            try {
                stmt = conn.createStatement();
                rs = stmt.executeQuery("sp_monitorconfig '" + configOpt + "'");
                if (!rs.next()) break block4;
                res = 1.0;
            }
            catch (SQLException e) {
                try {
                    this.log.debug((Object)("[getAvail] configOpt='" + configOpt + "' -> " + e.getMessage()));
                }
                catch (Throwable throwable) {
                    DBUtil.closeJDBCObjects((Object)this.log, null, (Statement)stmt, rs);
                    throw throwable;
                }
                DBUtil.closeJDBCObjects((Object)this.log, null, (Statement)stmt, (ResultSet)rs);
            }
        }
        DBUtil.closeJDBCObjects((Object)this.log, null, (Statement)stmt, (ResultSet)rs);
        return res;
    }

    private float getNumFree(Connection conn, String configOpt) throws MetricUnreachableException, MetricNotFoundException {
        return this.getMonitorConfigValue(conn, configOpt, "Num_free");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private float getNumReuse(Connection conn, String configOpt) throws SQLException {
        ResultSet rs;
        Statement stmt;
        block3: {
            float f;
            stmt = null;
            rs = null;
            try {
                stmt = conn.createStatement();
                rs = stmt.executeQuery("sp_monitorconfig '" + configOpt + "'");
                ResultSetMetaData rsmd = rs.getMetaData();
                String reuseCol = "Num_Reuse";
                for (int i = 1; i <= rsmd.getColumnCount(); ++i) {
                    String name = rsmd.getColumnName(i);
                    if (name.indexOf("Reuse") == -1) continue;
                    reuseCol = name;
                }
                int col = rs.findColumn(reuseCol);
                if (!rs.next()) break block3;
                f = rs.getFloat(col);
            }
            catch (Throwable throwable) {
                DBUtil.closeJDBCObjects((Object)this.log, null, (Statement)stmt, rs);
                throw throwable;
            }
            DBUtil.closeJDBCObjects((Object)this.log, null, (Statement)stmt, (ResultSet)rs);
            return f;
        }
        DBUtil.closeJDBCObjects((Object)this.log, null, (Statement)stmt, (ResultSet)rs);
        throw new SQLException();
    }

    private float getMaxUsed(Connection conn, String configOpt) throws MetricUnreachableException, MetricNotFoundException {
        return this.getMonitorConfigValue(conn, configOpt, "Max_Used");
    }

    private float getPercentActive(Connection conn, String configOpt) throws MetricUnreachableException, MetricNotFoundException {
        return this.getMonitorConfigValue(conn, configOpt, "Pct_act");
    }

    private float getMonitorConfigValue(Connection conn, String configOpt, String prop) throws MetricUnreachableException, MetricNotFoundException {
        ResultSet rs;
        Statement stmt;
        block5: {
            stmt = null;
            rs = null;
            stmt = conn.createStatement();
            rs = stmt.executeQuery("sp_monitorconfig '" + configOpt + "'");
            if (!rs.next()) break block5;
            float f = rs.getFloat(prop);
            DBUtil.closeJDBCObjects((Object)this.log, null, (Statement)stmt, (ResultSet)rs);
            return f;
        }
        try {
            try {
                throw new MetricNotFoundException(prop);
            }
            catch (SQLException e) {
                throw new MetricUnreachableException(e.getMessage(), (Throwable)e);
            }
        }
        catch (Throwable throwable) {
            DBUtil.closeJDBCObjects((Object)this.log, null, (Statement)stmt, rs);
            throw throwable;
        }
    }
}

