/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.hq.plugin.mssql;

import java.util.Arrays;
import java.util.Enumeration;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hyperic.hq.plugin.mssql.MsSQLDataBaseCollector;
import org.hyperic.hq.plugin.mssql.PDH;
import org.hyperic.hq.product.Collector;
import org.hyperic.hq.product.MeasurementPlugin;
import org.hyperic.hq.product.Metric;
import org.hyperic.hq.product.MetricNotFoundException;
import org.hyperic.hq.product.MetricUnreachableException;
import org.hyperic.hq.product.MetricValue;
import org.hyperic.hq.product.PluginException;
import org.hyperic.sigar.Sigar;
import org.hyperic.sigar.win32.Service;
import org.hyperic.sigar.win32.Win32Exception;
import org.hyperic.util.config.ConfigResponse;

public class MsSQLMeasurementPlugin
extends MeasurementPlugin {
    private static Log log = LogFactory.getLog(MsSQLMeasurementPlugin.class);
    static final String DEFAULT_SQLSERVER_METRIC_PREFIX = "SQLServer";
    static final String DEFAULT_SQLAGENT_METRIC_PREFIX = "SQLAgent";

    public String translate(String template, ConfigResponse config) {
        template = super.translate(template, config);
        log.debug((Object)("[translate] > template = " + template));
        if (template.contains(":collector:")) {
            int lastSemiColon = template.lastIndexOf(58);
            template = template.substring(0, lastSemiColon) + ',' + template.substring(lastSemiColon + 1);
        }
        log.debug((Object)("[translate] < template = " + template));
        return template;
    }

    public MetricValue getValue(Metric metric) throws PluginException, MetricNotFoundException, MetricUnreachableException {
        if (metric.getDomainName().equalsIgnoreCase("collector")) {
            return Collector.getValue((MeasurementPlugin)this, (Metric)metric);
        }
        if (metric.getDomainName().equalsIgnoreCase("pdh")) {
            return this.getPDHMetric(metric);
        }
        if (metric.getDomainName().equalsIgnoreCase("pdh2")) {
            return this.getPDHInstaceMetric(metric);
        }
        if (metric.getDomainName().equalsIgnoreCase("pdhDBAvail")) {
            return this.getPDHDBAvailMetric(metric);
        }
        if (metric.getDomainName().equalsIgnoreCase("service")) {
            return this.checkServiceAvail(metric);
        }
        if (metric.getDomainName().equalsIgnoreCase("mssql")) {
            if (metric.getObjectPropString().equals("process")) {
                return this.getInstanceProcessMetric(metric);
            }
            this.getLog().debug((Object)("Unable to retrieve value for: " + metric));
            return MetricValue.NONE;
        }
        if (metric.getDomainName().equalsIgnoreCase("dfp")) {
            return Collector.getValue((MeasurementPlugin)this, (Metric)metric);
        }
        this.getLog().debug((Object)("Unable to retrieve value for: " + metric.getAttributeName()));
        return MetricValue.NONE;
    }

    public Collector getNewCollector() {
        if (!this.getPluginData().getPlugin("collector", "MsSQL 2012 Database").equals(MsSQLDataBaseCollector.class.getName())) {
            this.getPluginData().addPlugin("collector", "MsSQL 2012 Database", MsSQLDataBaseCollector.class.getName());
            this.getPluginData().addPlugin("collector", "MsSQL 2008 Database", MsSQLDataBaseCollector.class.getName());
            this.getPluginData().addPlugin("collector", "MsSQL 2008 R2 Database", MsSQLDataBaseCollector.class.getName());
            this.getPluginData().addPlugin("collector", "MsSQL 2005 Database", MsSQLDataBaseCollector.class.getName());
        }
        Collector c = super.getNewCollector();
        this.getLog().debug((Object)("[getNewCollector] t:'" + this.getTypeInfo().getName() + "' c:" + c.getClass().getName()));
        return c;
    }

    private MetricValue getInstanceProcessMetric(Metric metric) {
        try {
            log.debug((Object)("[gipm] metric='" + metric + "'"));
            String serviceName = metric.getProperties().getProperty("service_name");
            Sigar sigar = new Sigar();
            long servicePID = sigar.getServicePid(serviceName);
            log.debug((Object)("[gipm] serviceName='" + serviceName + "' servicePID='" + servicePID + "'"));
            List<String> instances = Arrays.asList(PDH.getInstances("Process"));
            String serviceInstance = null;
            for (int i = 0; i < instances.size() && serviceInstance == null; ++i) {
                String instance = instances.get(i);
                if (!instance.startsWith("sqlservr")) continue;
                String obj = "\\Process(" + instance + ")\\ID Process";
                log.debug((Object)("[gipm] obj='" + obj + "'"));
                double pid = PDH.getValue(obj);
                if (pid != (double)servicePID) continue;
                serviceInstance = instance;
                log.debug((Object)("[gipm] serviceName='" + serviceName + "' serviceInstance='" + serviceInstance + "'"));
            }
            if (serviceInstance != null) {
                String obj = "\\Process(" + serviceInstance + ")\\" + metric.getAttributeName();
                log.debug((Object)("[gipm] obj = '" + obj + "'"));
                double res = PDH.getValue(obj);
                log.debug((Object)("[getPDH] obj:'" + obj + "' val:'" + res + "'"));
                return new MetricValue(res);
            }
            log.debug((Object)("[gipm] Process for serviceName='" + serviceName + "' not found, returning " + MetricValue.NONE.getValue()));
            return MetricValue.NONE;
        }
        catch (Exception ex) {
            log.debug((Object)("[gipm] " + ex), (Throwable)ex);
            return MetricValue.NONE;
        }
    }

    private MetricValue checkServiceAvail(Metric metric) {
        String service = metric.getObjectProperty("service_name");
        log.debug((Object)("[checkServiceAvail] service='" + service + "'"));
        double res = 0.0;
        try {
            if (service != null) {
                Service s = new Service(service);
                if (s.getStatus() == 4) {
                    res = 1.0;
                }
                log.debug((Object)("[checkServiceAvail] service='" + service + "' metric:'" + metric + "' res=" + res));
            }
        }
        catch (Win32Exception ex) {
            log.debug((Object)("[checkServiceAvail] error. service='" + service + "' metric:'" + metric + "'"), (Throwable)ex);
        }
        return new MetricValue(res);
    }

    private MetricValue getPDHDBAvailMetric(Metric metric) {
        String dbName = metric.getObjectProperty("db.name");
        String service = metric.getProperties().getProperty("service_name");
        if ("MSSQLSERVER".equalsIgnoreCase(service)) {
            log.debug((Object)("[getPDHDBAvailMetric] service='" + service + "' ==> ='" + "MSSQLSERVER" + "''"));
            service = DEFAULT_SQLSERVER_METRIC_PREFIX;
        }
        String obj = service + ":Databases";
        log.debug((Object)("[getPDHDBAvailMetric] dbName='" + dbName + "' service='" + service + "' obj='" + obj + "'"));
        double res = 0.0;
        try {
            if (dbName != null) {
                List<String> instances = Arrays.asList(PDH.getInstances(obj));
                if (instances.contains(dbName)) {
                    res = 1.0;
                }
                log.debug((Object)("[getPDHDBAvailMetric] service='" + service + "' dbName:'" + dbName + "' res=" + res));
            }
        }
        catch (PluginException ex) {
            log.debug((Object)("[getPDHDBAvailMetric] error. service='" + service + "' dbName:'" + dbName + "'"), (Throwable)ex);
        }
        return new MetricValue(res);
    }

    private MetricValue getPDHInstaceMetric(Metric metric) {
        String obj = "\\" + metric.getObjectPropString();
        obj = obj + "\\" + metric.getAttributeName();
        Enumeration<Object> ks = metric.getProperties().keys();
        while (ks.hasMoreElements()) {
            String k = (String)ks.nextElement();
            String v = metric.getProperties().getProperty(k);
            obj = obj.replaceAll("%" + k + "%", v);
        }
        this.getPDH(obj, metric);
        return this.getPDH(obj, metric);
    }

    private MetricValue getPDHMetric(Metric metric) {
        String prefix = metric.getProperties().getProperty("pref_prefix");
        if (prefix == null) {
            prefix = metric.getProperties().getProperty("service_name");
        }
        if ("MSSQLSERVER".equalsIgnoreCase(prefix)) {
            prefix = DEFAULT_SQLSERVER_METRIC_PREFIX;
        }
        String obj = "\\" + prefix + ":" + metric.getObjectPropString();
        if (!metric.isAvail()) {
            obj = obj + "\\" + metric.getAttributeName();
        }
        return this.getPDH(obj, metric);
    }

    private MetricValue getPDH(String obj, Metric metric) {
        MetricValue res;
        try {
            double val = PDH.getValue(obj);
            log.debug((Object)("[getPDH] obj:'" + obj + "' val:'" + val + "'"));
            res = new MetricValue(val);
            if (metric.isAvail()) {
                res = new MetricValue(1.0);
            }
        }
        catch (Exception ex) {
            if (metric.isAvail()) {
                res = new MetricValue(0.0);
                log.debug((Object)("[getPDH] error on metric:'" + metric + "' (obj:" + obj + ") :" + ex.getLocalizedMessage()), (Throwable)ex);
            }
            res = MetricValue.NONE;
            log.debug((Object)("[getPDH] error on metric:'" + metric + "' (obj:" + obj + ") :" + ex.getLocalizedMessage()));
        }
        return res;
    }
}

