/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.hq.plugin.mssql;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hyperic.hq.product.PluginException;
import org.hyperic.hq.product.Win32ControlPlugin;
import org.hyperic.sigar.win32.Service;
import org.hyperic.sigar.win32.Win32Exception;

public class MsSQLControlPlugin
extends Win32ControlPlugin {
    private static final String DEFAULT_SQLSERVER_SERVICE_NAME = "MSSQLSERVER";
    private static final String DEFAULT_SQLAGENT_SERVICE_NAME = "SQLSERVERAGENT";
    private static final Log log = LogFactory.getLog(MsSQLControlPlugin.class);

    public void doAction(String action) throws PluginException {
        String sqlAgentServiceName = DEFAULT_SQLAGENT_SERVICE_NAME;
        String sqlServerServiceName = this.getServiceName();
        if (!sqlServerServiceName.equals(DEFAULT_SQLSERVER_SERVICE_NAME)) {
            sqlAgentServiceName = sqlServerServiceName.replaceFirst("MSSQL", "SQLAgent");
        }
        Service sqlAgent = null;
        try {
            sqlAgent = new Service(sqlAgentServiceName);
        }
        catch (Win32Exception e) {
            log.debug((Object)("Could not find SqlAgent service " + sqlAgentServiceName + ": " + (Object)((Object)e)), (Throwable)e);
        }
        try {
            if (action.equals("start")) {
                if (null != sqlAgent) {
                    log.debug((Object)("About to start SqlAgent service " + sqlAgentServiceName));
                    sqlAgent.start();
                } else {
                    log.debug((Object)("About to start SqlServer service " + sqlServerServiceName));
                    this.svc.start();
                }
                this.setResult(0);
                return;
            }
            if (action.equals("stop")) {
                if (null != sqlAgent && this.isServiceRunning(sqlAgent)) {
                    log.debug((Object)("About to stop SqlAgent service " + sqlAgentServiceName));
                    sqlAgent.stop((long)this.getTimeoutMillis());
                }
                if (this.isRunning()) {
                    log.debug((Object)("About to stop SqlServer service " + sqlServerServiceName));
                    this.svc.stop();
                }
                this.setResult(0);
                return;
            }
            if (action.equals("restart")) {
                if (null != sqlAgent && this.isServiceRunning(sqlAgent)) {
                    sqlAgent.stop((long)this.getTimeoutMillis());
                }
                if (this.isRunning()) {
                    this.svc.stop((long)this.getTimeoutMillis());
                }
                if (null != sqlAgent) {
                    sqlAgent.start();
                } else {
                    this.svc.start();
                }
                this.setResult(0);
                return;
            }
        }
        catch (Win32Exception e) {
            this.setResult(-1);
            throw new PluginException(action + " " + this.getServiceName() + " failed: " + e.getMessage());
        }
        throw new PluginException("Action '" + action + "' not supported");
    }

    private boolean isServiceRunning(Service service) {
        int status = service.getStatus();
        return status == 2 || status == 4 || status == 3;
    }
}

