/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.hq.plugin.mssql;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hyperic.util.exec.Execute;
import org.hyperic.util.exec.ExecuteStreamHandler;
import org.hyperic.util.exec.PumpStreamHandler;

public class ClusterDetect {
    private static final Log log = LogFactory.getLog(ClusterDetect.class);
    private static final Pattern CLUSTER_NAME_PATTERN = Pattern.compile("Listing properties for '(.*)'", 2);
    public static final String CLUSTER_NAME_PROP = "cluster name";
    public static final String NETWORK_NAME_PROP = "network name";
    public static final String NODES_PROP = "nodes";
    public static final String IP_ADDRESS_PROP = "ip address";
    private static final String APPCMD = "C:/Windows/System32/cluster.exe";

    public static Properties getMssqlClusterProps(String instanceName) {
        String clusterName = ClusterDetect.getClusterName();
        if (clusterName == null) {
            log.debug((Object)"Cluster name not found");
            return null;
        }
        log.debug((Object)("Cluster name: " + clusterName));
        String clusterResources = ClusterDetect.runCommand(new String[]{APPCMD, "res", "/priv"});
        log.debug((Object)("Cluster resources: " + clusterResources));
        String sqlServerResource = ClusterDetect.getSqlServerResource(clusterResources, instanceName);
        if (sqlServerResource == null) {
            log.debug((Object)"SQL server resource is null");
            return null;
        }
        log.debug((Object)("SQL server resource: " + sqlServerResource));
        String networkName = ClusterDetect.getNetworkNameFromResource(sqlServerResource, clusterResources);
        if (networkName == null) {
            log.debug((Object)"Network name is null");
            return null;
        }
        log.debug((Object)("Network name: " + networkName));
        Properties props = new Properties();
        props.put(CLUSTER_NAME_PROP, clusterName);
        props.put(NETWORK_NAME_PROP, networkName);
        String clusterNodes = ClusterDetect.getClusterNodes();
        props.put(NODES_PROP, clusterNodes);
        return props;
    }

    private static String getClusterNodes() {
        String clusterNodesOutput = ClusterDetect.runCommand(new String[]{APPCMD, "node"});
        String result = "";
        Pattern nodeTablePattern = Pattern.compile("(\\-+)\\s+(\\-+)\\s+(\\-+)(.+)", 32);
        Matcher matcher = nodeTablePattern.matcher(clusterNodesOutput);
        if (!matcher.find()) {
            return result;
        }
        String table = matcher.group(4);
        Pattern nodeNamePattern = Pattern.compile("^(\\S+)\\s+", 8);
        Matcher nameMatcher = nodeNamePattern.matcher(table);
        boolean isFirst = true;
        while (nameMatcher.find()) {
            if (!isFirst) {
                result = result + ",";
            }
            result = result + nameMatcher.group(1);
            isFirst = false;
        }
        return result;
    }

    private static String getSqlServerResource(String clusterResources, String instanceName) {
        Pattern sqlServerResourcePattern = Pattern.compile("^(\\w+)\\s+(.+\\S)\\s+InstanceName\\s+" + instanceName, 10);
        Matcher matcher = sqlServerResourcePattern.matcher(clusterResources);
        if (!matcher.find()) {
            return null;
        }
        String sqlServerResource = matcher.group(2);
        return sqlServerResource;
    }

    private static String getNetworkNameFromResource(String networkNameResource, String clusterResources) {
        Pattern sqlNetworkNamePattern = Pattern.compile(Pattern.quote(networkNameResource) + "\\s+VirtualServerName\\s+(\\S+)", 2);
        Matcher matcher = sqlNetworkNamePattern.matcher(clusterResources);
        if (!matcher.find()) {
            return null;
        }
        String networkName = matcher.group(1);
        return networkName;
    }

    private static String getClusterName() {
        String output = ClusterDetect.runCommand(new String[]{APPCMD, "/prop"});
        if (output == null) {
            return null;
        }
        Matcher matcher = CLUSTER_NAME_PATTERN.matcher(output);
        if (!matcher.find()) {
            return null;
        }
        String clusterName = matcher.group(1);
        return clusterName;
    }

    private static String runCommand(String[] command) {
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        Execute exec = new Execute((ExecuteStreamHandler)new PumpStreamHandler((OutputStream)output));
        exec.setCommandline(command);
        try {
            exec.execute();
        }
        catch (Exception e) {
            log.warn((Object)("Failed to run command: " + exec.getCommandLineString()), (Throwable)e);
            return null;
        }
        String out = output.toString().trim();
        return out;
    }
}

