/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.hq.plugin.bind;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hyperic.hq.product.AutoServerDetector;
import org.hyperic.hq.product.PluginException;
import org.hyperic.hq.product.ServerDetector;
import org.hyperic.hq.product.ServerResource;
import org.hyperic.util.config.ConfigResponse;

public class BindServerDetector
extends ServerDetector
implements AutoServerDetector {
    private static final String PTQL_QUERY = "State.Name.eq=named";
    private Log log = LogFactory.getLog((String)"BindServerDetector");

    private static String getServerProcess() {
        String exe;
        long[] pids = BindServerDetector.getPids((String)PTQL_QUERY);
        if (pids.length == 1 && (exe = BindServerDetector.getProcExe((long)pids[0])) != null) {
            return exe;
        }
        return null;
    }

    public List getServerResources(ConfigResponse platformConfig) throws PluginException {
        ArrayList<ServerResource> servers = new ArrayList<ServerResource>();
        String named = BindServerDetector.getServerProcess();
        if (named != null) {
            String version;
            String rndc = new File(BindServerDetector.getParentDir((String)named, (int)1), "rndc").getAbsolutePath();
            try {
                String[] argv = new String[]{named, "-version"};
                Process proc = Runtime.getRuntime().exec(argv);
                BufferedReader in = new BufferedReader(new InputStreamReader(proc.getInputStream()));
                version = in.readLine();
                if (version == null) {
                    throw new PluginException("Unable to determine Bind version");
                }
                if (version.indexOf("9.") == -1) {
                    this.log.info((Object)("Found unsupported version of Bind (" + version + ")"));
                    return servers;
                }
                try {
                    in.close();
                }
                catch (IOException e) {}
            }
            catch (IOException e) {
                throw new PluginException("Unable to dermine Bind version: " + e);
            }
            ServerResource server = this.createServerResource(named);
            server.setName(BindServerDetector.getPlatformName() + " " + version);
            ConfigResponse productConfig = new ConfigResponse();
            productConfig.setValue("rndc", rndc);
            productConfig.setValue("named.stats", "/var/named/named.stats");
            productConfig.setValue("process.query", PTQL_QUERY);
            server.setProductConfig(productConfig);
            server.setMeasurementConfig();
            servers.add(server);
        }
        return servers;
    }
}

