/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.hq.plugin.bind;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.RandomAccessFile;
import java.util.HashMap;
import java.util.Properties;
import org.hyperic.hq.product.Metric;
import org.hyperic.hq.product.MetricNotFoundException;
import org.hyperic.hq.product.MetricUnreachableException;
import org.hyperic.hq.product.MetricValue;
import org.hyperic.hq.product.PluginException;
import org.hyperic.hq.product.SigarMeasurementPlugin;

public class BindMeasurementPlugin
extends SigarMeasurementPlugin {
    static final String PROP_RNDC = "rndc";
    static final String PROP_NAMED_STATS = "named.stats";
    private static final HashMap queryInfo = new HashMap();

    private static void processStatsFile(File file) throws MetricNotFoundException {
        BufferedReader in = null;
        try {
            String line;
            in = new BufferedReader(new FileReader(file));
            while ((line = in.readLine()) != null) {
                Double val;
                String trimmed = line.trim();
                if (trimmed.startsWith("success")) {
                    val = new Double(trimmed.substring(8, trimmed.length()));
                    queryInfo.put("SuccessfulQueries", val);
                    continue;
                }
                if (trimmed.startsWith("referral")) {
                    val = new Double(trimmed.substring(9, trimmed.length()));
                    queryInfo.put("ReferralQueries", val);
                    continue;
                }
                if (trimmed.startsWith("nxrrset")) {
                    val = new Double(trimmed.substring(8, trimmed.length()));
                    queryInfo.put("NoRecordQueries", val);
                    continue;
                }
                if (trimmed.startsWith("nxdomain")) {
                    val = new Double(trimmed.substring(9, trimmed.length()));
                    queryInfo.put("NoDomainQueries", val);
                    continue;
                }
                if (trimmed.startsWith("recursion")) {
                    val = new Double(trimmed.substring(10, trimmed.length()));
                    queryInfo.put("RecursiveQueries", val);
                    continue;
                }
                if (trimmed.startsWith("failure")) {
                    val = new Double(trimmed.substring(8, trimmed.length()));
                    queryInfo.put("FailedQueries", val);
                    continue;
                }
                if (trimmed.endsWith("queries resulted in successful answer")) {
                    val = new Double(trimmed.substring(0, trimmed.indexOf(32)));
                    queryInfo.put("SuccessfulQueries", val);
                    continue;
                }
                if (trimmed.endsWith("queries resulted in referral")) {
                    val = new Double(trimmed.substring(0, trimmed.indexOf(32)));
                    queryInfo.put("ReferralQueries", val);
                    continue;
                }
                if (trimmed.endsWith("queries resulted in nxrrset")) {
                    val = new Double(trimmed.substring(0, trimmed.indexOf(32)));
                    queryInfo.put("NoRecordQueries", val);
                    continue;
                }
                if (trimmed.endsWith("queries resulted in NXDOMAIN")) {
                    val = new Double(trimmed.substring(0, trimmed.indexOf(32)));
                    queryInfo.put("NoDomainQueries", val);
                    continue;
                }
                if (trimmed.endsWith("queries caused recursion")) {
                    val = new Double(trimmed.substring(0, trimmed.indexOf(32)));
                    queryInfo.put("RecursiveQueries", val);
                    continue;
                }
                if (!trimmed.endsWith("queries resulted in SERVFAIL")) continue;
                val = new Double(trimmed.substring(0, trimmed.indexOf(32)));
                queryInfo.put("FailedQueries", val);
            }
        }
        catch (IOException e) {
            throw new MetricNotFoundException("Unable to process rndc output: " + e);
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException e) {}
            }
        }
    }

    public void getQueryInfo(Properties props) throws MetricNotFoundException {
        Process proc;
        String rndc = props.getProperty(PROP_RNDC);
        String namedStats = props.getProperty(PROP_NAMED_STATS);
        File statsFile = new File(namedStats);
        if (!statsFile.exists()) {
            throw new MetricNotFoundException("Stats file " + namedStats + " does not exist.  Please " + "create this file and make " + "sure it is writeable by " + "the agent process");
        }
        if (!statsFile.canWrite()) {
            throw new MetricNotFoundException("Stats file " + namedStats + " is not writable by agent " + "process.");
        }
        try {
            String mode = "rws";
            RandomAccessFile toTrunc = new RandomAccessFile(statsFile, mode);
            toTrunc.setLength(0L);
            toTrunc.close();
        }
        catch (IOException e) {
            throw new MetricNotFoundException("IO Error reading stats file: " + e);
        }
        try {
            String[] argv = new String[]{rndc, "stats"};
            proc = Runtime.getRuntime().exec(argv);
            BufferedReader err = new BufferedReader(new InputStreamReader(proc.getErrorStream()));
            String line = err.readLine();
            if (line != null) {
                throw new MetricNotFoundException("Unable to exec process: " + line);
            }
            try {
                err.close();
            }
            catch (IOException e) {}
        }
        catch (IOException e) {
            throw new MetricNotFoundException("Unable to exec process: " + e);
        }
        try {
            proc.waitFor();
        }
        catch (InterruptedException e) {
            // empty catch block
        }
        BindMeasurementPlugin.processStatsFile(statsFile);
    }

    public MetricValue getValue(Metric metric) throws PluginException, MetricNotFoundException, MetricUnreachableException {
        String domain = metric.getDomainName();
        String attr = metric.getAttributeName();
        if (domain.equals("sigar.ptql")) {
            return super.getValue(metric);
        }
        Double val = (Double)queryInfo.get(attr);
        if (val == null) {
            this.getQueryInfo(metric.getProperties());
            val = (Double)queryInfo.get(attr);
            if (val == null) {
                throw new MetricNotFoundException("No metric mapped to  metric: " + attr);
            }
        }
        queryInfo.remove(attr);
        return new MetricValue(val.doubleValue(), System.currentTimeMillis());
    }

    public static void main(String[] args) throws Exception {
        if (args.length == 1) {
            File statsFile = new File(args[0]);
            if (!statsFile.exists()) {
                System.err.println("Unable to find stats file " + statsFile);
            } else {
                System.out.println("Parsing stats file: " + args[0]);
                BindMeasurementPlugin.processStatsFile(statsFile);
                for (String key : queryInfo.keySet()) {
                    System.out.println(key + "=" + queryInfo.get(key));
                }
                System.out.println("Done");
            }
        } else {
            System.err.println("Usage: BindMeasurementPlugin <stats.file>");
        }
    }
}

