/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.hq.autoinventory.agent.server;

import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hyperic.hq.agent.AgentRemoteException;
import org.hyperic.hq.agent.AgentRemoteValue;
import org.hyperic.hq.agent.diagnostics.AgentDiagnosticObject;
import org.hyperic.hq.agent.diagnostics.AgentDiagnostics;
import org.hyperic.hq.agent.server.AgentDaemon;
import org.hyperic.hq.agent.server.AgentRunningException;
import org.hyperic.hq.agent.server.AgentStorageException;
import org.hyperic.hq.agent.server.AgentStorageProvider;
import org.hyperic.hq.agent.server.ConfigStorage;
import org.hyperic.hq.appdef.shared.AIPlatformValue;
import org.hyperic.hq.autoinventory.AutoinventoryException;
import org.hyperic.hq.autoinventory.CompositeRuntimeResourceReport;
import org.hyperic.hq.autoinventory.RuntimeScanner;
import org.hyperic.hq.autoinventory.Scanner;
import org.hyperic.hq.autoinventory.agent.server.AutoinventoryCommandsServer;
import org.hyperic.hq.autoinventory.agent.server.RuntimeReportFilter;
import org.hyperic.hq.bizapp.client.AutoinventoryCallbackClient;
import org.hyperic.hq.product.AutoinventoryPluginManager;
import org.hyperic.hq.product.PlatformResource;
import org.hyperic.hq.product.PluginException;
import org.hyperic.hq.product.PluginNotFoundException;
import org.hyperic.hq.product.RuntimeDiscoverer;
import org.hyperic.hq.product.RuntimeResourceReport;
import org.hyperic.hq.product.ServerDetector;
import org.hyperic.util.PluginLoader;
import org.hyperic.util.config.ConfigResponse;
import org.hyperic.util.timer.StopWatch;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class RuntimeAutodiscoverer
implements RuntimeScanner,
AgentDiagnosticObject {
    private static final long DEFAULT_SCAN_INTERVAL = 900000L;
    private static final String STORAGE_PREFIX = "runtimeautodiscovery";
    private static final String STORAGE_KEYLIST = "runtimeAD-keylist";
    private static final String SERVICE_PREFIX = "service-config";
    private static final String SERVICE_KEYLIST = "service-keylist";
    private static Log _log = LogFactory.getLog(RuntimeAutodiscoverer.class);
    private AutoinventoryCommandsServer _aicmd;
    private AgentDaemon _agent;
    private AutoinventoryCallbackClient _client;
    private AutoinventoryPluginManager _apm;
    private ConfigStorage _storage;
    private ConfigStorage _serviceStorage;
    private long _currentScanInterval;
    private long _normalScanInterval;
    private long _currentDefaultScanInterval;
    private long _normalDefaultScanInterval;
    private volatile boolean _isRuntimeScanning = false;
    private volatile Map<ConfigStorage.Key, ConfigResponse> _insertsDuringScan = new HashMap<ConfigStorage.Key, ConfigResponse>();
    private final AtomicReference<CompositeRuntimeResourceReport> _lastReport = new AtomicReference();
    private final AtomicBoolean _writeLastReportDiag = new AtomicBoolean(true);

    public RuntimeAutodiscoverer(AutoinventoryCommandsServer aicmd, AgentStorageProvider storageProvider, AgentDaemon agent, AutoinventoryCallbackClient client) {
        AgentDiagnostics.getInstance().addDiagnostic((AgentDiagnosticObject)this);
        this._aicmd = aicmd;
        this._storage = new ConfigStorage(storageProvider, STORAGE_KEYLIST, STORAGE_PREFIX);
        this._serviceStorage = new ConfigStorage(storageProvider, SERVICE_KEYLIST, SERVICE_PREFIX);
        this._agent = agent;
        this._client = client;
        try {
            this._apm = (AutoinventoryPluginManager)agent.getPluginManager("autoinventory");
        }
        catch (AgentRunningException are) {
            throw new IllegalStateException("Agent not running? " + (Object)((Object)are));
        }
        catch (PluginException gpme) {
            throw new IllegalStateException("Error getting plugin managers: " + (Object)((Object)gpme));
        }
        this._currentScanInterval = this._normalScanInterval = this.loadScanInterval("runtimeScan");
        this.triggerScan();
        this._currentDefaultScanInterval = this._normalDefaultScanInterval = this.loadScanInterval("defaultScan");
        this.triggerDefaultScan();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateConfig(AgentRemoteValue args) throws AgentRemoteException {
        block7: {
            int type = Integer.parseInt(args.getValue("entity.type"));
            ConfigStorage configStorage = type == 3 ? this._serviceStorage : this._storage;
            ConfigStorage.Key key = configStorage.getKey(args);
            boolean isEnable = args.getValue("disable.rtad") == null;
            try {
                this._lastReport.set(null);
                if (isEnable) {
                    ConfigResponse config = configStorage.put(key, args);
                    if (this._isRuntimeScanning) {
                        _log.debug((Object)("Scan running while storing config for: " + key));
                        Map<ConfigStorage.Key, ConfigResponse> map = this._insertsDuringScan;
                        synchronized (map) {
                            this._insertsDuringScan.put(key, config);
                            break block7;
                        }
                    }
                    _log.debug((Object)("Triggering scan after storing config for: " + key));
                    this.triggerScan();
                    break block7;
                }
                configStorage.remove(key);
            }
            catch (AgentStorageException e) {
                String method = isEnable ? "store" : "remove";
                String msg = "Failed to " + method + " config for " + key + ": " + (Object)((Object)e);
                throw new AgentRemoteException(msg, (Exception)((Object)e));
            }
        }
    }

    public long getScanInterval() {
        return this._currentScanInterval;
    }

    public long getDefaultScanInterval() {
        return this._currentDefaultScanInterval;
    }

    public void triggerScan() {
        this._currentScanInterval = 5000L;
    }

    public void triggerDefaultScan() {
        this._currentDefaultScanInterval = 5000L;
    }

    public void scheduleDefaultScan() {
        this._aicmd.scheduleDefaultScan();
        this._currentDefaultScanInterval = this._normalDefaultScanInterval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doRuntimeScan() throws AutoinventoryException {
        Map configs = this._storage.load();
        boolean bl = this._isRuntimeScanning = configs.size() > 0;
        while (this._isRuntimeScanning) {
            this.doRuntimeScan_internal(configs);
            Map<ConfigStorage.Key, ConfigResponse> map = this._insertsDuringScan;
            synchronized (map) {
                int size = this._insertsDuringScan.size();
                if (size == 0) {
                    this._isRuntimeScanning = false;
                    break;
                }
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)("Processing " + size + " configs inserted while scan was running"));
                }
                configs.clear();
                configs.putAll(this._insertsDuringScan);
                this._insertsDuringScan.clear();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doRuntimeScan_internal(Map<ConfigStorage.Key, ConfigResponse> configs) throws AutoinventoryException {
        Map serviceConfigs = this._serviceStorage.load();
        for (Map.Entry entry : serviceConfigs.entrySet()) {
            ConfigStorage.Key key = (ConfigStorage.Key)entry.getKey();
            ConfigResponse config = (ConfigResponse)entry.getValue();
            String type = key.getTypeName();
            this._apm.addServiceConfig(type, config);
        }
        CompositeRuntimeResourceReport compositeReport = new CompositeRuntimeResourceReport();
        for (Map.Entry<ConfigStorage.Key, ConfigResponse> entry : configs.entrySet()) {
            ServerDetector detector;
            ConfigStorage.Key key = entry.getKey();
            ConfigResponse config = entry.getValue();
            String type = key.getTypeName();
            try {
                detector = (ServerDetector)this._apm.getPlugin(type);
            }
            catch (PluginNotFoundException e) {
                if (!_log.isDebugEnabled()) continue;
                _log.debug((Object)("Plugin does not support server detection: " + type), (Throwable)e);
                continue;
            }
            if (!detector.isRuntimeDiscoverySupported()) {
                if (!_log.isDebugEnabled()) continue;
                _log.debug((Object)("Plugin does not support runtime discovery: " + type));
                continue;
            }
            PluginLoader.setClassLoader((Object)detector);
            try {
                RuntimeDiscoverer discoverer = detector.getRuntimeDiscoverer();
                _log.info((Object)("Running runtime autodiscovery for " + type));
                PlatformResource platform = Scanner.detectPlatform((AutoinventoryPluginManager)this._apm, (ConfigResponse)config);
                StopWatch timer = new StopWatch();
                RuntimeResourceReport report = discoverer.discoverResources(key.getId(), (AIPlatformValue)platform, config);
                _log.info((Object)(key.getTypeName() + " discovery took " + timer));
                compositeReport.addServerReport(report);
            }
            catch (Exception e) {
                _log.error((Object)("Unexpected error running autodiscoverer for plugin: " + type + ": " + e), (Throwable)e);
            }
            catch (NoClassDefFoundError e) {
                _log.error((Object)("Unable to run autodiscoverer for plugin: " + type + " (consult product setup help): " + e), (Throwable)e);
                _log.debug((Object)("Current ClassLoader=" + PluginLoader.getClassLoader()));
            }
            finally {
                PluginLoader.resetClassLoader((Object)detector);
            }
        }
        compositeReport = this.loadReportFilter().filterReport(compositeReport);
        if (compositeReport.isSameReport(this._lastReport.get())) {
            _log.debug((Object)"No changes detected, not sending runtime report");
            this._writeLastReportDiag.set(false);
        } else {
            String errMsg = "Error sending runtime report to server: ";
            this._lastReport.set(compositeReport);
            this._writeLastReportDiag.set(true);
            try {
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)("Sending RuntimeReport: " + compositeReport.simpleSummary()));
                }
                this._client.aiSendRuntimeReport(compositeReport);
            }
            catch (Exception e) {
                _log.error((Object)("Error sending runtime report to server: " + e), (Throwable)e);
            }
        }
        this._currentScanInterval = this._normalScanInterval;
    }

    private long loadScanInterval(String type) {
        long interval;
        String prop;
        Properties bootProps = this._agent.getBootConfig().getBootProperties();
        String value = bootProps.getProperty(prop = "autoinventory." + type + ".interval.millis");
        if (value == null) {
            interval = 900000L;
        } else {
            try {
                interval = Long.parseLong(value);
            }
            catch (NumberFormatException e) {
                String msg = prop + " value not a number '" + value + "'";
                throw new IllegalArgumentException(msg);
            }
            if (interval == -1L) {
                interval = Long.MAX_VALUE;
            }
        }
        return interval;
    }

    private RuntimeReportFilter loadReportFilter() {
        RuntimeReportFilter defaultFilter = new RuntimeReportFilter(){

            public CompositeRuntimeResourceReport filterReport(CompositeRuntimeResourceReport r) {
                return r;
            }
        };
        String val = this._agent.getBootConfig().getBootProperties().getProperty("autoinventory.reportFilter");
        if (val == null) {
            return defaultFilter;
        }
        try {
            Class<?> c = Class.forName(val);
            return (RuntimeReportFilter)c.newInstance();
        }
        catch (Throwable t) {
            _log.error((Object)("Unable to create autoinventory.reportFilter [" + val + "], using default"), t);
            return defaultFilter;
        }
    }

    public String getDiagStatus() {
        if (!this._writeLastReportDiag.get() || this._lastReport.get() == null) {
            return "Discovery report has not changed";
        }
        this._writeLastReportDiag.set(false);
        return this._lastReport.get().fullSummary();
    }

    public String getDiagName() {
        return "Runtime Report Diagnostic";
    }
}

