/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.hq.plugin.activemq;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.regex.Pattern;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import javax.management.remote.JMXConnector;
import org.apache.commons.logging.Log;
import org.hyperic.hq.product.PluginException;
import org.hyperic.hq.product.PluginManager;
import org.hyperic.hq.product.ServerResource;
import org.hyperic.hq.product.jmx.MxServerDetector;
import org.hyperic.hq.product.jmx.MxUtil;
import org.hyperic.util.config.ConfigResponse;

public class EmbeddedActiveMQServerDetector
extends MxServerDetector {
    Log log = this.getLog();
    boolean recursive = false;
    private static final String RECURSIVE_PROP = "activemq.search.recursive";

    public void init(PluginManager manager) throws PluginException {
        super.init(manager);
        this.recursive = "true".equalsIgnoreCase(manager.getProperty(RECURSIVE_PROP, "false"));
        this.getLog().debug((Object)("activemq.search.recursive=" + this.recursive));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected File findVersionFile(File dir, Pattern pattern) {
        File webappsDir;
        File versionFile;
        File res = null;
        this.log.debug((Object)("[findVersionFile] dir=" + dir + " pattern=" + pattern));
        if (!dir.exists()) {
            this.log.debug((Object)("File '" + dir + "' Not Found"));
            return null;
        }
        File libDir = new File(dir, "lib");
        if (libDir.exists() && (versionFile = super.findVersionFile(libDir, pattern)) != null) {
            res = versionFile;
        }
        if (res == null && (webappsDir = new File(dir, "webapps")).exists()) {
            block11: for (File app : webappsDir.listFiles()) {
                if (app.isDirectory()) {
                    File versionFile2;
                    File wlibDir = new File(app, "WEB-INF" + File.separator + "lib");
                    if (!wlibDir.exists() || (versionFile2 = super.findVersionFile(wlibDir, pattern)) == null) continue;
                    res = versionFile2;
                    continue;
                }
                if (!app.getName().endsWith(".war")) continue;
                JarFile war = null;
                try {
                    war = new JarFile(app);
                    Enumeration<JarEntry> files = war.entries();
                    while (files.hasMoreElements()) {
                        String fileName = files.nextElement().toString();
                        if (!pattern.matcher(fileName).find()) continue;
                        res = new File(app + "!" + fileName);
                        continue block11;
                    }
                }
                catch (IOException ex) {
                    this.log.debug((Object)("Error: '" + app + "': " + ex.getMessage()), (Throwable)ex);
                }
                finally {
                    if (war != null) {
                        try {
                            war.close();
                        }
                        catch (IOException e) {
                            this.log.debug((Object)("Unable to close war file: " + e.getMessage()), (Throwable)e);
                        }
                    }
                }
            }
        }
        if (res == null && this.recursive) {
            res = super.findVersionFile(dir, pattern);
        }
        this.log.debug((Object)("[findVersionFile] res=" + res));
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getServerResources(ConfigResponse platformConfig) throws PluginException {
        this.log.debug((Object)("[getServerResources] platformConfig=" + platformConfig));
        List servers = super.getServerResources(platformConfig);
        ArrayList<ServerResource> serversOK = new ArrayList<ServerResource>();
        for (ServerResource server : servers) {
            JMXConnector connector = null;
            try {
                connector = MxUtil.getMBeanConnector((Properties)server.getProductConfig().toProperties());
                MBeanServerConnection mServer = connector.getMBeanServerConnection();
                Set<ObjectName> objs = mServer.queryNames(new ObjectName("org.apache.activemq:*"), null);
                this.log.debug((Object)("[getServerResources] objs.size=" + objs.size()));
                if (objs.size() <= 0) continue;
                serversOK.add(server);
            }
            catch (Exception e) {
                this.log.debug((Object)e.getMessage(), (Throwable)e);
            }
            finally {
                try {
                    if (connector == null) continue;
                    connector.close();
                }
                catch (IOException e) {
                    throw new PluginException(e.getMessage(), (Throwable)e);
                }
            }
        }
        return serversOK;
    }

    protected ServerResource getServerResource(MxServerDetector.MxProcess process) {
        ServerResource server = super.getServerResource(process);
        String catalinaBase = server.getInstallPath();
        File hq = this.findVersionFile(new File(catalinaBase), Pattern.compile("hq-common.*\\.jar"));
        if (hq != null) {
            server.setName(EmbeddedActiveMQServerDetector.getPlatformName() + " HQ ActiveMQ Embedded " + this.getTypeInfo().getVersion());
            server.setIdentifier("Embedded ActiveMQ");
        } else {
            server.setIdentifier(catalinaBase + " Embedded ActiveMQ");
        }
        return server;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List discoverServices(ConfigResponse serverConfig) throws PluginException {
        MBeanServerConnection mServer;
        JMXConnector connector = null;
        try {
            connector = MxUtil.getMBeanConnector((Properties)serverConfig.toProperties());
            mServer = connector.getMBeanServerConnection();
        }
        catch (Exception e) {
            MxUtil.close((JMXConnector)connector);
            throw new PluginException(e.getMessage(), (Throwable)e);
        }
        try {
            List list = this._discoverMxServices(mServer, serverConfig);
            return list;
        }
        finally {
            MxUtil.close((JMXConnector)connector);
        }
    }

    protected List _discoverMxServices(MBeanServerConnection mServer, ConfigResponse serverConfig) throws PluginException {
        String url = serverConfig.getValue("jmx.url");
        String objName = this.getTypeProperty("OBJECT_NAME");
        this.log.debug((Object)("--> url=" + url));
        this.log.debug((Object)("--> objName=" + objName));
        return this.discoverMxServices(mServer, serverConfig);
    }
}

