/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.hq.plugin.db2jdbc;

import java.io.File;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.hyperic.hq.plugin.db2jdbc.DefaultServerDetector;
import org.hyperic.hq.product.PluginException;
import org.hyperic.hq.product.ServerResource;
import org.hyperic.hq.product.ServiceResource;
import org.hyperic.util.config.ConfigResponse;

public class DataBaseServerDetector
extends DefaultServerDetector {
    private Pattern regExpDataBases = Pattern.compile("Database (\\d*) entry:");

    protected List discoverServices(ConfigResponse config) throws PluginException {
        this.getLog().debug((Object)("discoverServices config=" + config));
        ArrayList<ServiceResource> res = new ArrayList<ServiceResource>();
        String type = this.getTypeInfo().getName();
        String user = config.getValue("db2.jdbc.user");
        String pass = config.getValue("db2.jdbc.password");
        if (user == null || pass == null) {
            return res;
        }
        String schema = user;
        for (String tbName : this.getList(config, "SELECT TABNAME FROM SYSIBMADM.ADMINTABINFO WHERE TABSCHEMA='" + schema + "'")) {
            if (tbName.toUpperCase().startsWith("SYS")) continue;
            ServiceResource tb = new ServiceResource();
            tb.setType(type + " Table");
            tb.setServiceName("Table " + schema + "." + tbName);
            ConfigResponse conf = new ConfigResponse();
            conf.setValue("table", tbName);
            conf.setValue("schema", schema);
            this.setProductConfig(tb, conf);
            tb.setMeasurementConfig();
            tb.setResponseTimeConfig(new ConfigResponse());
            tb.setControlConfig();
            res.add(tb);
        }
        for (String tbspName : this.getList(config, "SELECT TBSP_NAME FROM SYSIBMADM.TBSP_UTILIZATION where TBSP_TYPE='DMS'")) {
            ServiceResource bpS = new ServiceResource();
            bpS.setType(type + " Table Space");
            bpS.setServiceName("Table Space " + tbspName);
            ConfigResponse conf = new ConfigResponse();
            conf.setValue("tablespace", tbspName);
            this.setProductConfig(bpS, conf);
            bpS.setMeasurementConfig();
            bpS.setResponseTimeConfig(new ConfigResponse());
            bpS.setControlConfig();
            res.add(bpS);
        }
        for (String bpName : this.getList(config, "SELECT BP_NAME FROM SYSIBMADM.BP_HITRATIO")) {
            ServiceResource bpS = new ServiceResource();
            bpS.setType(type + " Buffer Pool");
            bpS.setServiceName("Buffer Pool " + bpName);
            ConfigResponse conf = new ConfigResponse();
            conf.setValue("bufferpool", bpName);
            this.setProductConfig(bpS, conf);
            bpS.setMeasurementConfig();
            bpS.setResponseTimeConfig(new ConfigResponse());
            bpS.setControlConfig();
            res.add(bpS);
        }
        for (String mpN : this.getList(config, "SELECT concat(concat(POOL_ID, '|'), COALESCE(POOL_SECONDARY_ID,'')) as name FROM SYSIBMADM.SNAPDB_MEMORY_POOL where POOL_SECONDARY_ID is NULL or POOL_ID='BP'")) {
            String[] names = mpN.split("\\|");
            String mpId = names[0].trim();
            String mpSId = names.length == 2 ? names[1].trim() : "";
            String mpName = (mpId + " " + mpSId).trim();
            ServiceResource mpS = new ServiceResource();
            mpS.setType(type + " Memory Pool");
            mpS.setServiceName("Memory Pool " + mpName);
            ConfigResponse conf = new ConfigResponse();
            conf.setValue("pool_id", mpId);
            conf.setValue("sec_pool_id", mpSId);
            this.setProductConfig(mpS, conf);
            mpS.setMeasurementConfig();
            mpS.setResponseTimeConfig(new ConfigResponse());
            mpS.setControlConfig();
            res.add(mpS);
        }
        return res;
    }

    protected List createServers(String installPath) {
        ArrayList<ServerResource> res = new ArrayList<ServerResource>();
        String command = this.getListDatabaseCommand();
        File db2exe = null;
        if (command == null) {
            db2exe = new File(installPath + (installPath.endsWith(File.separator) ? "" : File.separator) + "bin" + File.separator + "db2" + (DataBaseServerDetector.isWin32() ? "cmd.exe" : ""));
            command = db2exe.getAbsolutePath() + (DataBaseServerDetector.isWin32() ? " /c /i /w db2 " : " ") + "list database directory";
        }
        if (db2exe.isFile()) {
            try {
                this.getLog().debug((Object)("[createDataBases] command= '" + command + "'"));
                Process cmd = Runtime.getRuntime().exec(command);
                String sal = DataBaseServerDetector.inputStreamAsString(cmd.getInputStream());
                String err = DataBaseServerDetector.inputStreamAsString(cmd.getErrorStream());
                cmd.waitFor();
                if (this.getLog().isDebugEnabled()) {
                    if (cmd.exitValue() != 0) {
                        this.getLog().error((Object)("[createDataBases] exit=" + cmd.exitValue()));
                        this.getLog().error((Object)("[createDataBases] sal=" + sal));
                    } else {
                        this.getLog().debug((Object)("[createDataBases] sal=" + sal));
                    }
                    if (sal.length() == 0) {
                        this.getLog().debug((Object)("[createDataBases] (" + cmd.exitValue() + ") err=" + err));
                    }
                }
                Matcher m = this.regExpDataBases.matcher(sal);
                int ini = 0;
                int end = 0;
                if (m.find()) {
                    ini = m.start();
                    do {
                        end = m.find() ? m.end() : sal.length();
                        String db = sal.substring(ini, end).trim();
                        Properties db_props = this.parseProperties(db);
                        this.getLog().debug((Object)("db_props --> " + db_props));
                        ServerResource svr = this.createDataBase(db_props);
                        if (svr != null) {
                            res.add(svr);
                        }
                        ini = end;
                    } while (end != sal.length());
                }
            }
            catch (Exception ex) {
                this.getLog().error((Object)ex.getMessage(), (Throwable)ex);
            }
        } else {
            this.getLog().debug((Object)("DB2 executable was not found: " + db2exe));
        }
        return res;
    }

    private Properties parseProperties(String s) {
        Properties props = new Properties();
        String[] lines = s.split("\n");
        for (int i = 0; i < lines.length; ++i) {
            String[] line = lines[i].split("=");
            if (line.length <= 1) continue;
            props.setProperty(line[0].trim(), line[1].trim());
        }
        return props;
    }

    ServerResource createDataBase(Properties props) {
        if (!this.checkEntryTypes(props.getProperty("Directory entry type"))) {
            return null;
        }
        String name = props.getProperty("Database name");
        String iPath = props.getProperty("Local database directory");
        if (iPath == null) {
            iPath = props.getProperty("Directory entry type");
        }
        this.getLog().debug((Object)("[createDataBase] name='" + name + "' [" + iPath + "]"));
        ServerResource res = new ServerResource();
        res.setType(this.getTypeInfo().getName());
        res.setName(DataBaseServerDetector.getPlatformName() + " DB2 " + name);
        res.setInstallPath(iPath);
        res.setIdentifier(res.getName());
        ConfigResponse conf = new ConfigResponse();
        conf.setValue("db2.jdbc.database", name);
        conf.setValue("db2.jdbc.version", this.getTypeInfo().getVersion());
        this.setProductConfig(res, conf);
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List getList(ConfigResponse props, String query) {
        ArrayList<String> res = new ArrayList<String>();
        Connection conn = null;
        Statement ps = null;
        try {
            this.getLog().debug((Object)("getList props=" + props));
            conn = DataBaseServerDetector.getConnection(props.toProperties());
            ps = conn.prepareStatement(query);
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                res.add(rs.getString(1));
            }
            this.getLog().debug((Object)("getList '" + query + "' => res= " + res));
        }
        catch (Exception ex) {
            this.getLog().debug((Object)("getList '" + query + "' => " + ex.getMessage()), (Throwable)ex);
        }
        finally {
            try {
                if (ps != null) {
                    ps.close();
                }
                if (conn != null) {
                    conn.close();
                }
            }
            catch (SQLException ex) {
                this.getLog().error((Object)"ERROR", (Throwable)ex);
            }
        }
        return res;
    }
}

