/*
 * Decompiled with CFR 0.152.
 */
package com.springsource.hq.plugin.tcserver.plugin.serverconfig.resources.jdbc;

import com.springsource.hq.plugin.tcserver.plugin.serverconfig.AbstractXmlElementConverter;
import com.springsource.hq.plugin.tcserver.plugin.serverconfig.AttributeNotFoundException;
import com.springsource.hq.plugin.tcserver.plugin.serverconfig.XmlElementConverter;
import com.springsource.hq.plugin.tcserver.plugin.serverconfig.resources.jdbc.DbcpConnectionPoolConverter;
import com.springsource.hq.plugin.tcserver.plugin.serverconfig.resources.jdbc.TomcatConnectionPoolConverter;
import com.springsource.hq.plugin.tcserver.serverconfig.resources.jdbc.Connection;
import com.springsource.hq.plugin.tcserver.serverconfig.resources.jdbc.DataSource;
import com.springsource.hq.plugin.tcserver.serverconfig.resources.jdbc.DbcpConnectionPool;
import com.springsource.hq.plugin.tcserver.serverconfig.resources.jdbc.DbcpDataSource;
import com.springsource.hq.plugin.tcserver.serverconfig.resources.jdbc.General;
import com.springsource.hq.plugin.tcserver.serverconfig.resources.jdbc.TomcatConnectionPool;
import com.springsource.hq.plugin.tcserver.serverconfig.resources.jdbc.TomcatDataSource;
import java.util.Properties;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DataSourceConverter
extends AbstractXmlElementConverter
implements XmlElementConverter<DataSource> {
    private static final String ATTRIBUTE_FACTORY = "factory";
    private static final String ATTRIBUTE_CONNECTION_PROPERTIES = "connectionProperties";
    private static final String ATTRIBUTE_URL = "url";
    private static final String ATTRIBUTE_USERNAME = "username";
    private static final String ATTRIBUTE_PASSWORD = "password";
    private static final String ATTRIBUTE_DRIVER_CLASS_NAME = "driverClassName";
    private static final String ATTRIBUTE_NAME = "name";
    private static final String DATA_SOURCE_FACTORY_DIAGNOSTICS = "com.springsource.tcserver.serviceability.request.DataSourceFactory";
    private static final String DATA_SOURCE_FACTORY_BASIC = "org.apache.tomcat.dbcp.dbcp.BasicDataSourceFactory";
    private static final String DATA_SOURCE_FACTORY_HIGH_CONCURRENCY = "org.apache.tomcat.jdbc.pool.DataSourceFactory";
    private final XmlElementConverter<TomcatConnectionPool> tomcatConnectionPoolConverter = new TomcatConnectionPoolConverter();
    private final XmlElementConverter<DbcpConnectionPool> dbcpConnectionPoolConverter = new DbcpConnectionPoolConverter();

    @Override
    public DataSource convert(Element resource, Properties catalinaProperties) {
        String factory = resource.getAttribute(ATTRIBUTE_FACTORY);
        if (DATA_SOURCE_FACTORY_BASIC.equals(factory)) {
            return this.createDbcpDataSource(resource, catalinaProperties);
        }
        if ("".equals(factory) || DATA_SOURCE_FACTORY_HIGH_CONCURRENCY.equals(factory) || DATA_SOURCE_FACTORY_DIAGNOSTICS.equals(factory)) {
            boolean gatherDiagnostics = DATA_SOURCE_FACTORY_DIAGNOSTICS.equals(factory);
            return this.createTomcatDataSource(resource, catalinaProperties, gatherDiagnostics);
        }
        return null;
    }

    private DataSource createDbcpDataSource(Element resource, Properties catalinaProperties) {
        DbcpDataSource dataSource = new DbcpDataSource();
        dataSource.setGeneral(this.createGeneral(resource, catalinaProperties));
        dataSource.setId(dataSource.getGeneral().getJndiName());
        dataSource.setConnection(this.createConnection(resource, catalinaProperties));
        dataSource.setConnectionPool(this.dbcpConnectionPoolConverter.convert(resource, catalinaProperties));
        return dataSource;
    }

    private DataSource createTomcatDataSource(Element resource, Properties catalinaProperties, boolean gatherDiagnostics) {
        TomcatDataSource dataSource = new TomcatDataSource();
        dataSource.setGeneral(this.createGeneral(resource, catalinaProperties));
        dataSource.setId(dataSource.getGeneral().getJndiName());
        dataSource.setConnection(this.createConnection(resource, catalinaProperties));
        dataSource.setConnectionPool(this.tomcatConnectionPoolConverter.convert(resource, catalinaProperties));
        dataSource.setGatherDiagnostics(gatherDiagnostics);
        return dataSource;
    }

    @Override
    public void convert(Document document, Element resource, DataSource from, Properties catalinaProperties) {
        this.setAttribute(resource, ATTRIBUTE_NAME, from.getGeneral().getJndiName(), catalinaProperties, true);
        this.setAttribute(resource, ATTRIBUTE_DRIVER_CLASS_NAME, from.getConnection().getDriverClassName(), catalinaProperties, true);
        this.setAttribute(resource, ATTRIBUTE_PASSWORD, from.getConnection().getPassword(), catalinaProperties, true);
        this.setAttribute(resource, ATTRIBUTE_USERNAME, from.getConnection().getUsername(), catalinaProperties, true);
        this.setAttribute(resource, ATTRIBUTE_URL, from.getConnection().getUrl(), catalinaProperties, true);
        this.setAttribute(resource, ATTRIBUTE_CONNECTION_PROPERTIES, from.getConnection().getConnectionProperties(), catalinaProperties, false);
        if (from instanceof DbcpDataSource) {
            this.setAttribute(resource, ATTRIBUTE_FACTORY, DATA_SOURCE_FACTORY_BASIC, catalinaProperties, true);
            this.dbcpConnectionPoolConverter.convert(document, resource, ((DbcpDataSource)from).getConnectionPool(), catalinaProperties);
        } else {
            TomcatDataSource tomcatDataSource = (TomcatDataSource)from;
            String dataSourceFactory = this.getDataSourceFactory(tomcatDataSource);
            this.setAttribute(resource, ATTRIBUTE_FACTORY, dataSourceFactory, catalinaProperties, true);
            this.tomcatConnectionPoolConverter.convert(document, resource, tomcatDataSource.getConnectionPool(), catalinaProperties);
        }
    }

    private String getDataSourceFactory(TomcatDataSource tomcatDataSource) {
        if (tomcatDataSource.isGatherDiagnostics()) {
            return DATA_SOURCE_FACTORY_DIAGNOSTICS;
        }
        return DATA_SOURCE_FACTORY_HIGH_CONCURRENCY;
    }

    private Connection createConnection(Element resource, Properties catalinaProperties) {
        Connection connection = new Connection();
        String driverClassName = this.parseProperties(resource.getAttribute(ATTRIBUTE_DRIVER_CLASS_NAME), catalinaProperties);
        if ("".equals(driverClassName)) {
            throw new AttributeNotFoundException(ATTRIBUTE_DRIVER_CLASS_NAME, "Data Source");
        }
        connection.setDriverClassName(driverClassName);
        String password = this.parseProperties(resource.getAttribute(ATTRIBUTE_PASSWORD), catalinaProperties);
        connection.setPassword(password);
        String username = this.parseProperties(resource.getAttribute(ATTRIBUTE_USERNAME), catalinaProperties);
        connection.setUsername(username);
        String url = this.parseProperties(resource.getAttribute(ATTRIBUTE_URL), catalinaProperties);
        if ("".equals(url)) {
            throw new AttributeNotFoundException(ATTRIBUTE_URL, "Data Source");
        }
        connection.setUrl(url);
        String connectionProperties = this.parseProperties(resource.getAttribute(ATTRIBUTE_CONNECTION_PROPERTIES), catalinaProperties);
        if (!"".equals(connectionProperties)) {
            connection.setConnectionProperties(connectionProperties);
        }
        return connection;
    }

    private General createGeneral(Element resource, Properties catalinaProperties) {
        General general = new General();
        String jndiName = this.parseProperties(resource.getAttribute(ATTRIBUTE_NAME), catalinaProperties);
        if ("".equals(jndiName)) {
            throw new AttributeNotFoundException(ATTRIBUTE_NAME, "Data Source");
        }
        general.setJndiName(jndiName);
        return general;
    }

    public boolean isDataSourceFactorySupported(Element dataSource, Properties catalinaProperties) {
        String factory = this.parseProperties(dataSource.getAttribute(ATTRIBUTE_FACTORY), catalinaProperties).trim();
        return factory.equals(DATA_SOURCE_FACTORY_BASIC) || factory.equals(DATA_SOURCE_FACTORY_HIGH_CONCURRENCY) || factory.equals("") || factory.equals(DATA_SOURCE_FACTORY_DIAGNOSTICS);
    }
}

