/*
 * Decompiled with CFR 0.152.
 */
package com.springsource.hq.plugin.tcserver.plugin.serverconfig.general;

import com.springsource.hq.plugin.tcserver.plugin.serverconfig.AbstractXmlElementConverter;
import com.springsource.hq.plugin.tcserver.plugin.serverconfig.XmlElementConverter;
import com.springsource.hq.plugin.tcserver.serverconfig.configuration.general.AprLifecycleListener;
import com.springsource.hq.plugin.tcserver.serverconfig.configuration.general.GeneralConfig;
import com.springsource.hq.plugin.tcserver.serverconfig.configuration.general.JmxListener;
import com.springsource.hq.plugin.tcserver.serverconfig.configuration.general.ServerProperties;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import org.springframework.util.xml.DomUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GeneralConfigConverter
extends AbstractXmlElementConverter
implements XmlElementConverter<GeneralConfig> {
    private static final String TAG_NAME_LISTENER = "Listener";
    private static final String ATTRIBUTE_CLASS_NAME = "className";
    private static final String CLASS_NAME_APR_LIFECYCLE_LISTENER = "org.apache.catalina.core.AprLifecycleListener";
    private static final String SHUTDOWN = "shutdown";
    private static final String PORT = "port";
    private static final String ACCESS_FILE = "accessFile";
    private static final String AUTHENTICATE = "authenticate";
    private static final String BIND = "bind";
    private static final String CIPHER_SUITES = "cipherSuites";
    private static final String CLIENT_AUTH = "clientAuth";
    private static final String KEYSTORE_FILE = "keystoreFile";
    private static final String KEYSTORE_PASS = "keystorePass";
    private static final String PASSOWRD_FILE = "passwordFile";
    private static final String JMX_PORT = "port";
    private static final String PROTOCOLS = "protocols";
    private static final String TRUSTSTORE_FILE = "truststoreFile";
    private static final String TRUSTSTORE_PASS = "truststorePass";
    private static final String USE_JDK_CLIENT_FACTORY = "useJdkClientFactory";
    private static final String USE_SSL = "useSSL";

    @Override
    public GeneralConfig convert(Element server, Properties catalinaProperties) {
        GeneralConfig generalConfig = new GeneralConfig();
        generalConfig.setServerProperties(this.createServerProperties(server, catalinaProperties));
        generalConfig.setJmxListener(this.createJmxListener(server, catalinaProperties));
        generalConfig.setAprLifecycleListener(this.createAprLifecycleListener(server));
        return generalConfig;
    }

    private AprLifecycleListener createAprLifecycleListener(Element server) {
        List listeners = DomUtils.getChildElementsByTagName((Element)server, (String)TAG_NAME_LISTENER);
        for (Element listener : listeners) {
            if (!this.isAprLifecycleListener(listener)) continue;
            return new AprLifecycleListener();
        }
        return null;
    }

    private boolean isAprLifecycleListener(Element listener) {
        return CLASS_NAME_APR_LIFECYCLE_LISTENER.equals(listener.getAttribute(ATTRIBUTE_CLASS_NAME));
    }

    @Override
    public void convert(Document document, Element server, GeneralConfig from, Properties catalinaProperties) {
        this.setAttribute(server, "port", from.getServerProperties().getPort(), catalinaProperties, true);
        this.setAttribute(server, SHUTDOWN, from.getServerProperties().getShutdown(), catalinaProperties, true);
        this.convertJmxListener(document, server, from.getJmxListener(), catalinaProperties);
        this.convertAprLifecycleListener(document, server, from.getAprLifecycleListener());
    }

    private void convertAprLifecycleListener(Document document, Element server, AprLifecycleListener configuredAprLifecycleListener) {
        Element aprLifecycleListenerXmlElementInServerXml = null;
        Element lastListener = null;
        boolean foundAprLifecycleXmlElementInServerXml = false;
        List listeners = DomUtils.getChildElementsByTagName((Element)server, (String)TAG_NAME_LISTENER);
        Iterator iterator = listeners.iterator();
        while (iterator.hasNext()) {
            Element listener;
            lastListener = listener = (Element)iterator.next();
            if (!this.isAprLifecycleListener(listener)) continue;
            foundAprLifecycleXmlElementInServerXml = true;
            aprLifecycleListenerXmlElementInServerXml = listener;
            if (configuredAprLifecycleListener != null) continue;
            server.removeChild(aprLifecycleListenerXmlElementInServerXml);
        }
        if (configuredAprLifecycleListener != null) {
            if (!foundAprLifecycleXmlElementInServerXml) {
                aprLifecycleListenerXmlElementInServerXml = document.createElement(TAG_NAME_LISTENER);
            }
            aprLifecycleListenerXmlElementInServerXml.setAttribute(ATTRIBUTE_CLASS_NAME, CLASS_NAME_APR_LIFECYCLE_LISTENER);
            if (!foundAprLifecycleXmlElementInServerXml) {
                if (lastListener != null) {
                    server.insertBefore(aprLifecycleListenerXmlElementInServerXml, lastListener.getNextSibling());
                } else {
                    Element globalNamingResources = DomUtils.getChildElementByTagName((Element)server, (String)"GlobalNamingResources");
                    server.insertBefore(aprLifecycleListenerXmlElementInServerXml, globalNamingResources);
                }
            }
        }
    }

    private void convertJmxListener(Document document, Element server, JmxListener from, Properties catalinaProperties) {
        Element jmxListener = null;
        boolean foundJmxListener = false;
        for (Element listener : DomUtils.getChildElementsByTagName((Element)server, (String)TAG_NAME_LISTENER)) {
            if (!"com.springsource.tcserver.serviceability.rmi.JmxSocketListener".equals(listener.getAttribute(ATTRIBUTE_CLASS_NAME))) continue;
            foundJmxListener = true;
            jmxListener = listener;
            if (from.getEnabled().booleanValue()) continue;
            server.removeChild(jmxListener);
        }
        if (from.getEnabled().booleanValue()) {
            if (!foundJmxListener) {
                jmxListener = document.createElement(TAG_NAME_LISTENER);
                jmxListener.setAttribute(ATTRIBUTE_CLASS_NAME, "com.springsource.tcserver.serviceability.rmi.JmxSocketListener");
            }
            this.setAttribute(jmxListener, ACCESS_FILE, from.getAccessFile(), catalinaProperties, true);
            if (from.getAuthenticate() != null) {
                this.setAttribute(jmxListener, AUTHENTICATE, from.getAuthenticate(), catalinaProperties, true);
            }
            this.setAttribute(jmxListener, BIND, from.getBind(), catalinaProperties, true);
            this.setAttribute(jmxListener, CIPHER_SUITES, from.getCipherSuites(), catalinaProperties, true);
            if (from.getClientAuth() != null) {
                this.setAttribute(jmxListener, CLIENT_AUTH, from.getClientAuth(), catalinaProperties, true);
            }
            this.setAttribute(jmxListener, KEYSTORE_FILE, from.getKeystoreFile(), catalinaProperties, true);
            this.setAttribute(jmxListener, KEYSTORE_PASS, from.getKeystorePass(), catalinaProperties, true);
            this.setAttribute(jmxListener, PASSOWRD_FILE, from.getPasswordFile(), catalinaProperties, true);
            if (from.getPort() != null) {
                this.setAttribute(jmxListener, "port", from.getPort(), catalinaProperties, true);
            }
            this.setAttribute(jmxListener, PROTOCOLS, from.getProtocols(), catalinaProperties, true);
            this.setAttribute(jmxListener, TRUSTSTORE_FILE, from.getTruststoreFile(), catalinaProperties, true);
            this.setAttribute(jmxListener, TRUSTSTORE_PASS, from.getTruststorePass(), catalinaProperties, true);
            if (from.getUseJdkClientFactory() != null) {
                this.setAttribute(jmxListener, USE_JDK_CLIENT_FACTORY, from.getUseJdkClientFactory(), catalinaProperties, true);
            }
            if (from.getUseSSL() != null) {
                this.setAttribute(jmxListener, USE_SSL, from.getUseSSL(), catalinaProperties, true);
            }
            if (!foundJmxListener) {
                server.appendChild(jmxListener);
            }
        }
    }

    private ServerProperties createServerProperties(Element server, Properties catalinaProperties) {
        String shutdown;
        ServerProperties serverProperties = new ServerProperties();
        String port = this.parseProperties(server.getAttribute("port"), catalinaProperties);
        if (!"".equals(port)) {
            try {
                serverProperties.setPort(Long.valueOf(port));
            }
            catch (NumberFormatException numberFormatException) {
                this.logNonNumericValue("Server", "port", port);
            }
        }
        if (!"".equals(shutdown = this.parseProperties(server.getAttribute(SHUTDOWN), catalinaProperties))) {
            serverProperties.setShutdown(shutdown);
        }
        return serverProperties;
    }

    private JmxListener createJmxListener(Element server, Properties catalinaProperties) {
        JmxListener jmxListener = new JmxListener();
        for (Element listener : DomUtils.getChildElementsByTagName((Element)server, (String)TAG_NAME_LISTENER)) {
            String useSSL;
            String useJdkClientFactory;
            String truststorePass;
            String truststoreFile;
            String protocols;
            String port;
            String passwordFile;
            String keystorePass;
            String keystoreFile;
            String clientAuth;
            String cipherSuites;
            String bind;
            String authenticate;
            if (!"com.springsource.tcserver.serviceability.rmi.JmxSocketListener".equals(listener.getAttribute(ATTRIBUTE_CLASS_NAME))) continue;
            jmxListener.setEnabled(Boolean.valueOf(true));
            String accessFile = this.parseProperties(listener.getAttribute(ACCESS_FILE), catalinaProperties);
            if (!"".equals(accessFile)) {
                jmxListener.setAccessFile(accessFile);
            }
            if (!"".equals(authenticate = this.parseProperties(listener.getAttribute(AUTHENTICATE), catalinaProperties))) {
                jmxListener.setAuthenticate(Boolean.valueOf(authenticate));
            }
            if (!"".equals(bind = this.parseProperties(listener.getAttribute(BIND), catalinaProperties))) {
                jmxListener.setBind(bind);
            }
            if (!"".equals(cipherSuites = this.parseProperties(listener.getAttribute(CIPHER_SUITES), catalinaProperties))) {
                jmxListener.setCipherSuites(cipherSuites);
            }
            if (!"".equals(clientAuth = this.parseProperties(listener.getAttribute(CLIENT_AUTH), catalinaProperties))) {
                jmxListener.setClientAuth(Boolean.valueOf(clientAuth));
            }
            if (!"".equals(keystoreFile = this.parseProperties(listener.getAttribute(KEYSTORE_FILE), catalinaProperties))) {
                jmxListener.setKeystoreFile(keystoreFile);
            }
            if (!"".equals(keystorePass = this.parseProperties(listener.getAttribute(KEYSTORE_PASS), catalinaProperties))) {
                jmxListener.setKeystorePass(keystorePass);
            }
            if (!"".equals(passwordFile = this.parseProperties(listener.getAttribute(PASSOWRD_FILE), catalinaProperties))) {
                jmxListener.setPasswordFile(passwordFile);
            }
            if (!"".equals(port = this.parseProperties(listener.getAttribute("port"), catalinaProperties))) {
                try {
                    jmxListener.setPort(Long.valueOf(port));
                }
                catch (NumberFormatException numberFormatException) {
                    this.logNonNumericValue("JMX Listener", "port", port);
                }
            }
            if (!"".equals(protocols = this.parseProperties(listener.getAttribute(PROTOCOLS), catalinaProperties))) {
                jmxListener.setProtocols(protocols);
            }
            if (!"".equals(truststoreFile = this.parseProperties(listener.getAttribute(TRUSTSTORE_FILE), catalinaProperties))) {
                jmxListener.setTruststoreFile(truststoreFile);
            }
            if (!"".equals(truststorePass = this.parseProperties(listener.getAttribute(TRUSTSTORE_PASS), catalinaProperties))) {
                jmxListener.setTruststorePass(truststorePass);
            }
            if (!"".equals(useJdkClientFactory = this.parseProperties(listener.getAttribute(USE_JDK_CLIENT_FACTORY), catalinaProperties))) {
                jmxListener.setUseJdkClientFactory(Boolean.valueOf(useJdkClientFactory));
            }
            if (!"".equals(useSSL = this.parseProperties(listener.getAttribute(USE_SSL), catalinaProperties))) {
                jmxListener.setUseSSL(Boolean.valueOf(useSSL));
            }
            return jmxListener;
        }
        jmxListener.setEnabled(Boolean.valueOf(false));
        return jmxListener;
    }
}

