/*
 * Decompiled with CFR 0.152.
 */
package com.springsource.hq.plugin.tcserver.plugin.serverconfig.environment;

import com.springsource.hq.plugin.tcserver.plugin.serverconfig.environment.DefaultCliArgsParser;
import com.springsource.hq.plugin.tcserver.plugin.serverconfig.environment.JvmOptionsConverter;
import com.springsource.hq.plugin.tcserver.serverconfig.configuration.jvm.Advanced;
import com.springsource.hq.plugin.tcserver.serverconfig.configuration.jvm.Debug;
import com.springsource.hq.plugin.tcserver.serverconfig.configuration.jvm.GarbageCollection;
import com.springsource.hq.plugin.tcserver.serverconfig.configuration.jvm.General;
import com.springsource.hq.plugin.tcserver.serverconfig.configuration.jvm.JvmOptions;
import com.springsource.hq.plugin.tcserver.serverconfig.configuration.jvm.Memory;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultJvmOptionsConverter
implements JvmOptionsConverter {
    private final Log logger = LogFactory.getLog(DefaultJvmOptionsConverter.class);
    private static final String THREAD_STACK_SIZE = "-Xss";
    private static final String PERM_SIZE = "-XX:PermSize=";
    private static final String NEW_SIZE = "-XX:NewSize=";
    private static final String MAX_HEAP = "-Xmx";
    private static final String MIN_HEAP = "-Xms";
    private static final String MAX_PERM_SIZE = "-XX:MaxPermSize=";
    private static final String MAX_NEW_SIZE = "-XX:MaxNewSize=";
    private static final String MAX_GC_PAUSE_MILLIS = "-XX:MaxGCPauseMillis=";
    private static final String MAX_GC_MINOR_PAUSE_MILLIS = "-XX:MaxGCMinorPauseMillis=";
    private static final String PRINT_HEAP_AT_GC = "-XX:+PrintHeapAtGC";
    private static final String PRINT_GC_TIME_STAMPS = "-XX:+PrintGCTimeStamps";
    private static final String PRINT_GC_DETAILS = "-XX:+PrintGCDetails";
    private static final String PRINT_GC_APPLICATION_STOPPED_TIME = "-XX:+PrintGCApplicationStoppedTime";
    private static final String PRINT_GC = "-XX:+PrintGC";
    private static final String LOG_GC = "-Xloggc:";
    private static final String HEAP_DUMP_ON_OUT_OF_MEMORY_ERROR = "-XX:+HeapDumpOnOutOfMemoryError";
    private static final String SERVER = "-server";

    @Override
    public JvmOptions convert(List<String> options) {
        JvmOptions jvmOptions = new JvmOptions();
        General general = new General();
        Debug debug = new Debug();
        Advanced advanced = new Advanced();
        GarbageCollection garbageCollection = new GarbageCollection();
        Memory memory = new Memory();
        jvmOptions.setAdvanced(advanced);
        jvmOptions.setDebug(debug);
        jvmOptions.setGarbageCollection(garbageCollection);
        jvmOptions.setGeneral(general);
        jvmOptions.setMemory(memory);
        StringBuilder advancedCommandLine = new StringBuilder();
        for (String jvmOption : options) {
            if (SERVER.equals(jvmOption)) {
                general.setServer(Boolean.valueOf(true));
                continue;
            }
            if (HEAP_DUMP_ON_OUT_OF_MEMORY_ERROR.equals(jvmOption)) {
                debug.setHeapDumpOnOutOfMemoryError(Boolean.valueOf(true));
                continue;
            }
            if (jvmOption.startsWith(LOG_GC)) {
                debug.setLoggc(jvmOption.substring(LOG_GC.length()));
                continue;
            }
            if (PRINT_GC.equals(jvmOption)) {
                debug.setPrintGC(Boolean.valueOf(true));
                continue;
            }
            if (PRINT_GC_APPLICATION_STOPPED_TIME.equals(jvmOption)) {
                debug.setPrintGCApplicationStoppedTime(Boolean.valueOf(true));
                continue;
            }
            if (PRINT_GC_DETAILS.equals(jvmOption)) {
                debug.setPrintGCDetails(Boolean.valueOf(true));
                continue;
            }
            if (PRINT_GC_TIME_STAMPS.equals(jvmOption)) {
                debug.setPrintGCTimeStamps(Boolean.valueOf(true));
                continue;
            }
            if (PRINT_HEAP_AT_GC.equals(jvmOption)) {
                debug.setPrintHeapAtGC(Boolean.valueOf(true));
                continue;
            }
            if (jvmOption.startsWith(MAX_GC_MINOR_PAUSE_MILLIS)) {
                try {
                    garbageCollection.setMaxGCMinorPauseMillis(Long.valueOf(jvmOption.split("=")[1]));
                }
                catch (Exception exception) {
                    this.logger.warn((Object)"Error reading tc Runtime configuration.  JVM option -XX:MaxGCMinorPauseMillis= set to a non-numeric value.  Default value will be displayed instead.");
                }
                continue;
            }
            if (jvmOption.startsWith(MAX_GC_PAUSE_MILLIS)) {
                try {
                    garbageCollection.setMaxGCPauseMillis(Long.valueOf(jvmOption.split("=")[1]));
                }
                catch (Exception exception) {
                    this.logger.warn((Object)"Error reading tc Runtime configuration.  JVM option -XX:MaxGCPauseMillis= set to a non-numeric value.  Default value will be displayed instead.");
                }
                continue;
            }
            if (jvmOption.startsWith(MAX_NEW_SIZE)) {
                try {
                    memory.setMaxNewSize(this.getMemValueMB(jvmOption.split("=")[1]));
                }
                catch (Exception exception) {
                    this.logger.warn((Object)"Error reading tc Runtime configuration.  JVM option -XX:MaxNewSize= set to a non-numeric value.  Default value will be displayed instead.");
                }
                continue;
            }
            if (jvmOption.startsWith(MAX_PERM_SIZE)) {
                try {
                    memory.setMaxPermSize(this.getMemValueMB(jvmOption.split("=")[1]));
                }
                catch (Exception exception) {
                    this.logger.warn((Object)"Error reading tc Runtime configuration.  JVM option -XX:MaxPermSize= set to a non-numeric value.  Default value will be displayed instead.");
                }
                continue;
            }
            if (jvmOption.startsWith(MIN_HEAP)) {
                try {
                    memory.setMs(this.getMemValueMB(jvmOption.substring(MIN_HEAP.length())));
                }
                catch (NumberFormatException numberFormatException) {
                    this.logger.warn((Object)"Error reading tc Runtime configuration.  JVM option -Xms set to a non-numeric value.  Default value will be displayed instead.");
                }
                continue;
            }
            if (jvmOption.startsWith(MAX_HEAP)) {
                try {
                    memory.setMx(this.getMemValueMB(jvmOption.substring(MAX_HEAP.length())));
                }
                catch (NumberFormatException numberFormatException) {
                    this.logger.warn((Object)"Error reading tc Runtime configuration.  JVM option -Xmx set to a non-numeric value.  Default value will be displayed instead.");
                }
                continue;
            }
            if (jvmOption.startsWith(NEW_SIZE)) {
                try {
                    memory.setNewSize(this.getMemValueMB(jvmOption.split("=")[1]));
                }
                catch (Exception exception) {
                    this.logger.warn((Object)"Error reading tc Runtime configuration.  JVM option -XX:NewSize= set to a non-numeric value.  Default value will be displayed instead.");
                }
                continue;
            }
            if (jvmOption.startsWith(PERM_SIZE)) {
                try {
                    memory.setPermSize(this.getMemValueMB(jvmOption.split("=")[1]));
                }
                catch (Exception exception) {
                    this.logger.warn((Object)"Error reading tc Runtime configuration.  JVM option -XX:PermSize= set to a non-numeric value.  Default value will be displayed instead.");
                }
                continue;
            }
            if (jvmOption.startsWith(THREAD_STACK_SIZE)) {
                try {
                    memory.setSs(this.getMemValueKB(jvmOption.substring(THREAD_STACK_SIZE.length())));
                }
                catch (NumberFormatException numberFormatException) {
                    this.logger.warn((Object)"Error reading tc Runtime configuration.  JVM option -Xss set to a non-numeric value.  Default value will be displayed instead.");
                }
                continue;
            }
            advancedCommandLine.append(jvmOption).append(" ");
        }
        if (!"".equals(advancedCommandLine.toString().trim())) {
            advanced.setCliArgs(advancedCommandLine.toString().trim());
        }
        return jvmOptions;
    }

    @Override
    public List<String> convert(JvmOptions jvmOptions) {
        LinkedList<String> jvmOpts = new LinkedList<String>();
        if (Boolean.TRUE.equals(jvmOptions.getGeneral().getServer())) {
            jvmOpts.add(SERVER);
        }
        if (Boolean.TRUE.equals(jvmOptions.getDebug().getHeapDumpOnOutOfMemoryError())) {
            jvmOpts.add(HEAP_DUMP_ON_OUT_OF_MEMORY_ERROR);
        }
        if (jvmOptions.getDebug().getLoggc() != null && !"".equals(jvmOptions.getDebug().getLoggc())) {
            jvmOpts.add(LOG_GC + jvmOptions.getDebug().getLoggc());
        }
        if (Boolean.TRUE.equals(jvmOptions.getDebug().getPrintGC())) {
            jvmOpts.add(PRINT_GC);
        }
        if (Boolean.TRUE.equals(jvmOptions.getDebug().getPrintGCApplicationStoppedTime())) {
            jvmOpts.add(PRINT_GC_APPLICATION_STOPPED_TIME);
        }
        if (Boolean.TRUE.equals(jvmOptions.getDebug().getPrintGCDetails())) {
            jvmOpts.add(PRINT_GC_DETAILS);
        }
        if (Boolean.TRUE.equals(jvmOptions.getDebug().getPrintGCTimeStamps())) {
            jvmOpts.add(PRINT_GC_TIME_STAMPS);
        }
        if (Boolean.TRUE.equals(jvmOptions.getDebug().getPrintHeapAtGC())) {
            jvmOpts.add(PRINT_HEAP_AT_GC);
        }
        if (jvmOptions.getGarbageCollection().getMaxGCMinorPauseMillis() != null) {
            jvmOpts.add(MAX_GC_MINOR_PAUSE_MILLIS + jvmOptions.getGarbageCollection().getMaxGCMinorPauseMillis());
        }
        if (jvmOptions.getGarbageCollection().getMaxGCPauseMillis() != null) {
            jvmOpts.add(MAX_GC_PAUSE_MILLIS + jvmOptions.getGarbageCollection().getMaxGCPauseMillis());
        }
        if (jvmOptions.getMemory().getMaxNewSize() != null) {
            jvmOpts.add(MAX_NEW_SIZE + jvmOptions.getMemory().getMaxNewSize() + "m");
        }
        if (jvmOptions.getMemory().getMaxPermSize() != null) {
            jvmOpts.add(MAX_PERM_SIZE + jvmOptions.getMemory().getMaxPermSize() + "m");
        }
        if (jvmOptions.getMemory().getMs() != null) {
            jvmOpts.add(MIN_HEAP + jvmOptions.getMemory().getMs() + "m");
        }
        if (jvmOptions.getMemory().getMx() != null) {
            jvmOpts.add(MAX_HEAP + jvmOptions.getMemory().getMx() + "m");
        }
        if (jvmOptions.getMemory().getNewSize() != null) {
            jvmOpts.add(NEW_SIZE + jvmOptions.getMemory().getNewSize() + "m");
        }
        if (jvmOptions.getMemory().getPermSize() != null) {
            jvmOpts.add(PERM_SIZE + jvmOptions.getMemory().getPermSize() + "m");
        }
        if (jvmOptions.getMemory().getSs() != null) {
            jvmOpts.add(THREAD_STACK_SIZE + jvmOptions.getMemory().getSs() + "k");
        }
        if (jvmOptions.getAdvanced().getCliArgs() != null && !"".equals(jvmOptions.getAdvanced().getCliArgs())) {
            DefaultCliArgsParser parser = new DefaultCliArgsParser(jvmOptions.getAdvanced().getCliArgs());
            jvmOpts.addAll(parser.getArgumentList());
        }
        return jvmOpts;
    }

    private Long getMemValueMB(String memValue) throws NumberFormatException {
        if (memValue.endsWith("k") || memValue.endsWith("K")) {
            String kb = memValue.substring(0, memValue.length() - 1);
            return Long.valueOf(kb) / 1000L;
        }
        if (memValue.endsWith("m") || memValue.endsWith("M")) {
            String mb = memValue.substring(0, memValue.length() - 1);
            return Long.valueOf(mb);
        }
        if (memValue.endsWith("g") || memValue.endsWith("G")) {
            String gb = memValue.substring(0, memValue.length() - 1);
            return Long.valueOf(gb) * 1000L;
        }
        return Long.valueOf(memValue) / 1000000L;
    }

    private Long getMemValueKB(String memValue) throws NumberFormatException {
        if (memValue.endsWith("k") || memValue.endsWith("K")) {
            String kb = memValue.substring(0, memValue.length() - 1);
            return Long.valueOf(kb);
        }
        if (memValue.endsWith("m") || memValue.endsWith("M")) {
            String mb = memValue.substring(0, memValue.length() - 1);
            return Long.valueOf(mb) * 1000L;
        }
        if (memValue.endsWith("g") || memValue.endsWith("G")) {
            String gb = memValue.substring(0, memValue.length() - 1);
            return Long.valueOf(gb) * 1000000L;
        }
        return Long.valueOf(memValue) / 1000L;
    }
}

