/*
 * Decompiled with CFR 0.152.
 */
package com.springsource.hq.plugin.tcserver.plugin.serverconfig.context;

import com.springsource.hq.plugin.tcserver.plugin.serverconfig.AbstractXmlElementConverter;
import com.springsource.hq.plugin.tcserver.plugin.serverconfig.XmlElementConverter;
import com.springsource.hq.plugin.tcserver.serverconfig.configuration.context.ContextContainer;
import com.springsource.hq.plugin.tcserver.serverconfig.configuration.context.StaticResourceCache;
import com.springsource.hq.plugin.tcserver.serverconfig.configuration.context.WebApplicationLogger;
import java.util.Properties;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ContextContainerConverter
extends AbstractXmlElementConverter
implements XmlElementConverter<ContextContainer> {
    private static final String CONTEXT = "Context";
    private static final String CACHING_ALLOWED = "cachingAllowed";
    private static final String CACHE_TTL = "cacheTTL";
    private static final String CACHE_MAX_SIZE = "cacheMaxSize";
    private static final String SWALLOW_OUTPUT = "swallowOutput";

    @Override
    public ContextContainer convert(Element context, Properties catalinaProperties) {
        ContextContainer contextContainer = new ContextContainer();
        contextContainer.setStaticResourceCache(this.createStaticResourceCache(context, catalinaProperties));
        contextContainer.setWebApplicationLogger(this.createWebApplicationLogger(context, catalinaProperties));
        return contextContainer;
    }

    private WebApplicationLogger createWebApplicationLogger(Element context, Properties catalinaProperties) {
        WebApplicationLogger webApplicationLogger = new WebApplicationLogger();
        String swallowOutput = this.parseProperties(context.getAttribute(SWALLOW_OUTPUT), catalinaProperties);
        if (!"".equals(swallowOutput)) {
            webApplicationLogger.setSwallowOutput(Boolean.valueOf(swallowOutput));
        }
        return webApplicationLogger;
    }

    private StaticResourceCache createStaticResourceCache(Element context, Properties catalinaProperties) {
        String cachingAllowed;
        String cacheTTL;
        StaticResourceCache staticResourceCache = new StaticResourceCache();
        String cacheMaxSize = this.parseProperties(context.getAttribute(CACHE_MAX_SIZE), catalinaProperties);
        if (!"".equals(cacheMaxSize)) {
            try {
                staticResourceCache.setCacheMaxSize(Long.valueOf(cacheMaxSize));
            }
            catch (NumberFormatException numberFormatException) {
                this.logNonNumericValue(CONTEXT, CACHE_MAX_SIZE, cacheMaxSize);
            }
        }
        if (!"".equals(cacheTTL = this.parseProperties(context.getAttribute(CACHE_TTL), catalinaProperties))) {
            try {
                staticResourceCache.setCacheTTL(Long.valueOf(cacheTTL));
            }
            catch (NumberFormatException numberFormatException) {
                this.logNonNumericValue(CONTEXT, CACHE_TTL, cacheTTL);
            }
        }
        if (!"".equals(cachingAllowed = this.parseProperties(context.getAttribute(CACHING_ALLOWED), catalinaProperties))) {
            staticResourceCache.setCachingAllowed(Boolean.valueOf(cachingAllowed));
        }
        return staticResourceCache;
    }

    @Override
    public void convert(Document document, Element context, ContextContainer from, Properties catalinaProperties) {
        this.convertStaticResourceCache(context, from.getStaticResourceCache(), catalinaProperties);
        this.convertWebApplicationLogger(context, from.getWebApplicationLogger(), catalinaProperties);
    }

    private void convertStaticResourceCache(Element context, StaticResourceCache staticResourceCache, Properties catalinaProperties) {
        this.setAttribute(context, CACHE_MAX_SIZE, staticResourceCache.getCacheMaxSize(), catalinaProperties, false);
        this.setAttribute(context, CACHE_TTL, staticResourceCache.getCacheTTL(), catalinaProperties, false);
        this.setAttribute(context, CACHING_ALLOWED, staticResourceCache.getCachingAllowed(), catalinaProperties, false);
    }

    private void convertWebApplicationLogger(Element context, WebApplicationLogger webAppLogger, Properties catalinaProperties) {
        this.setAttribute(context, SWALLOW_OUTPUT, webAppLogger.getSwallowOutput(), catalinaProperties, false);
    }
}

