/*
 * Decompiled with CFR 0.152.
 */
package com.springsource.hq.plugin.tcserver.plugin.appmgmt;

import com.springsource.hq.plugin.tcserver.plugin.appmgmt.FileOwnershipChanger;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.OutputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hyperic.hq.product.PluginException;
import org.hyperic.util.exec.Execute;
import org.hyperic.util.exec.ExecuteStreamHandler;
import org.hyperic.util.exec.PumpStreamHandler;

final class ChownFileOwnershipChanger
implements FileOwnershipChanger {
    private static final String EXECUTABLE_CHOWN = "chown";
    private static final String FORMAT_OWNER_AND_GROUP = "%s:%s";
    private final Log log = LogFactory.getLog(ChownFileOwnershipChanger.class);

    ChownFileOwnershipChanger() {
    }

    public void changeFileOwnership(File file, String owningUser, String owningGroup) throws PluginException {
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        Execute ex = new Execute((ExecuteStreamHandler)new PumpStreamHandler((OutputStream)output));
        if (owningUser != null) {
            int returnCode;
            String owners = owningGroup == null ? owningUser : String.format(FORMAT_OWNER_AND_GROUP, owningUser, owningGroup);
            ex.setCommandline(new String[]{EXECUTABLE_CHOWN, owners, file.getAbsolutePath()});
            this.log.info((Object)("Changing file ownership with command '" + ex.getCommandLineString() + "'"));
            try {
                returnCode = ex.execute();
            }
            catch (Exception e) {
                throw new PluginException("Failed to change ownership of war file", (Throwable)e);
            }
            if (returnCode != 0) {
                throw new PluginException("Failed to change ownership of war file: " + output.toString());
            }
        }
    }
}

