/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.cm.filemonitor.utils;

import java.io.File;
import org.hyperic.cm.filemonitor.Watcher;
import org.hyperic.cm.filemonitor.utils.Callable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileWalker {
    private static Logger log = LoggerFactory.getLogger(Watcher.class);

    public static void walkDfs(File dir, Callable callable) {
        File[] files;
        if (log.isDebugEnabled()) {
            log.debug("Walking " + dir.getPath());
        }
        if ((files = dir.listFiles()) == null) {
            return;
        }
        File[] fileArray = files;
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            File f = fileArray[n2];
            boolean passFilter = callable.passFilter(f);
            if (passFilter) {
                callable.preOrder(f);
            }
            if (f.isDirectory() && callable.walkSubdirs(f)) {
                FileWalker.walkDfs(f, callable);
            }
            if (passFilter) {
                callable.postOrder(f);
            }
            ++n2;
        }
    }
}

