/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.cm.filemonitor;

import java.io.File;
import java.util.Map;
import org.hyperic.cm.filemonitor.data.WatchedDirInfo;
import org.hyperic.cm.filemonitor.utils.Callable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class DirsMapAdder
implements Callable {
    private static Logger log = LoggerFactory.getLogger(DirsMapAdder.class);
    private Map<String, WatchedDirInfo> dirsMap;
    private String filter = null;

    public DirsMapAdder(Map<String, WatchedDirInfo> dirsMap, String filter) {
        this.dirsMap = dirsMap;
        this.filter = filter;
    }

    @Override
    public boolean passFilter(File f) {
        return f.isDirectory();
    }

    @Override
    public void preOrder(File f) {
        if (log != null) {
            log.debug("Adding " + f.getAbsolutePath() + " to dirsMap");
        }
        this.dirsMap.put(f.getAbsolutePath(), new WatchedDirInfo(null, true, this.filter));
    }

    @Override
    public void postOrder(File f) {
    }

    @Override
    public boolean walkSubdirs(File f) {
        return true;
    }
}

