/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.cm.filemonitor;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.BlockingQueue;
import org.hyperic.cm.filemonitor.IChangeListener;
import org.hyperic.cm.filemonitor.data.EventActionsEnum;
import org.hyperic.cm.filemonitor.data.EventMessage;
import org.hyperic.cm.versioncontrol.api.IVersionControlDao;
import org.hyperic.cm.versioncontrol.dto.ChangeTypeDto;
import org.hyperic.cm.versioncontrol.dto.RevisionDiffItem;
import org.hyperic.cm.versioncontrol.util.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ChangeEventProcessor
implements Runnable {
    @Autowired
    private IVersionControlDao versionControlDao;
    @Autowired
    private IChangeListener changeListener;
    private final BlockingQueue<EventMessage> messageQueue;
    private String versionContorlDir;
    private long maxDiffSize;
    private static Logger log = LoggerFactory.getLogger(ChangeEventProcessor.class);
    private boolean stop = false;

    public void setStop(boolean stop) {
        this.stop = stop;
    }

    public ChangeEventProcessor(BlockingQueue<EventMessage> messageQueue) {
        this.messageQueue = messageQueue;
        this.init();
    }

    public void init() {
        String appDataDir = null;
        String maxDiffSize = null;
        try {
            Properties props = Utils.getPropertiesFromClasspath(this.getClass(), (String)"fm-config.properties");
            appDataDir = props.getProperty("fm.dataDir");
            maxDiffSize = props.getProperty("fm.maxDiffSize");
        }
        catch (IOException e) {
            log.error("Properties file not loaded, " + e.getMessage(), (Throwable)e);
        }
        if (appDataDir != null && appDataDir.length() > 0) {
            this.setVersionContorlDir(appDataDir);
        }
        try {
            long l = Long.valueOf(maxDiffSize);
            this.setMaxDiffSize(l);
        }
        catch (NumberFormatException e) {
            log.info("Max size property not found or not valid number");
        }
    }

    @Override
    public void run() {
        boolean success = this.versionControlDao.createRepository(this.versionContorlDir);
        if (!success) {
            log.error("Failure creating vcDao repository for git Dir: " + this.versionContorlDir);
            return;
        }
        EventActionsEnum action = null;
        String path = null;
        LinkedList<EventMessage> deleteList = new LinkedList<EventMessage>();
        EventMessage lastCreateDirEvent = null;
        log.info("ChangeEventProcessor started");
        LinkedList<String> registerFiles = new LinkedList<String>();
        LinkedList<String> batchCreateFiles = new LinkedList<String>();
        long lastDummyTime = 0L;
        while (!this.stop) {
            try {
                EventMessage event = this.messageQueue.take();
                action = event.getType();
                if (log.isDebugEnabled()) {
                    log.debug("Event taken " + action.protocolValue() + " " + event.getFullPath());
                }
                if (EventActionsEnum.SKIPPED.equals((Object)action)) continue;
                if (EventActionsEnum.REGISTER_COMPLETE.equals((Object)action)) {
                    log.info("Register complete!");
                    continue;
                }
                File f = event.getFullPath() == null ? null : new File(event.getFullPath());
                String ePath = event.getFullPath();
                EventMessage nextEvent = (EventMessage)this.messageQueue.peek();
                if (nextEvent == null) {
                    if (action == EventActionsEnum.DELETE) {
                        Thread.sleep(500L);
                    } else if (action == EventActionsEnum.MODIFY) {
                        Thread.sleep(200L);
                    } else if (action == EventActionsEnum.CREATE || action == EventActionsEnum.REGISTER) {
                        Thread.sleep(100L);
                    }
                    nextEvent = (EventMessage)this.messageQueue.peek();
                }
                if (nextEvent != null && EventActionsEnum.SKIPPED.equals((Object)nextEvent.getType())) {
                    lastDummyTime = nextEvent.getTimestamp();
                    nextEvent.setFullPath(event.getFullPath());
                    nextEvent.setTimestamp(event.getTimestamp());
                    nextEvent.setType(event.getType());
                    nextEvent.setOldFullPath(event.getOldFullPath());
                    continue;
                }
                if (log.isDebugEnabled()) {
                    log.debug("Next evet: " + (Object)((Object)(nextEvent == null ? null : nextEvent.getType())));
                }
                if (EventActionsEnum.REGISTER.equals((Object)action)) {
                    boolean commit = nextEvent == null || !EventActionsEnum.REGISTER.equals((Object)nextEvent.getType());
                    registerFiles.add(event.getFullPath());
                    if (commit && registerFiles.size() > 0) {
                        String msg = this.addFileBatch(registerFiles, EventActionsEnum.REGISTER);
                        if (msg != null) {
                            String revId = this.versionControlDao.commit(this.getVersionControlDir(), msg);
                            log.info("Commited register, id: " + revId);
                        }
                        registerFiles.clear();
                    }
                    lastDummyTime = 0L;
                    continue;
                }
                if (EventActionsEnum.RENAME.equals((Object)action) && event.getOldFullPath() == null) {
                    action = EventActionsEnum.CREATE;
                    event.setType(EventActionsEnum.CREATE);
                }
                if (nextEvent == null || nextEvent.getTimestamp() - event.getTimestamp() > 500L && nextEvent.getTimestamp() - lastDummyTime > 500L) {
                    lastDummyTime = 0L;
                    if (EventActionsEnum.DELETE.equals((Object)action)) {
                        this.updateDeleteList(deleteList, event);
                    }
                    this.fireFolderDelete(deleteList);
                    if (lastCreateDirEvent != null) {
                        if (action.equals((Object)EventActionsEnum.CREATE) && this.contained(ePath, lastCreateDirEvent.getFullPath())) {
                            this.addToDirCopy(event, batchCreateFiles);
                        }
                        if (batchCreateFiles.size() > 0) {
                            this.fireNClearCreateDirEvent(lastCreateDirEvent, batchCreateFiles);
                        }
                        lastCreateDirEvent = null;
                        continue;
                    }
                    if (f.isDirectory()) {
                        if (!log.isDebugEnabled()) continue;
                        log.debug("Directory event discarded");
                        continue;
                    }
                    if (action.equals((Object)EventActionsEnum.DELETE)) continue;
                    this.processEvent(event);
                    continue;
                }
                if (EventActionsEnum.MODIFY.equals((Object)action) && event.equals(nextEvent)) {
                    log.debug("Duplicate MODIFY events detected, skipping");
                    continue;
                }
                if (EventActionsEnum.DELETE.equals((Object)action)) {
                    if (EventActionsEnum.CREATE.equals((Object)nextEvent.getType()) && event.getFullPath().equals(nextEvent.getFullPath())) {
                        nextEvent.setType(EventActionsEnum.MODIFY);
                        if (!log.isDebugEnabled()) continue;
                        log.debug("overwrite sequence detected (DELETE+CREATE), replacing with MODIFY");
                        continue;
                    }
                    if (EventActionsEnum.DELETE.equals((Object)nextEvent.getType())) {
                        this.updateDeleteList(deleteList, event);
                        continue;
                    }
                    this.updateDeleteList(deleteList, event);
                }
                if (EventActionsEnum.CREATE.equals((Object)action) || EventActionsEnum.MODIFY.equals((Object)action)) {
                    if (EventActionsEnum.MODIFY.equals((Object)nextEvent.getType()) && event.getFullPath().equals(nextEvent.getFullPath())) {
                        if (log.isDebugEnabled()) {
                            log.debug("Dropping modify from create/modify sequence.");
                        }
                        nextEvent.setType(EventActionsEnum.CREATE);
                        continue;
                    }
                    if (EventActionsEnum.CREATE.equals((Object)nextEvent.getType()) || EventActionsEnum.MODIFY.equals((Object)nextEvent.getType())) {
                        String commonPath;
                        if (f.isDirectory()) {
                            if (lastCreateDirEvent != null) {
                                if (this.contained(ePath, lastCreateDirEvent.getFullPath())) {
                                    this.fireFolderDelete(deleteList);
                                    continue;
                                }
                                if (batchCreateFiles.size() > 0) {
                                    this.fireNClearCreateDirEvent(lastCreateDirEvent, batchCreateFiles);
                                }
                            }
                            lastCreateDirEvent = event;
                            if (log.isDebugEnabled()) {
                                log.debug("Directory saved for recursive copy: " + event.getFullPath());
                            }
                            this.fireFolderDelete(deleteList);
                            continue;
                        }
                        if (lastCreateDirEvent != null && this.contained(ePath, lastCreateDirEvent.getFullPath())) {
                            this.addToDirCopy(event, batchCreateFiles);
                            continue;
                        }
                        if (EventActionsEnum.MODIFY.equals((Object)action) && (commonPath = this.getCommonPath(ePath, nextEvent.getFullPath())) != null) {
                            lastCreateDirEvent = new EventMessage(EventActionsEnum.MODIFY, commonPath, lastCreateDirEvent == null ? event.getTimestamp() : lastCreateDirEvent.getTimestamp());
                            this.addToDirCopy(event, batchCreateFiles);
                            this.fireFolderDelete(deleteList);
                            if (!log.isDebugEnabled()) continue;
                            log.debug("Generating common modify directory: " + commonPath);
                            continue;
                        }
                        if (batchCreateFiles.size() > 0) {
                            this.fireNClearCreateDirEvent(lastCreateDirEvent, batchCreateFiles);
                        }
                        lastCreateDirEvent = null;
                    } else if (lastCreateDirEvent != null) {
                        if (batchCreateFiles.size() > 0) {
                            this.fireNClearCreateDirEvent(lastCreateDirEvent, batchCreateFiles);
                        }
                        lastCreateDirEvent = null;
                    }
                }
                this.fireFolderDelete(deleteList);
                if (action.equals((Object)EventActionsEnum.DELETE)) continue;
                this.processEvent(event);
            }
            catch (InterruptedException ex) {
                if (this.stop) break;
                log.error(ex.getMessage(), (Throwable)ex);
                break;
            }
            catch (Exception e) {
                log.error(e.getMessage(), (Throwable)e);
            }
        }
        log.info("ChangeEventProcessor stopped. Last Event: " + action + " " + path + ". Stop flag:" + this.stop);
    }

    private String getCommonPath(String ePath, String fullPath) {
        if (ePath == null || fullPath == null || ePath.length() <= 0 || fullPath.length() <= 0) {
            return null;
        }
        int min = Math.min(ePath.length(), fullPath.length());
        int index = 0;
        int i = 0;
        while (i < min) {
            if (ePath.charAt(i) != fullPath.charAt(i)) break;
            ++index;
            ++i;
        }
        if (index < 2) {
            return null;
        }
        String common = ePath.substring(0, index);
        if (common.endsWith(File.separator)) {
            common = common.substring(0, common.length() - 1);
        } else {
            File f = new File(common);
            common = f.getParent();
        }
        return common;
    }

    private void fireFolderDelete(List<EventMessage> deleteList) {
        for (EventMessage root : deleteList) {
            if (log.isDebugEnabled()) {
                log.debug("fireFolderDelete: " + root.getFullPath());
            }
            this.processEvent(root);
        }
        deleteList.clear();
    }

    private boolean contained(String s1, String s2) {
        if (!s1.startsWith(s2)) {
            return false;
        }
        String tmp = s1;
        while (tmp != null && tmp.length() > 0) {
            File f = new File(tmp);
            if (tmp.equals(s2)) {
                return true;
            }
            tmp = f.getParent();
        }
        return false;
    }

    private void addToDirCopy(EventMessage e, Collection<String> batchCreateFiles) {
        String path = e.getFullPath();
        File f = new File(e.getFullPath());
        if (f.isDirectory()) {
            if (log.isDebugEnabled()) {
                log.debug("Skipping directory " + path);
            }
            return;
        }
        batchCreateFiles.add(path);
    }

    private void fireNClearCreateDirEvent(EventMessage lastCreateDirEvent, Collection<String> paths) {
        if (log.isDebugEnabled()) {
            log.debug("fireNClearCreateDirEvent: " + lastCreateDirEvent.getFullPath());
        }
        String gitDir = this.getVersionControlDir();
        String msg = String.valueOf(lastCreateDirEvent.getFullPath()) + "\n";
        String res = this.versionControlDao.addChange(gitDir, paths, msg, false);
        paths.clear();
        if (res != null) {
            this.processCommit(lastCreateDirEvent, msg);
        }
    }

    private void updateDeleteList(List<EventMessage> deleteList, EventMessage event) {
        String parent;
        boolean improves = false;
        boolean represented = false;
        EventMessage updatedEvent = new EventMessage(event);
        File f = new File(event.getFullPath());
        File parentF = null;
        while ((parent = f.getParent()) != null && parent.length() > 0 && !(parentF = new File(parent)).exists()) {
            f = parentF;
        }
        updatedEvent.setFullPath(f.getPath());
        ArrayList<EventMessage> tmpDelList = new ArrayList<EventMessage>(deleteList);
        for (EventMessage root : tmpDelList) {
            if (root.getFullPath().startsWith(updatedEvent.getFullPath())) {
                improves = true;
                deleteList.remove(root);
            }
            if (!updatedEvent.getFullPath().startsWith(root.getFullPath())) continue;
            represented = true;
            break;
        }
        if (!represented || improves) {
            deleteList.add(updatedEvent);
        }
        if (log.isDebugEnabled()) {
            String s = "\nPath recieved: " + event.getFullPath();
            for (EventMessage item : deleteList) {
                s = String.valueOf(s) + "\n" + item.getFullPath();
            }
            log.debug("rootSet items:" + s);
        }
    }

    private String addFileBatch(Collection<String> paths, EventActionsEnum action) {
        log.info("addFiles: - multiple file " + action.protocolValue());
        String message = String.valueOf(System.currentTimeMillis());
        String gitDir = this.getVersionControlDir();
        String res = this.versionControlDao.addChange(gitDir, paths, message, false);
        return res;
    }

    private String addChange(EventMessage event) {
        EventActionsEnum action = event.getType();
        String path = event.getFullPath();
        String oldPath = EventActionsEnum.RENAME.equals((Object)action) ? event.getOldFullPath() : null;
        Long time = event.getTimestamp();
        String message = String.valueOf(time);
        if (log.isDebugEnabled()) {
            log.debug("addChange: " + action.protocolValue() + " " + path);
        }
        String gitDir = this.getVersionControlDir();
        String res = this.versionControlDao.addChange(gitDir, path, oldPath, message, false);
        return res;
    }

    private void processEvent(EventMessage event) {
        String res = this.addChange(event);
        if (res == null) {
            return;
        }
        this.processCommit(event, res);
    }

    private void processCommit(EventMessage event, String message) {
        EventActionsEnum adjustedAction;
        String[] stringArray;
        EventActionsEnum action = event.getType();
        String path = event.getFullPath();
        String gitDir = this.getVersionControlDir();
        String revId = this.versionControlDao.commit(gitDir, message);
        if (revId == null) {
            stringArray = null;
        } else {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = revId;
        }
        String[] revIds = stringArray;
        event.setRevisionId(revId);
        Collection<RevisionDiffItem> items = null;
        if (!EventActionsEnum.RENAME.equals((Object)action)) {
            Collection<RevisionDiffItem> collection = items = revIds == null ? null : this.getDiffItems(revIds, Arrays.asList(path));
            if (items == null || items.size() <= 0) {
                return;
            }
        }
        boolean folderCreate = EventActionsEnum.CREATE.equals((Object)action) && new File(event.getFullPath()).isDirectory();
        EventActionsEnum eventActionsEnum = adjustedAction = folderCreate ? action : this.getAdjustedAction(items, action);
        if (!adjustedAction.equals((Object)action)) {
            log.info("Event changed from " + (Object)((Object)action) + " to " + (Object)((Object)adjustedAction));
            action = adjustedAction;
            event.setType(action);
        }
        if (EventActionsEnum.MODIFY.equals((Object)action) || folderCreate) {
            String diff = this.getDiff(path, items);
            if (diff == null) {
                return;
            }
            event.setDiff(diff);
        }
        if (log.isInfoEnabled()) {
            String oldPathMsg = event.getOldFullPath() == null ? "" : " Old path: " + event.getOldFullPath();
            log.info("Event processed and fired: revId:" + event.getRevisionId() + " " + (Object)((Object)event.getType()) + " " + event.getFullPath() + " " + oldPathMsg);
        }
        if (log.isDebugEnabled() && event.getDiff() != null) {
            log.debug("Diff: " + event.getDiff());
        }
        this.fireEvent(event);
    }

    private String getDiff(String path, Collection<RevisionDiffItem> items) {
        String diff;
        boolean folder;
        File f = new File(path);
        boolean bl = folder = f != null && f.isDirectory();
        if (items == null || items.size() <= 0) {
            diff = null;
        } else if (items.size() == 1 && !folder) {
            int pos;
            RevisionDiffItem item = items.iterator().next();
            diff = this.versionControlDao.getLastChangeDiff(this.getVersionControlDir(), item);
            if (diff != null && (pos = diff.indexOf("@@ ")) > 0 && diff.length() > pos + 3) {
                diff = String.valueOf(path) + System.getProperty("line.separator") + diff.substring(pos);
            }
        } else {
            diff = this.versionControlDao.getStatus(path, items);
        }
        if (diff == null) {
            if (log.isDebugEnabled()) {
                log.debug("No diff detected for: " + path);
            }
            return null;
        }
        if ((long)diff.length() > this.maxDiffSize / 2L) {
            diff = diff.substring(0, (int)this.maxDiffSize / 2);
            diff = String.valueOf(diff) + " (Diff truncated due to length...)";
        }
        return diff;
    }

    private EventActionsEnum getAdjustedAction(Collection<RevisionDiffItem> items, EventActionsEnum action) {
        if (!EventActionsEnum.REGISTER.equals((Object)action) && !EventActionsEnum.CREATE.equals((Object)action) || items == null || items.size() <= 0) {
            return action;
        }
        if (items.size() == 1) {
            RevisionDiffItem item = items.iterator().next();
            if (item.getChangeType().equals((Object)ChangeTypeDto.MODIFY)) {
                return EventActionsEnum.MODIFY;
            }
        } else {
            boolean isCreate = true;
            for (RevisionDiffItem item : items) {
                if (item.getChangeType().equals((Object)ChangeTypeDto.ADD)) continue;
                isCreate = false;
                break;
            }
            if (!isCreate) {
                return EventActionsEnum.MODIFY;
            }
        }
        return action;
    }

    private Collection<RevisionDiffItem> getDiffItems(String[] revIds, Collection<String> filePaths) {
        ArrayList<RevisionDiffItem> items = new ArrayList<RevisionDiffItem>();
        String[] stringArray = revIds;
        int n = revIds.length;
        int n2 = 0;
        while (n2 < n) {
            String id = stringArray[n2];
            try {
                Collection revItems = this.versionControlDao.getChangeInfo(id, this.getVersionControlDir(), filePaths);
                if (revItems != null && revItems.size() > 0) {
                    items.addAll(revItems);
                }
            }
            catch (IOException e) {
                log.error(e.getMessage(), (Throwable)e);
            }
            ++n2;
        }
        if (log.isDebugEnabled()) {
            log.debug("---BENCHMARK--- getDiffItems end");
        }
        return items;
    }

    private void fireEvent(EventMessage event) {
        this.changeListener.onChange(event);
    }

    public void onDestroy() {
        this.changeListener = null;
    }

    public String getVersionControlDir() {
        return this.versionContorlDir;
    }

    public void setVersionContorlDir(String gitDir) {
        this.versionContorlDir = gitDir;
    }

    public IVersionControlDao getVersionControlDao() {
        return this.versionControlDao;
    }

    public void setVersionControlDao(IVersionControlDao versionControlDao) {
        this.versionControlDao = versionControlDao;
    }

    public long getMaxDiffSize() {
        return this.maxDiffSize;
    }

    public void setMaxDiffSize(long maxDiffSize) {
        this.maxDiffSize = maxDiffSize * 1024L;
    }
}

