/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.hq.agent.server;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hyperic.hq.agent.AgentLoaderException;
import org.hyperic.hq.agent.server.AgentServerHandler;
import org.hyperic.util.PluginLoader;

class ServerHandlerLoader {
    private Log logger = LogFactory.getLog(ServerHandlerLoader.class);
    private ClassLoader _loader;

    ServerHandlerLoader(ClassLoader loader) {
        this._loader = loader;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    AgentServerHandler loadServerHandler(String jarPath) throws AgentLoaderException {
        Class pluginClass;
        AgentServerHandler handler;
        block5: {
            handler = null;
            pluginClass = null;
            try {
                try {
                    PluginLoader loader = PluginLoader.create((String)jarPath, (ClassLoader)this._loader);
                    PluginLoader.setClassLoader((ClassLoader)loader);
                    pluginClass = loader.loadPlugin();
                    handler = (AgentServerHandler)pluginClass.newInstance();
                }
                catch (Exception e) {
                    this.logger.error((Object)"Error loading server handler jar", (Throwable)e);
                    throw new AgentLoaderException("Unable to load server handler jar: " + e.getMessage());
                }
                Object var6_6 = null;
                if (handler == null) break block5;
            }
            catch (Throwable throwable) {
                Object var6_7 = null;
                if (handler != null) {
                    PluginLoader.resetClassLoader(handler);
                }
                throw throwable;
            }
            PluginLoader.resetClassLoader((Object)handler);
        }
        this.validateServerHandler(handler, pluginClass.getName());
        return handler;
    }

    private void validateServerHandler(Object sHandler, String sHandlerName) throws AgentLoaderException {
        Class<AgentServerHandler> tc = AgentServerHandler.class;
        if (!tc.isInstance(sHandler)) {
            throw new AgentLoaderException(sHandlerName + " is not a valid " + "server handler (it does not " + "implement AgentServerHandler");
        }
    }
}

