/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vfabric.hyperic.plugin.vfgf.detector;

import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hyperic.hq.agent.AgentCommand;
import org.hyperic.hq.agent.AgentRemoteValue;
import org.hyperic.hq.agent.server.AgentDaemon;
import org.hyperic.hq.autoinventory.ScanConfigurationCore;
import org.hyperic.hq.product.PlatformDetector;
import org.hyperic.hq.product.PlatformResource;
import org.hyperic.hq.product.PluginException;
import org.hyperic.util.config.ConfigResponse;

public class GF7PlatformDetector
extends PlatformDetector {
    private static Log log = LogFactory.getLog(GF7PlatformDetector.class);
    private static Map<String, ConfigResponse> configs = new HashMap<String, ConfigResponse>();

    public PlatformResource getPlatformResource(ConfigResponse config) throws PluginException {
        log.debug((Object)("[getPlatformResource] config=" + config));
        try {
            String id = config.getValue("locators");
            configs.put(id, config);
        }
        catch (Exception e) {
            throw new PluginException(e.getMessage(), (Throwable)e);
        }
        log.debug((Object)("[getPlatformResource] configs=" + configs));
        PlatformResource res = super.getPlatformResource(config);
        return res;
    }

    public static void runAutoDiscovery(String id) {
        log.debug((Object)("[runAutoDiscovery] Starting auto discovery for id=" + id));
        log.debug((Object)("[runAutoDiscovery] configs=" + configs));
        try {
            ScanConfigurationCore scanConfig = new ScanConfigurationCore();
            ConfigResponse c = configs.get(id);
            if (c != null) {
                scanConfig.setConfigResponse(c);
                AgentRemoteValue configARV = new AgentRemoteValue();
                scanConfig.toAgentRemoteValue("scanConfig", configARV);
                AgentCommand ac = new AgentCommand(1, 1, "autoinv:startScan", configARV);
                AgentDaemon.getMainInstance().getCommandDispatcher().processRequest(ac, null, null);
                log.info((Object)("[runAutoDiscovery] id=" + id + " << OK"));
            } else {
                log.debug((Object)("[runAutoDiscovery] Config not found for id=" + id));
            }
        }
        catch (Exception ex) {
            log.error((Object)("[runAutoDiscovery] id=" + id + " " + ex), (Throwable)ex);
        }
    }
}

