/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vfabric.hyperic.plugin.vfgf.detector;

import com.vmware.vfabric.hyperic.plugin.vfgf.detector.MemberDetector;
import com.vmware.vfabric.hyperic.plugin.vfgf.util.GFMXUtils;
import com.vmware.vfabric.hyperic.plugin.vfgf.util.GFUtils;
import java.util.ArrayList;
import javax.management.ObjectName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hyperic.util.config.ConfigResponse;

public class ApplicationPeerDetector
extends MemberDetector {
    private static final Log log = LogFactory.getLog(ApplicationPeerDetector.class);

    protected boolean hasCorrectRoles(int mask) {
        log.debug((Object)GFUtils.roleMaskToDebugString(mask));
        return (mask & 4) == 4 && (mask & 2) != 2 && (mask & 1) != 1;
    }

    protected MemberDetector.StatType[] filterSupportedStats(Object[][] statObjects, ConfigResponse config) {
        ArrayList<MemberDetector.StatType> stats = new ArrayList<MemberDetector.StatType>();
        for (int i = 0; i < statObjects.length; ++i) {
            ObjectName o = (ObjectName)statObjects[i][0];
            String type = (String)statObjects[i][1];
            String name = GFMXUtils.getField(o, "name");
            if (name.equals("distributionStats")) {
                stats.add(new MemberDetector.StatType(this, "Distribution Statistics", o));
                continue;
            }
            if (name.equals("FunctionExecution")) {
                stats.add(new MemberDetector.StatType(this, "Function Service", o));
                continue;
            }
            if (!type.equals("FunctionStatistics")) continue;
            stats.add(new MemberDetector.StatType(this, "Function", o, o.getKeyProperty("name")));
        }
        return stats.toArray(new MemberDetector.StatType[0]);
    }
}

