/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.hq.plugin.jboss7;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.logging.Log;
import org.hyperic.hq.plugin.jboss7.JBossAdminHttp;
import org.hyperic.hq.product.ControlPlugin;
import org.hyperic.hq.product.PluginException;
import org.hyperic.sigar.OperatingSystem;
import org.hyperic.sigar.win32.Win32;
import org.hyperic.util.ArrayUtil;
import org.hyperic.util.StringUtil;
import org.hyperic.util.config.ConfigResponse;
import org.hyperic.util.exec.Execute;
import org.hyperic.util.exec.ExecuteStreamHandler;
import org.hyperic.util.exec.ExecuteWatchdog;
import org.hyperic.util.exec.PumpStreamHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JBoss7Control
extends ControlPlugin {
    private final Log log = this.getLog();
    private JBossAdminHttp admin;
    private static final String BACKGROUND_SCRIPT = "background" + JBoss7Control.getScriptExtension();
    private String script;
    private String cwd;
    private String background;
    private List<String> prefix;
    private List<String> args;
    public static String START_SCRIPT = "jboss7.start.script";
    private String PREFIX = "jboss7.start.prefix";
    private String ARGS = "jboss7.start.args";

    public void configure(ConfigResponse config) throws PluginException {
        super.configure(config);
        this.log.debug((Object)("[configure] config=" + config));
        this.admin = new JBossAdminHttp(this.getConfig().toProperties());
        File sh = new File(this.getConfig(START_SCRIPT));
        if (!sh.exists()) {
            throw new PluginException("Start script '" + sh + "' NOT FOUND");
        }
        this.cwd = sh.getParentFile().getAbsolutePath();
        this.script = sh.getAbsolutePath();
        String argsStr = this.getConfig(this.ARGS);
        this.args = new ArrayList<String>();
        if (argsStr != null && argsStr.length() != 0) {
            try {
                String[] argsArgs = StringUtil.explodeQuoted((String)argsStr);
                this.args.addAll(Arrays.asList(argsArgs));
            }
            catch (IllegalArgumentException e) {
                throw new PluginException("Unable to parse arguments: '" + argsStr + "' " + e, (Throwable)e);
            }
        }
        String prefixStr = this.getConfig(this.PREFIX);
        this.prefix = new ArrayList<String>();
        if (prefixStr != null && prefixStr.length() != 0) {
            try {
                String[] prefixArgs = StringUtil.explodeQuoted((String)prefixStr);
                this.prefix.addAll(Arrays.asList(prefixArgs));
            }
            catch (IllegalArgumentException e) {
                throw new PluginException("Unable to parse prefix: '" + prefixStr + "' " + e, (Throwable)e);
            }
        }
        File agentBundleHome = new File(System.getProperty("agent.bundle.home"));
        File bg = new File(agentBundleHome, BACKGROUND_SCRIPT);
        this.log.debug((Object)("[configure] agentBundleHome =" + agentBundleHome.getAbsolutePath()));
        this.log.debug((Object)("[configure] bg =" + bg.getAbsolutePath()));
        if (bg.exists()) {
            try {
                this.background = bg.getCanonicalPath();
            }
            catch (IOException ex) {
                this.background = bg.getAbsolutePath();
            }
        } else {
            throw new PluginException("Background script '" + bg + "' NOT FOUND");
        }
        this.log.debug((Object)("[configure] background =" + this.background));
        this.log.debug((Object)("[configure] cwd = " + this.cwd));
        this.log.debug((Object)("[configure] prefix = " + this.prefix));
        this.log.debug((Object)("[configure] script = " + this.script));
        this.log.debug((Object)("[configure] args = " + this.args));
    }

    public List<String> getActions() {
        return Arrays.asList("start", "stop", "restart");
    }

    public void stop() throws PluginException {
        this.log.debug((Object)("[stop] config=" + this.getConfig()));
        if (!this.isRunning()) {
            throw new PluginException("Server is not running");
        }
        this.admin.shutdown();
        this.waitForState("stopped");
    }

    protected boolean isRunning() {
        boolean res = true;
        try {
            this.admin.testConnection();
        }
        catch (PluginException ex) {
            this.log.debug((Object)ex, (Throwable)ex);
            res = false;
        }
        this.log.debug((Object)("[isRunning] res = " + res));
        return res;
    }

    public void start() throws PluginException {
        this.log.debug((Object)("[start] config=" + this.getConfig()));
        if (this.isRunning()) {
            throw new PluginException("Server is running");
        }
        this.doCommand();
        this.waitForState("started");
    }

    public void restart() throws PluginException {
        this.log.debug((Object)"[restart]");
        if (this.isRunning()) {
            this.stop();
        }
        this.start();
    }

    protected void doCommand() throws PluginException {
        ArrayList<String> cmd = new ArrayList<String>();
        ExecuteWatchdog watchdog = new ExecuteWatchdog(this.getTimeoutMillis());
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        Execute ex = new Execute((ExecuteStreamHandler)new PumpStreamHandler((OutputStream)output), watchdog);
        ex.setWorkingDirectory(new File(this.cwd));
        cmd.addAll(this.prefix);
        cmd.add(this.background);
        if (OperatingSystem.IS_WIN32) {
            String exe = Win32.findScriptExecutable((String)this.script);
            if (exe != null) {
                cmd.add(exe);
            }
        } else {
            cmd.add(this.script);
        }
        cmd.addAll(this.args);
        this.log.debug((Object)("[doCommand] cmd=" + cmd));
        ex.setCommandline(cmd.toArray(new String[0]));
        Object[] env = new String[]{"HQ_CONTROL_WAIT=10"};
        env = (String[])ArrayUtil.combine((Object[])env, (Object[])ex.getEnvironment());
        ex.setEnvironment((String[])env);
        int exitCode = -1;
        try {
            exitCode = ex.execute();
        }
        catch (Exception e) {
            this.getLog().error((Object)e.getMessage(), (Throwable)e);
            throw new PluginException((Throwable)e);
        }
        if (exitCode == 0) {
            this.setResult(0);
            this.setMessage("OK");
        } else {
            this.setResult(-1);
            this.setMessage(output.toString());
        }
        if (watchdog.killedProcess()) {
            String err = "Command did not complete within timeout of " + this.getTimeout() + " seconds";
            this.getLog().error((Object)err);
            this.setMessage(err);
            this.setResult(-1);
        }
        this.log.debug((Object)("[doCommand] result=" + this.getResult() + ", exitCode=" + exitCode));
        if (this.getResult() == -1) {
            throw new PluginException(this.getMessage());
        }
    }
}

