/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.hq.plugin.jboss7;

import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hyperic.hq.plugin.jboss7.ConnectorCollector;
import org.hyperic.hq.plugin.jboss7.JBoss7DefaultCollector;
import org.hyperic.hq.plugin.jboss7.JBossAdminHttp;
import org.hyperic.hq.plugin.jboss7.objects.Deployment;
import org.hyperic.hq.product.CollectorResult;
import org.hyperic.hq.product.Metric;
import org.hyperic.hq.product.MetricValue;
import org.hyperic.hq.product.PluginException;

public class DeploymentCollector
extends JBoss7DefaultCollector {
    private static final Log log = LogFactory.getLog(ConnectorCollector.class);

    public void collect(JBossAdminHttp admin) {
        String connector = (String)this.getProperties().get("connector");
        try {
            List<Deployment> deployments = admin.getDeployments();
            for (Deployment d : deployments) {
                String name = d.getName();
                this.setValue(name + "." + "Availability", d.getEnabled() != false ? 1.0 : 0.0);
            }
        }
        catch (PluginException ex) {
            this.setAvailability(false);
            log.debug((Object)ex.getMessage(), (Throwable)ex);
        }
    }

    public MetricValue getValue(Metric metric, CollectorResult result) {
        MetricValue res = result.getMetricValue(metric.getAttributeName());
        if (metric.getAttributeName().endsWith("Availability")) {
            if (res.getValue() != 1.0) {
                res = new MetricValue(0.0, System.currentTimeMillis());
            }
            log.debug((Object)("[getValue] Member=" + metric.getObjectProperty("member.name") + " metric=" + metric.getAttributeName() + " res=" + res.getValue()));
        }
        return res;
    }

    public Log getLog() {
        return log;
    }
}

