/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.hq.plugin.jboss.jmx;

import java.util.ArrayList;
import java.util.Properties;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import org.hyperic.hq.plugin.jboss.jmx.JBossQuery;
import org.hyperic.hq.plugin.jboss.jmx.ServerQuery;
import org.hyperic.hq.product.PluginException;
import org.hyperic.util.config.ConfigSchema;

public abstract class ServiceQuery
extends JBossQuery {
    protected ObjectName objectName;
    private JBossQuery parent;
    private ServerQuery serverQuery;
    private Properties cprops;

    public abstract String getQueryName();

    void setObjectName(ObjectName objectName) {
        this.objectName = objectName;
        String name = objectName.getKeyProperty("name");
        if (name == null) {
            name = objectName.getKeyProperty(this.getPropertyName());
        }
        if (name != null) {
            this.setName(name);
        }
    }

    public boolean apply(ObjectName name) {
        return true;
    }

    public ServiceQuery cloneInstance() {
        ServiceQuery query;
        try {
            query = (ServiceQuery)this.getClass().newInstance();
        }
        catch (InstantiationException e) {
            throw new IllegalArgumentException(e.getMessage());
        }
        catch (IllegalAccessException e) {
            throw new IllegalArgumentException(e.getMessage());
        }
        query.setParent(this.getParent());
        query.setName(this.getName());
        return query;
    }

    public String[] getAttributeNames() {
        String type = this.getResourceType();
        ConfigSchema schema = this.getServerDetector().getCustomPropertiesSchema(type);
        return schema.getOptionNames();
    }

    public final void getAttributes(MBeanServerConnection mServer) throws PluginException {
        String[] names = this.getAttributeNames();
        if (names.length == 0) {
            this.cprops = EMPTY_PROPERTIES;
        } else {
            this.getAttributes(mServer, this.getObjectName(), names);
            this.cprops = new Properties();
            for (int i = 0; i < names.length; ++i) {
                String key = names[i];
                String val = this.getAttribute(key);
                if (val == null) continue;
                this.cprops.setProperty(key, val);
            }
        }
    }

    public String getIdentifier() {
        return this.getName();
    }

    public String getResourceType() {
        return this.getServerQuery().getResourceType() + " " + this.getServiceResourceType();
    }

    public abstract String getServiceResourceType();

    protected abstract String getPropertyName();

    public Properties getResourceConfig() {
        Properties props = new Properties();
        if (this.getName() != null) {
            props.setProperty(this.getPropertyName(), this.getName());
        }
        return props;
    }

    public Properties getCustomProperties() {
        return this.cprops;
    }

    public ObjectName getObjectName() {
        return this.objectName;
    }

    public String getQualifiedName() {
        StringBuilder buf = new StringBuilder();
        ArrayList<String> names = new ArrayList<String>();
        String name = this.getName();
        if (name != null) {
            names.add(name);
        }
        JBossQuery query = this;
        while ((query = query.getParent()) != null) {
            names.add(query.getQualifiedName());
        }
        for (int i = names.size() - 1; i >= 0; --i) {
            buf.append(names.get(i));
            if (i == 0) continue;
            buf.append(" ");
        }
        if (buf.length() != 0) {
            buf.append(" ");
        }
        buf.append(this.getServiceResourceType());
        return buf.toString();
    }

    public JBossQuery getParent() {
        return this.parent;
    }

    public void setParent(JBossQuery parent) {
        this.parent = parent;
    }

    public ServerQuery getServerQuery() {
        return this.serverQuery;
    }

    public void setServerQuery(ServerQuery serverQuery) {
        this.serverQuery = serverQuery;
    }
}

