/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.hq.plugin.jboss.jmx;

import java.io.IOException;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.management.MBeanInfo;
import javax.management.MBeanServerConnection;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hyperic.hq.plugin.jboss.jmx.ConnectionPoolQuery;
import org.hyperic.hq.plugin.jboss.jmx.EntityBeanQuery;
import org.hyperic.hq.plugin.jboss.jmx.GenericServiceQuery;
import org.hyperic.hq.plugin.jboss.jmx.JBossQuery;
import org.hyperic.hq.plugin.jboss.jmx.MessageDrivenBeanQuery;
import org.hyperic.hq.plugin.jboss.jmx.ServiceQuery;
import org.hyperic.hq.plugin.jboss.jmx.StatefulSessionBeanQuery;
import org.hyperic.hq.plugin.jboss.jmx.StatelessSessionBeanQuery;
import org.hyperic.hq.product.PluginException;
import org.hyperic.hq.product.ServerDetector;

public class ServerQuery
extends JBossQuery {
    private static final Log log = LogFactory.getLog((String)"JBossServerQuery");
    public static final String SERVER_NAME = "jboss.system:type=Server";
    private static final String SERVER_CONFIG_NAME = "jboss.system:type=ServerConfig";
    private static final String SERVER_INFO_NAME = "jboss.system:type=ServerInfo";
    private static final String ATTR_HOMEDIR = "HomeDir";
    private static final String ATTR_SERVER_URL = "ServerHomeURL";
    private static final String ATTR_SERVER_NAME = "ServerName";
    public static final String ATTR_VERSION = "Version";
    private static final String[] ATTRS_SERVER = new String[]{"Version", "BuildDate", "VersionName"};
    private static final String[] ATTRS_SERVER_CONFIG = new String[]{"HomeDir", "ServerHomeURL", "ServerName"};
    private static final String[] ATTRS_SERVER_INFO = new String[]{"JavaVersion", "JavaVendor"};
    private String installPath;
    private String version;
    private String type;
    private List services = new ArrayList();

    public ServerQuery(ServerDetector detector) {
        this.setServerDetector(detector);
    }

    public List getServiceQueries() {
        return this.services;
    }

    public void getAttributes(MBeanServerConnection mServer) throws PluginException {
        ObjectName name;
        try {
            name = new ObjectName(SERVER_NAME);
        }
        catch (MalformedObjectNameException e) {
            throw new IllegalArgumentException(e.getMessage());
        }
        this.getAttributes(mServer, name, ATTRS_SERVER);
        try {
            name = new ObjectName(SERVER_CONFIG_NAME);
        }
        catch (MalformedObjectNameException e) {
            throw new IllegalArgumentException(e.getMessage());
        }
        this.getAttributes(mServer, name, ATTRS_SERVER_CONFIG);
        try {
            name = new ObjectName(SERVER_INFO_NAME);
        }
        catch (MalformedObjectNameException e) {
            throw new IllegalArgumentException(e.getMessage());
        }
        this.getAttributes(mServer, name, ATTRS_SERVER_INFO);
        String fullVersion = this.getAttribute(ATTR_VERSION).substring(0, 5);
        this.setAttribute("version", fullVersion);
        String ver = fullVersion.substring(0, 3);
        this.setVersion(ver);
        this.setName(this.getAttribute(ATTR_SERVER_NAME));
        this.setInstallPath(this.getAttribute(ATTR_HOMEDIR));
    }

    public String getServerURL() {
        return this.getAttribute(ATTR_SERVER_URL);
    }

    public void findServices(MBeanServerConnection mServer) throws PluginException {
        ServiceQuery[] queries = new ServiceQuery[]{new StatelessSessionBeanQuery(), new StatefulSessionBeanQuery(), new EntityBeanQuery(), new MessageDrivenBeanQuery(), new ConnectionPoolQuery()};
        for (int i = 0; i < queries.length; ++i) {
            this.findServices(mServer, queries[i]);
        }
        Map servicePlugins = this.getServerDetector().getServiceInventoryPlugins();
        if (servicePlugins == null) {
            return;
        }
        for (Map.Entry entry : servicePlugins.entrySet()) {
            GenericServiceQuery query;
            String _type = (String)entry.getKey();
            String name = (String)entry.getValue();
            if (name == null) {
                query = new GenericServiceQuery();
            } else {
                try {
                    Class<?> plugin = Class.forName(name);
                    query = (GenericServiceQuery)plugin.newInstance();
                }
                catch (Exception e) {
                    log.error((Object)("Creating " + name + ": " + e), (Throwable)e);
                    continue;
                }
            }
            query.setType(_type);
            query.setParent(this);
            log.debug((Object)("[findServices] type='" + _type + "'"));
            try {
                this.findServices(mServer, query);
            }
            catch (IllegalArgumentException e) {
                String msg = "Error running query for " + _type + ": " + e.getMessage();
                log.error((Object)msg, (Throwable)e);
            }
        }
    }

    private void findServices(MBeanServerConnection mServer, ServiceQuery query) throws PluginException {
        Set<ObjectName> _services;
        query.initialize();
        String mbeanClass = null;
        if (query instanceof GenericServiceQuery) {
            mbeanClass = ((GenericServiceQuery)query).getMBeanClass();
        }
        try {
            ObjectName name = new ObjectName(query.getQueryName());
            _services = mServer.queryNames(name, null);
            log.debug((Object)("[findServices] " + name + " -> (" + mbeanClass + ") '" + _services.size() + "'"));
        }
        catch (MalformedObjectNameException e) {
            String msg = query.getQueryName() + ": " + e.getMessage();
            throw new IllegalArgumentException(msg);
        }
        catch (RemoteException e) {
            throw new PluginException("Cannot connect to JBoss", (Throwable)e);
        }
        catch (IOException e) {
            throw new PluginException("Cannot connecto to JBoss", (Throwable)e);
        }
        for (ObjectName name : _services) {
            if (!this.checkClass(mServer, name, mbeanClass)) continue;
            boolean apply = query.apply(name);
            log.debug((Object)("[findServices] " + (apply ? "+" : "-") + " name='" + name + "'"));
            if (!apply) continue;
            ServiceQuery service = query.cloneInstance();
            service.setObjectName(name);
            this.services.add(service);
            service.setParent(this);
            service.setServerQuery(this);
            service.getAttributes(mServer);
        }
        log.debug((Object)"***********************************************");
    }

    private boolean checkClass(MBeanServerConnection mServer, ObjectName name, String mbeanClass) {
        boolean res = true;
        if (mbeanClass != null) {
            try {
                MBeanInfo info = mServer.getMBeanInfo(name);
                res = info.getClassName().matches(mbeanClass);
            }
            catch (Exception e) {
                log.error((Object)("mServer.getMBeanInfo(" + name + "): " + e));
                res = false;
            }
        }
        return res;
    }

    public String getQualifiedName() {
        String fqdn = this.getServerDetector().getConfig("platform.fqdn");
        return fqdn + " " + this.getResourceType() + " " + this.getName();
    }

    public String getResourceType() {
        return this.getServerDetector().getTypeInfo().getName();
    }

    public String getIdentifier() {
        return this.getInstallPath();
    }

    public Properties getControlConfig() {
        Properties config = new Properties();
        config.put("configSet", this.getName());
        return config;
    }

    public String getInstallPath() {
        return this.installPath;
    }

    public void setInstallPath(String installPath) {
        this.installPath = installPath;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }
}

