/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.hq.agent;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hyperic.hq.agent.AgentRemoteException;
import org.hyperic.util.GenericValueMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AgentRemoteValue
implements GenericValueMap,
Externalizable {
    private static final long serialVersionUID = 644682754857767836L;
    private static Log _log = LogFactory.getLog(AgentRemoteValue.class);
    private Map<String, String> vals = new LinkedHashMap<String, String>();
    private static final int MAX_VALUE_SIZE = 65535;
    private static final String CHUNK_PREFIX = "-chunk";

    public AgentRemoteValue() {
    }

    public AgentRemoteValue(String[][] keyvals) throws IllegalArgumentException {
        for (int i = 0; i < keyvals.length; ++i) {
            if (keyvals[i].length != 2) {
                throw new IllegalArgumentException("Arg index " + i + "didn't contain 2 values");
            }
            this.setValue(keyvals[i][0], keyvals[i][1]);
        }
    }

    public void setValue(String key, String val) {
        if (key == null || val == null) {
            _log.warn((Object)("Invalid key/value found.  Key='" + key + "' value='" + val + "'"));
            return;
        }
        this.vals.put(key, val);
    }

    public String getValue(String key) {
        return this.vals.get(key);
    }

    public long getValueAsLong(String key) throws AgentRemoteException {
        String val = this.getValue(key);
        try {
            return Long.parseLong(val);
        }
        catch (NumberFormatException exc) {
            throw new AgentRemoteException("Value is not a long, '" + val + "'");
        }
    }

    public double getValueAsDouble(String key) throws AgentRemoteException {
        String val = this.getValue(key);
        try {
            return Double.parseDouble(val);
        }
        catch (NumberFormatException exc) {
            throw new AgentRemoteException("Value is not a double, '" + val + "'");
        }
    }

    public int getValueAsInt(String key) throws AgentRemoteException {
        String val = this.getValue(key);
        try {
            return Integer.parseInt(val);
        }
        catch (NumberFormatException exc) {
            throw new AgentRemoteException("Value is not an integer, '" + val + "'");
        }
    }

    public void toStream(DataOutput os) throws IOException {
        for (Map.Entry<String, String> entry : this.vals.entrySet()) {
            String key = entry.getKey();
            String val = entry.getValue();
            if (val.length() > 65535) {
                this.writeChunkedValues(key, val, os);
                continue;
            }
            os.writeUTF(key);
            os.writeUTF(val);
        }
        os.writeUTF(new String(""));
    }

    private void writeChunkedValues(String key, String val, DataOutput os) throws IOException {
        int num = 0;
        while (num * 65535 < val.length()) {
            int start = num * 65535;
            int end = start + 65535 > val.length() ? val.length() : start + 65535;
            String chunk = val.substring(start, end);
            os.writeUTF("-chunk." + key + "." + num);
            os.writeUTF(chunk);
            ++num;
        }
    }

    public Set getKeys() {
        return this.vals.keySet();
    }

    public static AgentRemoteValue fromStream(DataInput is) throws IOException {
        LinkedHashMap<String, String> chunkedValues = new LinkedHashMap<String, String>();
        AgentRemoteValue res = new AgentRemoteValue();
        String key = is.readUTF();
        while (key.length() != 0) {
            String val = is.readUTF();
            if (Pattern.matches("^-chunk[.].*[.](\\d)", key)) {
                chunkedValues.put(key, val);
            } else {
                res.setValue(key, val);
            }
            key = is.readUTF();
        }
        for (Map.Entry<String, String> entry : AgentRemoteValue.getUnchunkedValues(chunkedValues).entrySet()) {
            res.setValue(entry.getKey(), entry.getValue());
        }
        return res;
    }

    private static Map<String, String> getUnchunkedValues(Map<String, String> chunkedValues) {
        LinkedHashMap<String, String> unchunked = new LinkedHashMap<String, String>();
        for (Map.Entry<String, String> chunkedEntry : chunkedValues.entrySet()) {
            String chunkParamKey = chunkedEntry.getKey().substring(CHUNK_PREFIX.length() + 1);
            String paramKey = chunkParamKey.substring(0, chunkParamKey.indexOf("."));
            if (unchunked.containsKey(paramKey)) {
                unchunked.put(paramKey, ((String)unchunked.get(paramKey)).concat(chunkedEntry.getValue()));
                continue;
            }
            unchunked.put(paramKey, chunkedEntry.getValue());
        }
        return unchunked;
    }

    public String toString() {
        return this.vals.toString();
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        AgentRemoteValue res = AgentRemoteValue.fromStream(in);
        this.vals = res.vals;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        this.toStream(out);
    }
}

