/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.hq.plugin.rabbitmq.collect;

import java.util.Properties;
import org.apache.commons.logging.Log;
import org.hyperic.hq.plugin.rabbitmq.core.HypericRabbitAdmin;
import org.hyperic.hq.product.Collector;
import org.hyperic.hq.product.PluginException;

public abstract class RabbitMQDefaultCollector
extends Collector {
    private HypericRabbitAdmin admin;

    protected final void init() throws PluginException {
        super.init();
        Properties props = this.getProperties();
        if (this.getLog().isDebugEnabled()) {
            this.getLog().debug((Object)("[init] props=" + props));
        }
        this.admin = new HypericRabbitAdmin(props);
        this.admin.getOverview();
    }

    protected void setValue(String key, Number val) {
        val = val != null ? (Number)val : (Number)new Double(Double.NaN);
        super.setValue(key, val.doubleValue());
    }

    public final void collect() {
        try {
            if (this.admin == null) {
                this.admin = new HypericRabbitAdmin(this.getProperties());
            }
            if (this.admin != null) {
                this.collect(this.admin);
            }
        }
        catch (Throwable ex) {
            this.setAvailability(false);
            this.getLog().debug((Object)ex.getMessage(), ex);
            this.admin = null;
        }
        boolean https = "true".equals(this.getProperties().getProperty("https"));
        if (https) {
            this.admin = null;
        }
    }

    public abstract void collect(HypericRabbitAdmin var1);

    public abstract Log getLog();
}

