/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.hq.plugin.wsmq.cmd;

import com.ibm.mq.MQException;
import com.ibm.mq.pcf.PCFMessage;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import org.hyperic.hq.plugin.wsmq.cmd.InquirePutGetDefault;
import org.hyperic.hq.product.MetricUnreachableException;

public class InquireTopic
extends InquirePutGetDefault {
    private static final int[] ATTRS = new int[]{181, 182, 215, 204};
    private static final List ATTR_NAMES = Arrays.asList("InhibitPublications", "InhibitSubscriptions", "PublishCount", "SubscriptionCount");

    public int[] getAttributes() {
        return ATTRS;
    }

    public List getAttributesName() {
        return ATTR_NAMES;
    }

    public PCFMessage getRequest(Properties properties) {
        String topic = properties.getProperty("Topic");
        this.getLog().debug((Object)("TOPIC = '" + topic + "'"));
        PCFMessage msg = new PCFMessage(183);
        msg.addParameter(2094, topic);
        return msg;
    }

    public double processValue(String metricName, PCFMessage responses) {
        double res;
        int attr = this.getAttributes()[this.getAttributesName().indexOf(metricName)];
        int value = (Integer)responses.getParameterValue(attr);
        switch (attr) {
            case 181: {
                double d = res = value == 2 ? 1.0 : 0.0;
                assert (res == 1.0);
                break;
            }
            case 182: {
                double d = res = value == 2 ? 1.0 : 0.0;
                assert (res == 1.0);
                break;
            }
            default: {
                res = value;
            }
        }
        return (int)res;
    }

    public final int getPutProp() {
        return 181;
    }

    public final int getGetProp() {
        return 182;
    }

    public double processPCFExceptionForAvail(MQException ex) throws MetricUnreachableException {
        if (ex.reasonCode == 3308) {
            this.getLog().debug((Object)"MQRCCF_TOPIC_STRING_NOT_FOUND");
            return 0.0;
        }
        assert (false) : ex;
        throw new MetricUnreachableException("ERROR", (Throwable)ex);
    }
}

