/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.hq.product.pluginxml;

import java.util.List;
import org.hyperic.hq.product.pluginxml.BaseTag;
import org.hyperic.hq.product.pluginxml.ContainerTag;
import org.hyperic.hq.product.pluginxml.ServerTag;
import org.hyperic.util.xmlparser.XmlTagException;

class ScanTag
extends ContainerTag {
    private static final String ATTR_REGISTRY = "registry";
    private static final int TYPE_FILE = 1;
    private static final int TYPE_REGISTRY = 2;
    private static final String[] OPTIONAL_ATTRS = new String[]{"include", "type", "registry"};
    private ServerTag server;

    ScanTag(BaseTag parent) {
        super(parent);
        this.server = (ServerTag)parent;
    }

    public String getName() {
        return "scan";
    }

    public String[] getOptionalAttributes() {
        return OPTIONAL_ATTRS;
    }

    private void override(List sigs) {
        if (sigs == null) {
            return;
        }
        if (this.server.isIncluded) {
            sigs.clear();
        }
    }

    void endTag() throws XmlTagException {
        List sigs;
        int type;
        String scanType = this.getAttribute("type", "file");
        String include = this.getAttribute("include");
        String registry = this.getAttribute(ATTR_REGISTRY);
        String name = this.server.typeName;
        if (registry != null) {
            scanType = ATTR_REGISTRY;
        }
        if (scanType.equals("file")) {
            type = 1;
            this.override(this.data.getFileScanIncludes(name));
        } else if (scanType.equals(ATTR_REGISTRY)) {
            type = 2;
            this.override(this.data.getRegistryScanKeys(name));
            this.override(this.data.getRegistryScanIncludes(name));
            if (registry != null) {
                this.data.addRegistryScanKey(name, registry);
            }
        } else {
            throw new XmlTagException("Unsupported scan type: " + scanType);
        }
        if (include != null && (sigs = type == 1 ? this.data.getFileScanIncludes(include) : this.data.getRegistryScanIncludes(include)) != null) {
            this.includes.addAll(sigs);
        }
        if (this.includes.size() > 0) {
            if (type == 1) {
                this.data.addFileScanIncludes(name, this.includes);
            } else {
                this.data.addRegistryScanIncludes(name, this.includes);
            }
        }
        super.endTag();
    }
}

