/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.hq.product;

import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import org.hyperic.hq.product.ControlPlugin;
import org.hyperic.hq.product.PluginException;
import org.hyperic.util.config.ConfigResponse;
import org.hyperic.util.jdbc.DBUtil;

public abstract class JDBCControlPlugin
extends ControlPlugin {
    protected String url;
    protected String user;
    protected String password;
    protected String table = null;
    protected String index = null;

    public void configure(ConfigResponse config) throws PluginException {
        super.configure(config);
        this.url = config.getValue("jdbcUrl");
        this.user = config.getValue("jdbcUser");
        this.password = config.getValue("jdbcPassword");
        this.table = config.getValue("table");
        this.index = config.getValue("index");
        Connection conn = null;
        try {
            this.getDriver();
            conn = this.getConnection(this.url, this.user, this.password);
        }
        catch (ClassNotFoundException e) {
            throw new PluginException("Unable to load JDBC Driver: " + e.getMessage());
        }
        catch (SQLException e) {
            throw new PluginException("Unable to obtain JDBC Connection: " + e.getMessage());
        }
        finally {
            if (conn != null) {
                try {
                    conn.close();
                }
                catch (Exception e) {
                    this.getLog().warn((Object)("Error closing connection: " + e.getMessage()));
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isRunning() {
        Connection conn = null;
        try {
            conn = this.getConnection(this.url, this.user, this.password);
            boolean bl = true;
            return bl;
        }
        catch (SQLException e) {
            boolean bl = false;
            return bl;
        }
        finally {
            if (conn != null) {
                try {
                    conn.close();
                }
                catch (Exception e) {
                    this.getLog().warn((Object)("Error closing connection: " + e.getMessage()));
                }
            }
        }
    }

    protected abstract Class getDriver() throws ClassNotFoundException;

    public void doAction(String action, String[] args) throws PluginException {
        super.doAction(action, args);
    }

    protected abstract Connection getConnection(String var1, String var2, String var3) throws SQLException;

    public abstract void doAction(String var1) throws PluginException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(String query) throws PluginException {
        Connection conn = null;
        Statement stmt = null;
        this.setResult(-1);
        try {
            conn = this.getConnection(this.url, this.user, this.password);
            stmt = conn.createStatement();
            stmt.execute(query);
            this.setResult(0);
        }
        catch (SQLException e) {
            try {
                this.setMessage(e.getMessage());
            }
            catch (Throwable throwable) {
                DBUtil.closeJDBCObjects((Object)this.getLog(), conn, stmt, null);
                throw throwable;
            }
            DBUtil.closeJDBCObjects((Object)this.getLog(), (Connection)conn, (Statement)stmt, null);
        }
        DBUtil.closeJDBCObjects((Object)this.getLog(), (Connection)conn, (Statement)stmt, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void executeQuery(String query) throws PluginException {
        Connection conn = null;
        Statement stmt = null;
        this.setResult(-1);
        try {
            conn = this.getConnection(this.url, this.user, this.password);
            stmt = conn.createStatement();
            stmt.executeQuery(query);
            conn.commit();
            this.setResult(0);
        }
        catch (SQLException e) {
            try {
                this.setMessage(e.getMessage());
            }
            catch (Throwable throwable) {
                DBUtil.closeJDBCObjects((Object)this.getLog(), conn, stmt, null);
                throw throwable;
            }
            DBUtil.closeJDBCObjects((Object)this.getLog(), (Connection)conn, (Statement)stmt, null);
        }
        DBUtil.closeJDBCObjects((Object)this.getLog(), (Connection)conn, (Statement)stmt, null);
    }
}

