/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.hq.product;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Properties;
import org.hyperic.hq.bizapp.shared.lather.ControlSendCommandResult_args;
import org.hyperic.hq.product.ControlPlugin;
import org.hyperic.hq.product.PluginException;
import org.hyperic.hq.product.PluginExistsException;
import org.hyperic.hq.product.PluginManager;
import org.hyperic.hq.product.PluginNotFoundException;
import org.hyperic.util.PluginLoader;
import org.hyperic.util.config.ConfigResponse;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ControlPluginManager
extends PluginManager {
    private static final boolean _validateAction = !"false".equals(System.getProperty("control.action.validate"));
    private HashMap pluginQueue = new HashMap();
    public static final String[] BUILTIN_CMDS = new String[0];

    public ControlPluginManager() {
    }

    public ControlPluginManager(Properties props) {
        super(props);
    }

    @Override
    public String getName() {
        return "control";
    }

    public void createControlPlugin(String name, String type, ConfigResponse config) throws PluginNotFoundException, PluginExistsException, PluginException {
        this.createPlugin(name, type, config);
    }

    public void updateControlPlugin(String name, ConfigResponse config) throws PluginNotFoundException, PluginException {
        ControlPlugin plugin = (ControlPlugin)this.getPlugin(name);
        this.updatePlugin(plugin, config);
    }

    public List<String> getActions(String name) throws PluginNotFoundException {
        ControlPlugin plugin = (ControlPlugin)this.getPlugin(name);
        ArrayList<String> actions = new ArrayList<String>(plugin.getActions());
        for (int i = 0; i < BUILTIN_CMDS.length; ++i) {
            actions.add(BUILTIN_CMDS[i]);
        }
        return actions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addJob(String name, String jobId) {
        HashMap hashMap = this.pluginQueue;
        synchronized (hashMap) {
            LinkedList<String> list = (LinkedList<String>)this.pluginQueue.get(name);
            if (list == null) {
                list = new LinkedList<String>();
                this.pluginQueue.put(name, list);
            }
            list.addLast(jobId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getNextJob(String name) throws NoSuchElementException {
        LinkedList list;
        HashMap hashMap = this.pluginQueue;
        synchronized (hashMap) {
            list = (LinkedList)this.pluginQueue.get(name);
        }
        if (list == null) {
            throw new NoSuchElementException();
        }
        return (String)list.getFirst();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeNextJob(String name) throws NoSuchElementException {
        HashMap hashMap = this.pluginQueue;
        synchronized (hashMap) {
            LinkedList list = (LinkedList)this.pluginQueue.get(name);
            if (list == null) {
                throw new NoSuchElementException();
            }
            list.removeFirst();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doAction(String name, String action, String[] args, ControlSendCommandResult_args resultsMetadata) throws PluginNotFoundException, PluginException {
        List<String> methods = this.getActions(name);
        if (_validateAction && !methods.contains(action)) {
            throw new PluginException("Action '" + action + "' not supported");
        }
        ControlPlugin plugin = (ControlPlugin)this.getPlugin(name);
        plugin.setResult(-1);
        plugin.setMessage(null);
        PluginLoader.setClassLoader((Object)plugin);
        try {
            if (args.length > 0) {
                plugin.doAction(action, args, resultsMetadata);
            } else {
                plugin.doAction(action, resultsMetadata);
            }
        }
        finally {
            PluginLoader.resetClassLoader((Object)plugin);
        }
    }

    public int getResult(String name) throws PluginNotFoundException {
        ControlPlugin plugin = (ControlPlugin)this.getPlugin(name);
        return plugin.getResult();
    }

    public String getMessage(String name) throws PluginNotFoundException {
        ControlPlugin plugin = (ControlPlugin)this.getPlugin(name);
        return plugin.getMessage();
    }

    public void removeControlPlugin(String name) throws PluginException, PluginNotFoundException {
        this.removePlugin(name);
    }
}

