/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.hq.product;

import java.io.File;
import java.util.Properties;
import org.hyperic.cm.filemonitor.FileMonitor;
import org.hyperic.cm.filemonitor.IFileMonitor;
import org.hyperic.cm.filemonitor.MonitorStatus;
import org.hyperic.hq.agent.AgentConfig;
import org.hyperic.hq.context.Bootstrap;
import org.hyperic.hq.product.PluginException;
import org.hyperic.hq.product.TrackEventPluginManager;
import org.springframework.stereotype.Component;

@Component
public class ConfigTrackPluginManager
extends TrackEventPluginManager {
    private static IFileMonitor fileMonitor = null;

    public ConfigTrackPluginManager() {
        this.initMonitor();
    }

    public ConfigTrackPluginManager(Properties props) {
        super(props);
        this.initMonitor();
    }

    private void initMonitor() {
        if (Bootstrap.isServer()) {
            this.log.info((Object)"Running on Server - FileMonitor not initiated");
            return;
        }
        String dataDir = this.getProperty(AgentConfig.PROP_DATADIR[0], AgentConfig.PROP_DATADIR[1]);
        File f = new File(dataDir);
        if (fileMonitor == null) {
            this.log.info((Object)"Running on Agent - initiating FileMonitor");
            fileMonitor = FileMonitor.getInstance();
        }
        fileMonitor.setAppDataDir(f.getAbsolutePath());
        String maxDiffSize = this.getProperty("hq.plugins.configmon.maxdiff");
        long size = -1L;
        if (maxDiffSize != null && maxDiffSize.length() > 0) {
            try {
                size = Long.valueOf(maxDiffSize);
            }
            catch (NumberFormatException e) {
                this.log.error((Object)e.getMessage(), (Throwable)e);
            }
        }
        if (size >= 0L) {
            fileMonitor.setMaxDiffSize(Long.valueOf(size));
        }
        if (!MonitorStatus.STARTED.equals((Object)fileMonitor.getStatus())) {
            fileMonitor.start();
        }
    }

    public String getName() {
        return "config_track";
    }

    public IFileMonitor getFileMonitor() {
        return fileMonitor;
    }

    public void shutdown() throws PluginException {
        if (fileMonitor != null) {
            fileMonitor.stop();
            fileMonitor = null;
        }
        super.shutdown();
    }
}

