/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.hq.autoinventory.scanimpl;

import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hyperic.hq.appdef.shared.AIServerValue;
import org.hyperic.hq.autoinventory.scanimpl.ScanMethodBase;
import org.hyperic.hq.product.AutoServerDetector;
import org.hyperic.hq.product.ServerDetector;
import org.hyperic.hq.product.ServerResource;
import org.hyperic.util.PluginLoader;
import org.hyperic.util.config.ConfigOption;
import org.hyperic.util.config.ConfigResponse;

public class NullScan
extends ScanMethodBase {
    private static final Log log = LogFactory.getLog(NullScan.class);
    private static final ConfigOption[] OPTS = new ConfigOption[0];

    public NullScan() {
        this._authorityLevel = 10;
    }

    public String getName() {
        return "NullScan";
    }

    public String getDisplayName() {
        return "Null Scan";
    }

    public String getDescription() {
        return "Scan with prepopulated data";
    }

    protected ConfigOption[] getOptionsArray() {
        return OPTS;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void scan(ConfigResponse platformConfig, ServerDetector[] serverDetectors) {
        for (ServerDetector detector : serverDetectors) {
            if (!(detector instanceof AutoServerDetector)) continue;
            if (log.isDebugEnabled()) {
                log.debug((Object)("Running AutoServerDetector for: " + detector.getTypeInfo().getName()));
            }
            PluginLoader.setClassLoader((Object)detector);
            try {
                List servers = ((AutoServerDetector)((Object)detector)).getServerResources(platformConfig);
                if (servers == null) continue;
                for (Object server : servers) {
                    AIServerValue xsrv = server instanceof AIServerValue ? (AIServerValue)server : (AIServerValue)((ServerResource)server).getResource();
                    if (this._autoApproveConfig == null || !this._autoApproveConfig.isAutoApproved(xsrv.getServerTypeName())) continue;
                    xsrv.setAutoApprove(true);
                }
                this._state.addServers(this, servers);
                this._state.setAreServersIncluded(true);
            }
            catch (Throwable e) {
                log.error((Object)("AutoScan failed for " + detector.getTypeInfo().getName()), e);
            }
            finally {
                PluginLoader.resetClassLoader((Object)detector);
            }
        }
    }
}

