/*
 * Decompiled with CFR 0.152.
 */
package com.hyperic.hq.plugin.insight.config;

import com.hyperic.hq.plugin.insight.config.AbstractDocumentCreator;
import com.hyperic.hq.plugin.insight.config.ServerXmlParser;
import com.hyperic.hq.plugin.insight.config.XmlPropertiesFileRetriever;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import org.hyperic.hq.product.PluginException;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServerXmlPropertiesRetriever
extends AbstractDocumentCreator
implements XmlPropertiesFileRetriever {
    @Override
    public Map<String, String> getPropertiesFromFile(String filePath, String nodeName, String nodeAttributeName, String nodeAttributeValue) throws PluginException {
        Element serverElement;
        ServerXmlParser serverParser = new ServerXmlParser();
        try {
            serverElement = serverParser.parse(this.createDocument(filePath));
        }
        catch (ParserConfigurationException e) {
            throw new PluginException("Parser exception: " + e.getMessage(), (Throwable)e);
        }
        catch (SAXException e) {
            throw new PluginException("Error parsing file: " + e.getMessage(), (Throwable)e);
        }
        catch (IOException e) {
            throw new PluginException("File error: " + e.getMessage(), (Throwable)e);
        }
        return this.getPropertiesFromServerElementByAttribute(serverElement, nodeName, nodeAttributeName, nodeAttributeValue);
    }

    private Map<String, String> getPropertiesFromServerElementByAttribute(Element serverElement, String nodeName, String nodeAttributeName, String nodeAttributeValue) {
        LinkedHashMap<String, String> listenerProperties = new LinkedHashMap<String, String>();
        listenerProperties.putAll(this.getPropertiesFromElementByAttribute(serverElement, nodeName, nodeAttributeName, nodeAttributeValue));
        if (listenerProperties.isEmpty()) {
            NodeList children = serverElement.getChildNodes();
            for (int i = 0; i < children.getLength(); ++i) {
                Element serviceElement;
                if (!children.item(i).getNodeName().equals("Service") || !(serviceElement = (Element)children.item(i)).getAttribute("name").equals("Catalina")) continue;
                listenerProperties.putAll(this.getPropertiesFromElementByAttribute(serviceElement, nodeName, nodeAttributeName, nodeAttributeValue));
                break;
            }
        }
        return listenerProperties;
    }

    private Map<String, String> getPropertiesFromElementByAttribute(Element rootElement, String nodeName, String nodeAttributeName, String nodeAttributeValue) {
        LinkedHashMap<String, String> listenerProperties = new LinkedHashMap<String, String>();
        NodeList children = rootElement.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Element listenerElement;
            if (!nodeName.equals(children.item(i).getNodeName()) || !(listenerElement = (Element)children.item(i)).getAttribute(nodeAttributeName).equals(nodeAttributeValue)) continue;
            NamedNodeMap nodeMap = listenerElement.getAttributes();
            for (int j = 0; j < nodeMap.getLength(); ++j) {
                listenerProperties.put(nodeMap.item(j).getNodeName(), nodeMap.item(j).getNodeValue());
            }
            break;
        }
        return listenerProperties;
    }
}

