/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.util.jdbc;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import org.hyperic.util.jdbc.DBUtil;
import org.hyperic.util.jdbc.JDBC;

public class OracleSequenceSync {
    private String jdbcUrl;
    private String user;
    private String password;
    private Connection conn;
    private boolean testMode = false;
    private static final String ctx = OracleSequenceSync.class.getName();
    private static final String GET_SEQUENCES = "SELECT SEQUENCE_NAME FROM ALL_SEQUENCES WHERE SEQUENCE_OWNER = ?";

    public static void main(String[] args) {
        boolean isTest = false;
        if (args.length < 3) {
            System.out.println("Usage: OracleSequenceSync jdbcUrl user pass");
            System.exit(-1);
        }
        if (args.length > 3) {
            isTest = new Boolean(args[3]);
        }
        try {
            OracleSequenceSync oss = new OracleSequenceSync(args[0], args[1], args[2], isTest);
            oss.reinitSequences();
        }
        catch (Exception e) {
            System.err.println("An error occured: " + e.getMessage());
        }
    }

    public OracleSequenceSync(String jdbcUrl, String user, String password, boolean testMode) throws SQLException {
        if (jdbcUrl.indexOf("oracle") == -1) {
            System.out.println("This tool can only be used against Oracle JDBC sources");
            System.exit(-1);
        }
        this.jdbcUrl = jdbcUrl;
        this.user = user.toUpperCase();
        this.password = password;
        this.testMode = testMode;
        try {
            JDBC.loadDriver("oracle");
        }
        catch (ClassNotFoundException e) {
            System.out.println("Unable to load Oracle Driver: " + e.getMessage());
            System.out.println("Please check your classpath");
            System.exit(-1);
        }
        System.out.println("Succesfully connected to: " + jdbcUrl);
    }

    public void reinitSequences() throws SQLException {
        try {
            this.conn = DriverManager.getConnection(this.jdbcUrl, this.user, this.password);
            Map allSequences = this.getSequenceList();
            this.dropAndRecreate(allSequences);
        }
        catch (SQLException e) {
            JDBC.printSQLException(e);
            throw e;
        }
        finally {
            DBUtil.closeConnection(ctx, this.conn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dropAndRecreate(Map seqMap) throws SQLException {
        PreparedStatement stmt = null;
        try {
            for (Map.Entry entry : seqMap.entrySet()) {
                String seqName = (String)entry.getKey();
                String tableName = (String)((Map)entry.getValue()).keySet().iterator().next();
                String keyName = (String)((Map)entry.getValue()).values().iterator().next();
                System.out.println("Processing Sequence: " + seqName);
                int highestCurrKey = this.getHighestCurrKey(tableName, keyName);
                System.out.println("Current highest value of: " + keyName + " for table: " + tableName + " is: " + highestCurrKey);
                int startingVal = highestCurrKey + 1000;
                if (!this.testMode) {
                    stmt = this.conn.prepareStatement("DROP SEQUENCE " + seqName);
                    stmt.execute();
                    stmt = this.conn.prepareStatement("CREATE SEQUENCE " + seqName + " start with " + startingVal + " increment by 1 nocache nocycle");
                    stmt.execute();
                    continue;
                }
                System.out.println("TestMode specified... skipping");
            }
        }
        finally {
            DBUtil.closeJDBCObjects(ctx, null, stmt, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getHighestCurrKey(String table, String keyName) throws SQLException {
        int n;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            stmt = this.conn.prepareStatement("SELECT MAX(" + keyName + ") FROM " + table);
            rs = stmt.executeQuery();
            rs.next();
            n = rs.getInt(1);
        }
        catch (Throwable throwable) {
            DBUtil.closeJDBCObjects(ctx, null, stmt, rs);
            throw throwable;
        }
        DBUtil.closeJDBCObjects(ctx, null, stmt, rs);
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map getSequenceList() throws SQLException {
        HashMap<String, Map> hashMap;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            HashMap<String, Map> seqMap = new HashMap<String, Map>();
            stmt = this.conn.prepareStatement(GET_SEQUENCES);
            stmt.setString(1, this.user);
            rs = stmt.executeQuery();
            while (rs.next()) {
                String aSequence = rs.getString(1);
                seqMap.put(aSequence, this.getTableAndKeyFromSequence(aSequence));
            }
            hashMap = seqMap;
        }
        catch (Throwable throwable) {
            DBUtil.closeJDBCObjects(ctx, null, stmt, rs);
            throw throwable;
        }
        DBUtil.closeJDBCObjects(ctx, null, stmt, rs);
        return hashMap;
    }

    private Map getTableAndKeyFromSequence(String sequenceName) {
        HashMap<String, String> aMap = new HashMap<String, String>();
        int idx = sequenceName.lastIndexOf("_");
        String tableAndKey = sequenceName.substring(0, idx);
        idx = tableAndKey.lastIndexOf("_");
        String table = tableAndKey.substring(0, idx);
        String key = tableAndKey.substring(idx + 1);
        aMap.put(table, key);
        return aMap;
    }
}

