/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.util.file;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hyperic.util.file.CreateOnlyWriter;
import org.hyperic.util.file.CreateOrOverwriteWriter;
import org.hyperic.util.file.RewriteWriter;
import org.hyperic.util.file.WriterHandler;
import org.hyperic.util.security.MD5;

public class FileWriter
extends WriterHandler {
    private static final int MODE_CREATEONLY = 1;
    private static final int MODE_CREATEOROVERWRITE = 2;
    private static final int MODE_REWRITE = 3;
    private final Log log = LogFactory.getLog(FileWriter.class);
    private File destFile;
    private InputStream inStream;
    private WriterHandler writer;
    private int mode;
    private long length;
    private String expectedMD5Sum;

    public FileWriter(File destFile, InputStream inStream, long size) {
        this.destFile = destFile;
        this.inStream = inStream;
        this.length = size;
        this.writer = null;
        this.mode = 2;
    }

    public FileWriter(File destFile, byte[] data) {
        this(destFile, new ByteArrayInputStream(data), data.length);
    }

    public void setVerifyMD5CheckSumOnWrite(String expectedMD5sum) {
        this.expectedMD5Sum = expectedMD5sum;
    }

    public File getDestFile() {
        return this.destFile;
    }

    public void setCreateOnly() {
        this.mode = 1;
    }

    public boolean isCreateOnly() {
        return this.mode == 1;
    }

    public void setCreateOrOverwrite() {
        this.mode = 2;
    }

    public boolean isCreateOrOverwrite() {
        return this.mode == 2;
    }

    public void setRewrite() {
        this.mode = 3;
    }

    public boolean isRewrite() {
        return this.mode == 3;
    }

    public void rollback() throws IOException {
        super.rollback();
        this.writer.rollback();
    }

    public void cleanup() {
        super.cleanup();
        this.writer.cleanup();
    }

    public void write() throws IOException {
        super.write();
        if (this.isCreateOrOverwrite()) {
            this.writer = new CreateOrOverwriteWriter(this.destFile, this.inStream, this.length);
        } else if (this.isCreateOnly()) {
            this.writer = new CreateOnlyWriter(this.destFile, this.inStream, this.length);
        } else if (this.isRewrite()) {
            this.writer = new RewriteWriter(this.destFile, this.inStream, this.length);
        } else {
            throw new IllegalStateException("Unhandled write mode");
        }
        this.writer.write();
    }

    public void verifyMD5CheckSum() throws IOException {
        if (this.writer == null || !this.writer.hasWritten()) {
            throw new IllegalStateException("the file must be written before verifying the MD5 check sum");
        }
        if (this.expectedMD5Sum != null) {
            String actualMD5Sum = MD5.getMD5Checksum(this.getDestFile());
            this.log.debug((Object)("Verifying MD5 check sum for file " + this.getDestFile() + "; expected=" + this.expectedMD5Sum + ", actual=" + actualMD5Sum));
            if (!this.expectedMD5Sum.equals(actualMD5Sum)) {
                throw new IOException("MD5 check sum failed for file " + this.getDestFile() + "; expected=" + this.expectedMD5Sum + ", actual=" + actualMD5Sum);
            }
        }
    }
}

