/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.util.file;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DirWatcher
implements Runnable {
    private final Log _log = LogFactory.getLog(DirWatcher.class);
    private final File _dir;
    private final DirWatcherCallback _cback;
    private final List _lastList;

    public DirWatcher(File dir, DirWatcherCallback callback, List lastList) {
        this._dir = dir;
        this._cback = callback;
        this._lastList = new ArrayList();
        this._lastList.addAll(lastList);
    }

    public DirWatcher(File dir, DirWatcherCallback callback) {
        this(dir, callback, new ArrayList());
    }

    public void run() {
        this._log.info((Object)("Watching: " + this._dir));
        while (true) {
            try {
                List<File> curList = Arrays.asList(this._dir.listFiles());
                for (File f : curList) {
                    if (this._lastList.contains(f)) continue;
                    this._cback.fileAdded(f);
                }
                for (File f : this._lastList) {
                    if (curList.contains(f)) continue;
                    this._cback.fileRemoved(f);
                }
                this._lastList.clear();
                this._lastList.addAll(curList);
            }
            catch (Throwable e) {
                this._log.warn((Object)"Error while processing directory listing", e);
            }
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                this._log.info((Object)"Dying");
                return;
            }
        }
    }

    public static interface DirWatcherCallback {
        public void fileAdded(File var1);

        public void fileRemoved(File var1);
    }
}

