/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.util.config;

import java.io.EOFException;
import java.io.IOException;
import java.util.List;
import java.util.Set;
import org.hyperic.util.config.ConfigOption;
import org.hyperic.util.config.ConfigOptionDisplay;
import org.hyperic.util.config.ConfigResponse;
import org.hyperic.util.config.ConfigSchema;
import org.hyperic.util.config.EarlyExitException;
import org.hyperic.util.config.EncodingException;
import org.hyperic.util.config.EnumerationConfigOption;
import org.hyperic.util.config.InstallConfigOption;
import org.hyperic.util.config.InteractiveResponseBuilder_IOHandler;
import org.hyperic.util.config.InvalidOptionException;
import org.hyperic.util.config.InvalidOptionValueException;
import org.hyperic.util.config.ResponseBuilder;
import org.hyperic.util.config.StringConfigOption;
import org.hyperic.util.config.YesNoConfigOption;

public class InteractiveResponseBuilder
implements ResponseBuilder {
    private final InteractiveResponseBuilder_IOHandler inout;

    public InteractiveResponseBuilder(InteractiveResponseBuilder_IOHandler io) {
        this.inout = io;
    }

    public String handleInput(String s) throws IOException, EOFException {
        return this.inout.handleInput(s);
    }

    public String handleHiddenInput(String s) throws IOException, EOFException {
        return this.inout.handleHiddenInput(s);
    }

    public ConfigResponse processConfigSchema(ConfigSchema schema) throws EncodingException, IOException, InvalidOptionException, EarlyExitException {
        return this.processConfigSchema(schema, new ConfigResponse());
    }

    public ConfigResponse processConfigSchema(ConfigSchema schema, ConfigResponse defaults) throws IOException, InvalidOptionException, EarlyExitException {
        List<ConfigOption> options = schema.getOptions();
        int nOptions = options.size();
        Set<String> defaultKeys = defaults.getKeys();
        ConfigResponse res = new ConfigResponse(schema);
        int i = 0;
        int counter = 100;
        while (i < nOptions) {
            String val;
            String inputStr;
            String def;
            ConfigOption opt = options.get(i);
            String string = def = defaultKeys.contains(opt.getName()) ? defaults.getValue(opt.getName()) : opt.getDefault();
            if (def != null) {
                try {
                    opt.checkOptionIsValid(def);
                }
                catch (InvalidOptionValueException exc) {
                    def = opt.getDefault();
                }
            }
            boolean isSecret = false;
            if (opt instanceof StringConfigOption) {
                if (((StringConfigOption)opt).isHidden()) {
                    try {
                        res.setValue(opt.getName(), opt.getDefault());
                    }
                    catch (InvalidOptionException exc) {
                        this.sendToErrStream("Error setting hidden value: " + exc);
                        throw new IllegalStateException("Error setting hidden  value, cannot continue: " + exc);
                    }
                    catch (InvalidOptionValueException exc) {
                        this.sendToErrStream("Error setting hidden value: " + exc);
                        throw new IllegalStateException("Error setting hidden  value, cannot continue: " + exc);
                    }
                    ++i;
                    continue;
                }
                isSecret = ((StringConfigOption)opt).isSecret();
            }
            if (isSecret) {
                inputStr = this.getInputString(opt, def == null ? null : "*hidden*");
                val = this.handleHiddenInput(inputStr + ": ");
            } else {
                inputStr = this.getInputString(opt, def);
                val = this.handleInput(inputStr + ": ");
            }
            if (val == null || "".equals(val)) {
                if (def == null) {
                    if (opt.isOptional()) {
                        ++i;
                    }
                    if (--counter > 0) continue;
                    throw new IOException("Prevented runaway input looping.");
                }
                val = def;
            } else {
                YesNoConfigOption confirmOpt;
                String confirm;
                List values;
                String verifyVal;
                if (isSecret && !(verifyVal = this.handleHiddenInput("(again): ")).equals(val)) {
                    this.sendToErrStream("Values do not match");
                    continue;
                }
                val = val.trim();
                if (opt instanceof EnumerationConfigOption) {
                    int index = -1;
                    try {
                        index = Integer.parseInt(val) - 1;
                    }
                    catch (NumberFormatException exc) {
                        this.sendToErrStream("Value must be an integer");
                        continue;
                    }
                    values = ((EnumerationConfigOption)opt).getValues();
                    if (index < 0 || index >= values.size()) {
                        this.sendToErrStream("Value not in range");
                        continue;
                    }
                    val = values.get(index).toString();
                } else if (opt instanceof InstallConfigOption) {
                    int index = -1;
                    try {
                        index = Integer.parseInt(val) - 1;
                    }
                    catch (NumberFormatException exc) {
                        this.sendToErrStream("Value must be an integer");
                        continue;
                    }
                    values = ((InstallConfigOption)opt).getValues();
                    if (index < 0 || index >= values.size()) {
                        this.sendToErrStream("Value not in range");
                        continue;
                    }
                    val = ((ConfigOptionDisplay)values.get(index)).getName();
                }
                if (val.equals(opt.getConfirm()) && !"1".equals(confirm = this.handleInput(this.getInputString(confirmOpt = new YesNoConfigOption("confirmation", "Are you sure (" + val + ")?", YesNoConfigOption.YES), confirmOpt.getDefault()) + ": "))) continue;
            }
            counter = 100;
            try {
                res.setValue(opt.getName(), val);
            }
            catch (EarlyExitException e) {
                throw e;
            }
            catch (InvalidOptionException exc) {
                this.sendToErrStream("Invalid option, '" + opt.getName() + "'");
                continue;
            }
            catch (InvalidOptionValueException exc) {
                this.sendToErrStream(exc.getMessage());
                continue;
            }
            ++i;
        }
        return res;
    }

    public void sendToErrStream(String msg) {
        this.inout.errOutput(msg);
    }

    private String getInputString(ConfigOption opt, String defaultValue) {
        StringBuilder result = new StringBuilder();
        if (this.inout.isDeveloper()) {
            result.append("(").append(opt.getName()).append(") ");
        }
        String desc = opt.getDescription();
        if (opt instanceof EnumerationConfigOption) {
            result.append("Choices:");
            List enumValues = ((EnumerationConfigOption)opt).getValues();
            int defaultIndex = -1;
            for (int i = 0; i < enumValues.size(); ++i) {
                String enumValue = enumValues.get(i).toString();
                result.append("\n\t").append(i + 1).append(": ").append(enumValue);
                if (!enumValue.equals(defaultValue)) continue;
                defaultIndex = i;
            }
            if (defaultIndex != -1) {
                result.append("\n").append(desc).append(" [default '").append(defaultIndex + 1).append("']");
            } else {
                result.append("\n").append(desc);
            }
        } else if (opt instanceof InstallConfigOption) {
            result.append("Choices:");
            List displayValues = ((InstallConfigOption)opt).getValues();
            int defaultIndex = -1;
            for (int x = 0; x < displayValues.size(); ++x) {
                String name = ((ConfigOptionDisplay)displayValues.get(x)).getName();
                String description = ((ConfigOptionDisplay)displayValues.get(x)).getDescription();
                String note = ((ConfigOptionDisplay)displayValues.get(x)).getNote();
                result.append("\n\t").append(x + 1).append(": ").append(name);
                if (name.equals(defaultValue)) {
                    defaultIndex = x;
                }
                if (description != null && description.length() > 0) {
                    result.append(description);
                }
                if (note == null || note.length() <= 0) continue;
                result.append(note);
            }
            if (defaultIndex != -1) {
                result.append("\n").append(desc).append(" [default '").append(defaultIndex + 1).append("']");
            } else {
                result.append("\n").append(desc);
            }
        } else {
            result.append(desc);
            if (defaultValue != null) {
                result.append(" [default '").append(defaultValue).append("']");
            }
        }
        return result.toString();
    }
}

