/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.hq.plugin.xen;

import com.xensource.xenapi.Connection;
import com.xensource.xenapi.Host;
import com.xensource.xenapi.HostCpu;
import com.xensource.xenapi.HostMetrics;
import org.hyperic.hq.plugin.xen.XenCollector;
import org.hyperic.hq.plugin.xen.XenUtil;
import org.hyperic.hq.product.PluginException;

public class XenHostCollector
extends XenCollector {
    public void collect() {
        try {
            Connection conn = this.connect();
            Host host = XenUtil.getHost(conn, this.getProperties());
            this.setAvailability(true);
            HostMetrics metrics = host.getMetrics(conn);
            HostMetrics.Record record = metrics.getRecord(conn);
            long free = record.memoryFree;
            long total = record.memoryTotal;
            long used = total - free;
            this.setValue("MemoryFree", free);
            this.setValue("MemoryTotal", total);
            this.setValue("MemoryUsed", used);
            double usage = 0.0;
            for (HostCpu cpu : host.getHostCPUs(conn)) {
                usage += cpu.getUtilisation(conn).doubleValue();
            }
            this.setValue("CPUUsage", usage);
        }
        catch (PluginException e) {
            this.setAvailability(false);
            this.setErrorMessage(e.getMessage());
        }
        catch (Exception e) {
            this.setErrorMessage(e.getMessage());
        }
    }
}

