/*
 * Decompiled with CFR 0.152.
 */
package com.xensource.xenapi;

import com.xensource.xenapi.Connection;
import com.xensource.xenapi.Marshalling;
import com.xensource.xenapi.Task;
import com.xensource.xenapi.Types;
import com.xensource.xenapi.VBDMetrics;
import com.xensource.xenapi.VDI;
import com.xensource.xenapi.VM;
import com.xensource.xenapi.XenAPIObject;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.ref.SoftReference;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.xmlrpc.XmlRpcException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VBD
extends XenAPIObject {
    protected final String ref;
    private static final Map<String, SoftReference<VBD>> cache = new HashMap<String, SoftReference<VBD>>();

    private VBD(String ref) {
        this.ref = ref;
    }

    @Override
    public String toWireString() {
        return this.ref;
    }

    protected static synchronized VBD getInstFromRef(String ref) {
        VBD instance;
        if (cache.containsKey(ref) && (instance = cache.get(ref).get()) != null) {
            return instance;
        }
        instance = new VBD(ref);
        cache.put(ref, new SoftReference<VBD>(instance));
        return instance;
    }

    public Record getRecord(Connection c) throws Types.BadServerResponse, XmlRpcException {
        String method_call = "VBD.get_record";
        String session = c.getSessionReference();
        Object[] method_params = new Object[]{Marshalling.toXMLRPC(session), Marshalling.toXMLRPC(this.ref)};
        Map response = c.dispatch(method_call, method_params);
        if (response.get("Status").equals("Success")) {
            Object result = response.get("Value");
            return Types.toVBDRecord(result);
        }
        throw new Types.BadServerResponse(response);
    }

    public static VBD getByUuid(Connection c, String uuid) throws Types.BadServerResponse, XmlRpcException {
        String method_call = "VBD.get_by_uuid";
        String session = c.getSessionReference();
        Object[] method_params = new Object[]{Marshalling.toXMLRPC(session), Marshalling.toXMLRPC(uuid)};
        Map response = c.dispatch(method_call, method_params);
        if (response.get("Status").equals("Success")) {
            Object result = response.get("Value");
            return Types.toVBD(result);
        }
        throw new Types.BadServerResponse(response);
    }

    public static Task createAsync(Connection c, Record record) throws Types.BadServerResponse, XmlRpcException {
        String method_call = "Async.VBD.create";
        String session = c.getSessionReference();
        Map<String, Object> record_map = record.toMap();
        Object[] method_params = new Object[]{Marshalling.toXMLRPC(session), Marshalling.toXMLRPC(record_map)};
        Map response = c.dispatch(method_call, method_params);
        if (response.get("Status").equals("Success")) {
            Object result = response.get("Value");
            return Types.toTask(result);
        }
        throw new Types.BadServerResponse(response);
    }

    public static VBD create(Connection c, Record record) throws Types.BadServerResponse, XmlRpcException {
        String method_call = "VBD.create";
        String session = c.getSessionReference();
        Map<String, Object> record_map = record.toMap();
        Object[] method_params = new Object[]{Marshalling.toXMLRPC(session), Marshalling.toXMLRPC(record_map)};
        Map response = c.dispatch(method_call, method_params);
        if (response.get("Status").equals("Success")) {
            Object result = response.get("Value");
            return Types.toVBD(result);
        }
        throw new Types.BadServerResponse(response);
    }

    public Task destroyAsync(Connection c) throws Types.BadServerResponse, XmlRpcException {
        String method_call = "Async.VBD.destroy";
        String session = c.getSessionReference();
        Object[] method_params = new Object[]{Marshalling.toXMLRPC(session), Marshalling.toXMLRPC(this.ref)};
        Map response = c.dispatch(method_call, method_params);
        if (response.get("Status").equals("Success")) {
            Object result = response.get("Value");
            return Types.toTask(result);
        }
        throw new Types.BadServerResponse(response);
    }

    public void destroy(Connection c) throws Types.BadServerResponse, XmlRpcException {
        String method_call = "VBD.destroy";
        String session = c.getSessionReference();
        Object[] method_params = new Object[]{Marshalling.toXMLRPC(session), Marshalling.toXMLRPC(this.ref)};
        Map response = c.dispatch(method_call, method_params);
        if (response.get("Status").equals("Success")) {
            Object result = response.get("Value");
            return;
        }
        throw new Types.BadServerResponse(response);
    }

    public String getUuid(Connection c) throws Types.BadServerResponse, XmlRpcException {
        String method_call = "VBD.get_uuid";
        String session = c.getSessionReference();
        Object[] method_params = new Object[]{Marshalling.toXMLRPC(session), Marshalling.toXMLRPC(this.ref)};
        Map response = c.dispatch(method_call, method_params);
        if (response.get("Status").equals("Success")) {
            Object result = response.get("Value");
            return Types.toString(result);
        }
        throw new Types.BadServerResponse(response);
    }

    public Set<Types.VbdOperations> getAllowedOperations(Connection c) throws Types.BadServerResponse, XmlRpcException {
        String method_call = "VBD.get_allowed_operations";
        String session = c.getSessionReference();
        Object[] method_params = new Object[]{Marshalling.toXMLRPC(session), Marshalling.toXMLRPC(this.ref)};
        Map response = c.dispatch(method_call, method_params);
        if (response.get("Status").equals("Success")) {
            Object result = response.get("Value");
            return Types.toSetOfVbdOperations(result);
        }
        throw new Types.BadServerResponse(response);
    }

    public Map<String, Types.VbdOperations> getCurrentOperations(Connection c) throws Types.BadServerResponse, XmlRpcException {
        String method_call = "VBD.get_current_operations";
        String session = c.getSessionReference();
        Object[] method_params = new Object[]{Marshalling.toXMLRPC(session), Marshalling.toXMLRPC(this.ref)};
        Map response = c.dispatch(method_call, method_params);
        if (response.get("Status").equals("Success")) {
            Object result = response.get("Value");
            return Types.toMapOfStringVbdOperations(result);
        }
        throw new Types.BadServerResponse(response);
    }

    public VM getVM(Connection c) throws Types.BadServerResponse, XmlRpcException {
        String method_call = "VBD.get_VM";
        String session = c.getSessionReference();
        Object[] method_params = new Object[]{Marshalling.toXMLRPC(session), Marshalling.toXMLRPC(this.ref)};
        Map response = c.dispatch(method_call, method_params);
        if (response.get("Status").equals("Success")) {
            Object result = response.get("Value");
            return Types.toVM(result);
        }
        throw new Types.BadServerResponse(response);
    }

    public VDI getVDI(Connection c) throws Types.BadServerResponse, XmlRpcException {
        String method_call = "VBD.get_VDI";
        String session = c.getSessionReference();
        Object[] method_params = new Object[]{Marshalling.toXMLRPC(session), Marshalling.toXMLRPC(this.ref)};
        Map response = c.dispatch(method_call, method_params);
        if (response.get("Status").equals("Success")) {
            Object result = response.get("Value");
            return Types.toVDI(result);
        }
        throw new Types.BadServerResponse(response);
    }

    public String getDevice(Connection c) throws Types.BadServerResponse, XmlRpcException {
        String method_call = "VBD.get_device";
        String session = c.getSessionReference();
        Object[] method_params = new Object[]{Marshalling.toXMLRPC(session), Marshalling.toXMLRPC(this.ref)};
        Map response = c.dispatch(method_call, method_params);
        if (response.get("Status").equals("Success")) {
            Object result = response.get("Value");
            return Types.toString(result);
        }
        throw new Types.BadServerResponse(response);
    }

    public String getUserdevice(Connection c) throws Types.BadServerResponse, XmlRpcException {
        String method_call = "VBD.get_userdevice";
        String session = c.getSessionReference();
        Object[] method_params = new Object[]{Marshalling.toXMLRPC(session), Marshalling.toXMLRPC(this.ref)};
        Map response = c.dispatch(method_call, method_params);
        if (response.get("Status").equals("Success")) {
            Object result = response.get("Value");
            return Types.toString(result);
        }
        throw new Types.BadServerResponse(response);
    }

    public Boolean getBootable(Connection c) throws Types.BadServerResponse, XmlRpcException {
        String method_call = "VBD.get_bootable";
        String session = c.getSessionReference();
        Object[] method_params = new Object[]{Marshalling.toXMLRPC(session), Marshalling.toXMLRPC(this.ref)};
        Map response = c.dispatch(method_call, method_params);
        if (response.get("Status").equals("Success")) {
            Object result = response.get("Value");
            return Types.toBoolean(result);
        }
        throw new Types.BadServerResponse(response);
    }

    public Types.VbdMode getMode(Connection c) throws Types.BadServerResponse, XmlRpcException {
        String method_call = "VBD.get_mode";
        String session = c.getSessionReference();
        Object[] method_params = new Object[]{Marshalling.toXMLRPC(session), Marshalling.toXMLRPC(this.ref)};
        Map response = c.dispatch(method_call, method_params);
        if (response.get("Status").equals("Success")) {
            Object result = response.get("Value");
            return Types.toVbdMode(result);
        }
        throw new Types.BadServerResponse(response);
    }

    public Types.VbdType getType(Connection c) throws Types.BadServerResponse, XmlRpcException {
        String method_call = "VBD.get_type";
        String session = c.getSessionReference();
        Object[] method_params = new Object[]{Marshalling.toXMLRPC(session), Marshalling.toXMLRPC(this.ref)};
        Map response = c.dispatch(method_call, method_params);
        if (response.get("Status").equals("Success")) {
            Object result = response.get("Value");
            return Types.toVbdType(result);
        }
        throw new Types.BadServerResponse(response);
    }

    public Boolean getUnpluggable(Connection c) throws Types.BadServerResponse, XmlRpcException {
        String method_call = "VBD.get_unpluggable";
        String session = c.getSessionReference();
        Object[] method_params = new Object[]{Marshalling.toXMLRPC(session), Marshalling.toXMLRPC(this.ref)};
        Map response = c.dispatch(method_call, method_params);
        if (response.get("Status").equals("Success")) {
            Object result = response.get("Value");
            return Types.toBoolean(result);
        }
        throw new Types.BadServerResponse(response);
    }

    public Boolean getStorageLock(Connection c) throws Types.BadServerResponse, XmlRpcException {
        String method_call = "VBD.get_storage_lock";
        String session = c.getSessionReference();
        Object[] method_params = new Object[]{Marshalling.toXMLRPC(session), Marshalling.toXMLRPC(this.ref)};
        Map response = c.dispatch(method_call, method_params);
        if (response.get("Status").equals("Success")) {
            Object result = response.get("Value");
            return Types.toBoolean(result);
        }
        throw new Types.BadServerResponse(response);
    }

    public Boolean getEmpty(Connection c) throws Types.BadServerResponse, XmlRpcException {
        String method_call = "VBD.get_empty";
        String session = c.getSessionReference();
        Object[] method_params = new Object[]{Marshalling.toXMLRPC(session), Marshalling.toXMLRPC(this.ref)};
        Map response = c.dispatch(method_call, method_params);
        if (response.get("Status").equals("Success")) {
            Object result = response.get("Value");
            return Types.toBoolean(result);
        }
        throw new Types.BadServerResponse(response);
    }

    public Map<String, String> getOtherConfig(Connection c) throws Types.BadServerResponse, XmlRpcException {
        String method_call = "VBD.get_other_config";
        String session = c.getSessionReference();
        Object[] method_params = new Object[]{Marshalling.toXMLRPC(session), Marshalling.toXMLRPC(this.ref)};
        Map response = c.dispatch(method_call, method_params);
        if (response.get("Status").equals("Success")) {
            Object result = response.get("Value");
            return Types.toMapOfStringString(result);
        }
        throw new Types.BadServerResponse(response);
    }

    public Boolean getCurrentlyAttached(Connection c) throws Types.BadServerResponse, XmlRpcException {
        String method_call = "VBD.get_currently_attached";
        String session = c.getSessionReference();
        Object[] method_params = new Object[]{Marshalling.toXMLRPC(session), Marshalling.toXMLRPC(this.ref)};
        Map response = c.dispatch(method_call, method_params);
        if (response.get("Status").equals("Success")) {
            Object result = response.get("Value");
            return Types.toBoolean(result);
        }
        throw new Types.BadServerResponse(response);
    }

    public Long getStatusCode(Connection c) throws Types.BadServerResponse, XmlRpcException {
        String method_call = "VBD.get_status_code";
        String session = c.getSessionReference();
        Object[] method_params = new Object[]{Marshalling.toXMLRPC(session), Marshalling.toXMLRPC(this.ref)};
        Map response = c.dispatch(method_call, method_params);
        if (response.get("Status").equals("Success")) {
            Object result = response.get("Value");
            return Types.toLong(result);
        }
        throw new Types.BadServerResponse(response);
    }

    public String getStatusDetail(Connection c) throws Types.BadServerResponse, XmlRpcException {
        String method_call = "VBD.get_status_detail";
        String session = c.getSessionReference();
        Object[] method_params = new Object[]{Marshalling.toXMLRPC(session), Marshalling.toXMLRPC(this.ref)};
        Map response = c.dispatch(method_call, method_params);
        if (response.get("Status").equals("Success")) {
            Object result = response.get("Value");
            return Types.toString(result);
        }
        throw new Types.BadServerResponse(response);
    }

    public Map<String, String> getRuntimeProperties(Connection c) throws Types.BadServerResponse, XmlRpcException {
        String method_call = "VBD.get_runtime_properties";
        String session = c.getSessionReference();
        Object[] method_params = new Object[]{Marshalling.toXMLRPC(session), Marshalling.toXMLRPC(this.ref)};
        Map response = c.dispatch(method_call, method_params);
        if (response.get("Status").equals("Success")) {
            Object result = response.get("Value");
            return Types.toMapOfStringString(result);
        }
        throw new Types.BadServerResponse(response);
    }

    public String getQosAlgorithmType(Connection c) throws Types.BadServerResponse, XmlRpcException {
        String method_call = "VBD.get_qos_algorithm_type";
        String session = c.getSessionReference();
        Object[] method_params = new Object[]{Marshalling.toXMLRPC(session), Marshalling.toXMLRPC(this.ref)};
        Map response = c.dispatch(method_call, method_params);
        if (response.get("Status").equals("Success")) {
            Object result = response.get("Value");
            return Types.toString(result);
        }
        throw new Types.BadServerResponse(response);
    }

    public Map<String, String> getQosAlgorithmParams(Connection c) throws Types.BadServerResponse, XmlRpcException {
        String method_call = "VBD.get_qos_algorithm_params";
        String session = c.getSessionReference();
        Object[] method_params = new Object[]{Marshalling.toXMLRPC(session), Marshalling.toXMLRPC(this.ref)};
        Map response = c.dispatch(method_call, method_params);
        if (response.get("Status").equals("Success")) {
            Object result = response.get("Value");
            return Types.toMapOfStringString(result);
        }
        throw new Types.BadServerResponse(response);
    }

    public Set<String> getQosSupportedAlgorithms(Connection c) throws Types.BadServerResponse, XmlRpcException {
        String method_call = "VBD.get_qos_supported_algorithms";
        String session = c.getSessionReference();
        Object[] method_params = new Object[]{Marshalling.toXMLRPC(session), Marshalling.toXMLRPC(this.ref)};
        Map response = c.dispatch(method_call, method_params);
        if (response.get("Status").equals("Success")) {
            Object result = response.get("Value");
            return Types.toSetOfString(result);
        }
        throw new Types.BadServerResponse(response);
    }

    public VBDMetrics getMetrics(Connection c) throws Types.BadServerResponse, XmlRpcException {
        String method_call = "VBD.get_metrics";
        String session = c.getSessionReference();
        Object[] method_params = new Object[]{Marshalling.toXMLRPC(session), Marshalling.toXMLRPC(this.ref)};
        Map response = c.dispatch(method_call, method_params);
        if (response.get("Status").equals("Success")) {
            Object result = response.get("Value");
            return Types.toVBDMetrics(result);
        }
        throw new Types.BadServerResponse(response);
    }

    public void setUserdevice(Connection c, String userdevice) throws Types.BadServerResponse, XmlRpcException {
        String method_call = "VBD.set_userdevice";
        String session = c.getSessionReference();
        Object[] method_params = new Object[]{Marshalling.toXMLRPC(session), Marshalling.toXMLRPC(this.ref), Marshalling.toXMLRPC(userdevice)};
        Map response = c.dispatch(method_call, method_params);
        if (response.get("Status").equals("Success")) {
            Object result = response.get("Value");
            return;
        }
        throw new Types.BadServerResponse(response);
    }

    public void setBootable(Connection c, Boolean bootable) throws Types.BadServerResponse, XmlRpcException {
        String method_call = "VBD.set_bootable";
        String session = c.getSessionReference();
        Object[] method_params = new Object[]{Marshalling.toXMLRPC(session), Marshalling.toXMLRPC(this.ref), Marshalling.toXMLRPC(bootable)};
        Map response = c.dispatch(method_call, method_params);
        if (response.get("Status").equals("Success")) {
            Object result = response.get("Value");
            return;
        }
        throw new Types.BadServerResponse(response);
    }

    public void setMode(Connection c, Types.VbdMode mode) throws Types.BadServerResponse, XmlRpcException {
        String method_call = "VBD.set_mode";
        String session = c.getSessionReference();
        Object[] method_params = new Object[]{Marshalling.toXMLRPC(session), Marshalling.toXMLRPC(this.ref), Marshalling.toXMLRPC((Object)mode)};
        Map response = c.dispatch(method_call, method_params);
        if (response.get("Status").equals("Success")) {
            Object result = response.get("Value");
            return;
        }
        throw new Types.BadServerResponse(response);
    }

    public void setType(Connection c, Types.VbdType type) throws Types.BadServerResponse, XmlRpcException {
        String method_call = "VBD.set_type";
        String session = c.getSessionReference();
        Object[] method_params = new Object[]{Marshalling.toXMLRPC(session), Marshalling.toXMLRPC(this.ref), Marshalling.toXMLRPC((Object)type)};
        Map response = c.dispatch(method_call, method_params);
        if (response.get("Status").equals("Success")) {
            Object result = response.get("Value");
            return;
        }
        throw new Types.BadServerResponse(response);
    }

    public void setUnpluggable(Connection c, Boolean unpluggable) throws Types.BadServerResponse, XmlRpcException {
        String method_call = "VBD.set_unpluggable";
        String session = c.getSessionReference();
        Object[] method_params = new Object[]{Marshalling.toXMLRPC(session), Marshalling.toXMLRPC(this.ref), Marshalling.toXMLRPC(unpluggable)};
        Map response = c.dispatch(method_call, method_params);
        if (response.get("Status").equals("Success")) {
            Object result = response.get("Value");
            return;
        }
        throw new Types.BadServerResponse(response);
    }

    public void setOtherConfig(Connection c, Map<String, String> otherConfig) throws Types.BadServerResponse, XmlRpcException {
        String method_call = "VBD.set_other_config";
        String session = c.getSessionReference();
        Object[] method_params = new Object[]{Marshalling.toXMLRPC(session), Marshalling.toXMLRPC(this.ref), Marshalling.toXMLRPC(otherConfig)};
        Map response = c.dispatch(method_call, method_params);
        if (response.get("Status").equals("Success")) {
            Object result = response.get("Value");
            return;
        }
        throw new Types.BadServerResponse(response);
    }

    public void addToOtherConfig(Connection c, String key, String value) throws Types.BadServerResponse, XmlRpcException {
        String method_call = "VBD.add_to_other_config";
        String session = c.getSessionReference();
        Object[] method_params = new Object[]{Marshalling.toXMLRPC(session), Marshalling.toXMLRPC(this.ref), Marshalling.toXMLRPC(key), Marshalling.toXMLRPC(value)};
        Map response = c.dispatch(method_call, method_params);
        if (response.get("Status").equals("Success")) {
            Object result = response.get("Value");
            return;
        }
        throw new Types.BadServerResponse(response);
    }

    public void removeFromOtherConfig(Connection c, String key) throws Types.BadServerResponse, XmlRpcException {
        String method_call = "VBD.remove_from_other_config";
        String session = c.getSessionReference();
        Object[] method_params = new Object[]{Marshalling.toXMLRPC(session), Marshalling.toXMLRPC(this.ref), Marshalling.toXMLRPC(key)};
        Map response = c.dispatch(method_call, method_params);
        if (response.get("Status").equals("Success")) {
            Object result = response.get("Value");
            return;
        }
        throw new Types.BadServerResponse(response);
    }

    public void setQosAlgorithmType(Connection c, String algorithmType) throws Types.BadServerResponse, XmlRpcException {
        String method_call = "VBD.set_qos_algorithm_type";
        String session = c.getSessionReference();
        Object[] method_params = new Object[]{Marshalling.toXMLRPC(session), Marshalling.toXMLRPC(this.ref), Marshalling.toXMLRPC(algorithmType)};
        Map response = c.dispatch(method_call, method_params);
        if (response.get("Status").equals("Success")) {
            Object result = response.get("Value");
            return;
        }
        throw new Types.BadServerResponse(response);
    }

    public void setQosAlgorithmParams(Connection c, Map<String, String> algorithmParams) throws Types.BadServerResponse, XmlRpcException {
        String method_call = "VBD.set_qos_algorithm_params";
        String session = c.getSessionReference();
        Object[] method_params = new Object[]{Marshalling.toXMLRPC(session), Marshalling.toXMLRPC(this.ref), Marshalling.toXMLRPC(algorithmParams)};
        Map response = c.dispatch(method_call, method_params);
        if (response.get("Status").equals("Success")) {
            Object result = response.get("Value");
            return;
        }
        throw new Types.BadServerResponse(response);
    }

    public void addToQosAlgorithmParams(Connection c, String key, String value) throws Types.BadServerResponse, XmlRpcException {
        String method_call = "VBD.add_to_qos_algorithm_params";
        String session = c.getSessionReference();
        Object[] method_params = new Object[]{Marshalling.toXMLRPC(session), Marshalling.toXMLRPC(this.ref), Marshalling.toXMLRPC(key), Marshalling.toXMLRPC(value)};
        Map response = c.dispatch(method_call, method_params);
        if (response.get("Status").equals("Success")) {
            Object result = response.get("Value");
            return;
        }
        throw new Types.BadServerResponse(response);
    }

    public void removeFromQosAlgorithmParams(Connection c, String key) throws Types.BadServerResponse, XmlRpcException {
        String method_call = "VBD.remove_from_qos_algorithm_params";
        String session = c.getSessionReference();
        Object[] method_params = new Object[]{Marshalling.toXMLRPC(session), Marshalling.toXMLRPC(this.ref), Marshalling.toXMLRPC(key)};
        Map response = c.dispatch(method_call, method_params);
        if (response.get("Status").equals("Success")) {
            Object result = response.get("Value");
            return;
        }
        throw new Types.BadServerResponse(response);
    }

    public Task ejectAsync(Connection c) throws Types.BadServerResponse, XmlRpcException, Types.VbdNotRemovableMedia, Types.VbdIsEmpty {
        String method_call = "Async.VBD.eject";
        String session = c.getSessionReference();
        Object[] method_params = new Object[]{Marshalling.toXMLRPC(session), Marshalling.toXMLRPC(this.ref)};
        Map response = c.dispatch(method_call, method_params);
        if (response.get("Status").equals("Success")) {
            Object result = response.get("Value");
            return Types.toTask(result);
        }
        if (response.get("Status").equals("Failure")) {
            Object[] error = (Object[])response.get("ErrorDescription");
            if (error[0].equals("VBD_NOT_REMOVABLE_MEDIA")) {
                throw new Types.VbdNotRemovableMedia((String)error[1]);
            }
            if (error[0].equals("VBD_IS_EMPTY")) {
                throw new Types.VbdIsEmpty((String)error[1]);
            }
        }
        throw new Types.BadServerResponse(response);
    }

    public void eject(Connection c) throws Types.BadServerResponse, XmlRpcException, Types.VbdNotRemovableMedia, Types.VbdIsEmpty {
        String method_call = "VBD.eject";
        String session = c.getSessionReference();
        Object[] method_params = new Object[]{Marshalling.toXMLRPC(session), Marshalling.toXMLRPC(this.ref)};
        Map response = c.dispatch(method_call, method_params);
        if (response.get("Status").equals("Success")) {
            Object result = response.get("Value");
            return;
        }
        if (response.get("Status").equals("Failure")) {
            Object[] error = (Object[])response.get("ErrorDescription");
            if (error[0].equals("VBD_NOT_REMOVABLE_MEDIA")) {
                throw new Types.VbdNotRemovableMedia((String)error[1]);
            }
            if (error[0].equals("VBD_IS_EMPTY")) {
                throw new Types.VbdIsEmpty((String)error[1]);
            }
        }
        throw new Types.BadServerResponse(response);
    }

    public Task insertAsync(Connection c, VDI vdi) throws Types.BadServerResponse, XmlRpcException, Types.VbdNotRemovableMedia, Types.VbdNotEmpty {
        String method_call = "Async.VBD.insert";
        String session = c.getSessionReference();
        Object[] method_params = new Object[]{Marshalling.toXMLRPC(session), Marshalling.toXMLRPC(this.ref), Marshalling.toXMLRPC(vdi)};
        Map response = c.dispatch(method_call, method_params);
        if (response.get("Status").equals("Success")) {
            Object result = response.get("Value");
            return Types.toTask(result);
        }
        if (response.get("Status").equals("Failure")) {
            Object[] error = (Object[])response.get("ErrorDescription");
            if (error[0].equals("VBD_NOT_REMOVABLE_MEDIA")) {
                throw new Types.VbdNotRemovableMedia((String)error[1]);
            }
            if (error[0].equals("VBD_NOT_EMPTY")) {
                throw new Types.VbdNotEmpty((String)error[1]);
            }
        }
        throw new Types.BadServerResponse(response);
    }

    public void insert(Connection c, VDI vdi) throws Types.BadServerResponse, XmlRpcException, Types.VbdNotRemovableMedia, Types.VbdNotEmpty {
        String method_call = "VBD.insert";
        String session = c.getSessionReference();
        Object[] method_params = new Object[]{Marshalling.toXMLRPC(session), Marshalling.toXMLRPC(this.ref), Marshalling.toXMLRPC(vdi)};
        Map response = c.dispatch(method_call, method_params);
        if (response.get("Status").equals("Success")) {
            Object result = response.get("Value");
            return;
        }
        if (response.get("Status").equals("Failure")) {
            Object[] error = (Object[])response.get("ErrorDescription");
            if (error[0].equals("VBD_NOT_REMOVABLE_MEDIA")) {
                throw new Types.VbdNotRemovableMedia((String)error[1]);
            }
            if (error[0].equals("VBD_NOT_EMPTY")) {
                throw new Types.VbdNotEmpty((String)error[1]);
            }
        }
        throw new Types.BadServerResponse(response);
    }

    public Task plugAsync(Connection c) throws Types.BadServerResponse, XmlRpcException {
        String method_call = "Async.VBD.plug";
        String session = c.getSessionReference();
        Object[] method_params = new Object[]{Marshalling.toXMLRPC(session), Marshalling.toXMLRPC(this.ref)};
        Map response = c.dispatch(method_call, method_params);
        if (response.get("Status").equals("Success")) {
            Object result = response.get("Value");
            return Types.toTask(result);
        }
        throw new Types.BadServerResponse(response);
    }

    public void plug(Connection c) throws Types.BadServerResponse, XmlRpcException {
        String method_call = "VBD.plug";
        String session = c.getSessionReference();
        Object[] method_params = new Object[]{Marshalling.toXMLRPC(session), Marshalling.toXMLRPC(this.ref)};
        Map response = c.dispatch(method_call, method_params);
        if (response.get("Status").equals("Success")) {
            Object result = response.get("Value");
            return;
        }
        throw new Types.BadServerResponse(response);
    }

    public Task unplugAsync(Connection c) throws Types.BadServerResponse, XmlRpcException, Types.DeviceDetachRejected, Types.DeviceAlreadyDetached {
        String method_call = "Async.VBD.unplug";
        String session = c.getSessionReference();
        Object[] method_params = new Object[]{Marshalling.toXMLRPC(session), Marshalling.toXMLRPC(this.ref)};
        Map response = c.dispatch(method_call, method_params);
        if (response.get("Status").equals("Success")) {
            Object result = response.get("Value");
            return Types.toTask(result);
        }
        if (response.get("Status").equals("Failure")) {
            Object[] error = (Object[])response.get("ErrorDescription");
            if (error[0].equals("DEVICE_DETACH_REJECTED")) {
                throw new Types.DeviceDetachRejected((String)error[1], (String)error[2], (String)error[3]);
            }
            if (error[0].equals("DEVICE_ALREADY_DETACHED")) {
                throw new Types.DeviceAlreadyDetached((String)error[1]);
            }
        }
        throw new Types.BadServerResponse(response);
    }

    public void unplug(Connection c) throws Types.BadServerResponse, XmlRpcException, Types.DeviceDetachRejected, Types.DeviceAlreadyDetached {
        String method_call = "VBD.unplug";
        String session = c.getSessionReference();
        Object[] method_params = new Object[]{Marshalling.toXMLRPC(session), Marshalling.toXMLRPC(this.ref)};
        Map response = c.dispatch(method_call, method_params);
        if (response.get("Status").equals("Success")) {
            Object result = response.get("Value");
            return;
        }
        if (response.get("Status").equals("Failure")) {
            Object[] error = (Object[])response.get("ErrorDescription");
            if (error[0].equals("DEVICE_DETACH_REJECTED")) {
                throw new Types.DeviceDetachRejected((String)error[1], (String)error[2], (String)error[3]);
            }
            if (error[0].equals("DEVICE_ALREADY_DETACHED")) {
                throw new Types.DeviceAlreadyDetached((String)error[1]);
            }
        }
        throw new Types.BadServerResponse(response);
    }

    public Task unplugForceAsync(Connection c) throws Types.BadServerResponse, XmlRpcException {
        String method_call = "Async.VBD.unplug_force";
        String session = c.getSessionReference();
        Object[] method_params = new Object[]{Marshalling.toXMLRPC(session), Marshalling.toXMLRPC(this.ref)};
        Map response = c.dispatch(method_call, method_params);
        if (response.get("Status").equals("Success")) {
            Object result = response.get("Value");
            return Types.toTask(result);
        }
        throw new Types.BadServerResponse(response);
    }

    public void unplugForce(Connection c) throws Types.BadServerResponse, XmlRpcException {
        String method_call = "VBD.unplug_force";
        String session = c.getSessionReference();
        Object[] method_params = new Object[]{Marshalling.toXMLRPC(session), Marshalling.toXMLRPC(this.ref)};
        Map response = c.dispatch(method_call, method_params);
        if (response.get("Status").equals("Success")) {
            Object result = response.get("Value");
            return;
        }
        throw new Types.BadServerResponse(response);
    }

    public Task assertAttachableAsync(Connection c) throws Types.BadServerResponse, XmlRpcException {
        String method_call = "Async.VBD.assert_attachable";
        String session = c.getSessionReference();
        Object[] method_params = new Object[]{Marshalling.toXMLRPC(session), Marshalling.toXMLRPC(this.ref)};
        Map response = c.dispatch(method_call, method_params);
        if (response.get("Status").equals("Success")) {
            Object result = response.get("Value");
            return Types.toTask(result);
        }
        throw new Types.BadServerResponse(response);
    }

    public void assertAttachable(Connection c) throws Types.BadServerResponse, XmlRpcException {
        String method_call = "VBD.assert_attachable";
        String session = c.getSessionReference();
        Object[] method_params = new Object[]{Marshalling.toXMLRPC(session), Marshalling.toXMLRPC(this.ref)};
        Map response = c.dispatch(method_call, method_params);
        if (response.get("Status").equals("Success")) {
            Object result = response.get("Value");
            return;
        }
        throw new Types.BadServerResponse(response);
    }

    public static Set<VBD> getAll(Connection c) throws Types.BadServerResponse, XmlRpcException {
        String method_call = "VBD.get_all";
        String session = c.getSessionReference();
        Object[] method_params = new Object[]{Marshalling.toXMLRPC(session)};
        Map response = c.dispatch(method_call, method_params);
        if (response.get("Status").equals("Success")) {
            Object result = response.get("Value");
            return Types.toSetOfVBD(result);
        }
        throw new Types.BadServerResponse(response);
    }

    public static Map<VBD, Record> getAllRecords(Connection c) throws Types.BadServerResponse, XmlRpcException {
        String method_call = "VBD.get_all_records";
        String session = c.getSessionReference();
        Object[] method_params = new Object[]{Marshalling.toXMLRPC(session)};
        Map response = c.dispatch(method_call, method_params);
        if (response.get("Status").equals("Success")) {
            Object result = response.get("Value");
            return Types.toMapOfVBDVBDRecord(result);
        }
        throw new Types.BadServerResponse(response);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Record
    implements Types.Record {
        public String uuid;
        public Set<Types.VbdOperations> allowedOperations;
        public Map<String, Types.VbdOperations> currentOperations;
        public VM VM;
        public VDI VDI;
        public String device;
        public String userdevice;
        public Boolean bootable;
        public Types.VbdMode mode;
        public Types.VbdType type;
        public Boolean unpluggable;
        public Boolean storageLock;
        public Boolean empty;
        public Map<String, String> otherConfig;
        public Boolean currentlyAttached;
        public Long statusCode;
        public String statusDetail;
        public Map<String, String> runtimeProperties;
        public String qosAlgorithmType;
        public Map<String, String> qosAlgorithmParams;
        public Set<String> qosSupportedAlgorithms;
        public VBDMetrics metrics;

        public String toString() {
            StringWriter writer = new StringWriter();
            PrintWriter print = new PrintWriter(writer);
            print.printf("%1$20s: %2$s\n", "uuid", this.uuid);
            print.printf("%1$20s: %2$s\n", "allowedOperations", this.allowedOperations);
            print.printf("%1$20s: %2$s\n", "currentOperations", this.currentOperations);
            print.printf("%1$20s: %2$s\n", "VM", this.VM);
            print.printf("%1$20s: %2$s\n", "VDI", this.VDI);
            print.printf("%1$20s: %2$s\n", "device", this.device);
            print.printf("%1$20s: %2$s\n", "userdevice", this.userdevice);
            print.printf("%1$20s: %2$s\n", "bootable", this.bootable);
            print.printf("%1$20s: %2$s\n", new Object[]{"mode", this.mode});
            print.printf("%1$20s: %2$s\n", new Object[]{"type", this.type});
            print.printf("%1$20s: %2$s\n", "unpluggable", this.unpluggable);
            print.printf("%1$20s: %2$s\n", "storageLock", this.storageLock);
            print.printf("%1$20s: %2$s\n", "empty", this.empty);
            print.printf("%1$20s: %2$s\n", "otherConfig", this.otherConfig);
            print.printf("%1$20s: %2$s\n", "currentlyAttached", this.currentlyAttached);
            print.printf("%1$20s: %2$s\n", "statusCode", this.statusCode);
            print.printf("%1$20s: %2$s\n", "statusDetail", this.statusDetail);
            print.printf("%1$20s: %2$s\n", "runtimeProperties", this.runtimeProperties);
            print.printf("%1$20s: %2$s\n", "qosAlgorithmType", this.qosAlgorithmType);
            print.printf("%1$20s: %2$s\n", "qosAlgorithmParams", this.qosAlgorithmParams);
            print.printf("%1$20s: %2$s\n", "qosSupportedAlgorithms", this.qosSupportedAlgorithms);
            print.printf("%1$20s: %2$s\n", "metrics", this.metrics);
            return writer.toString();
        }

        @Override
        public Map<String, Object> toMap() {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("uuid", this.uuid == null ? "" : this.uuid);
            map.put("allowed_operations", this.allowedOperations == null ? new HashSet() : this.allowedOperations);
            map.put("current_operations", this.currentOperations == null ? new HashMap() : this.currentOperations);
            map.put("VM", this.VM == null ? com.xensource.xenapi.VM.getInstFromRef("OpaqueRef:NULL") : this.VM);
            map.put("VDI", this.VDI == null ? com.xensource.xenapi.VDI.getInstFromRef("OpaqueRef:NULL") : this.VDI);
            map.put("device", this.device == null ? "" : this.device);
            map.put("userdevice", this.userdevice == null ? "" : this.userdevice);
            map.put("bootable", this.bootable == null ? false : this.bootable);
            map.put("mode", (Object)(this.mode == null ? Types.VbdMode.UNRECOGNIZED : this.mode));
            map.put("type", (Object)(this.type == null ? Types.VbdType.UNRECOGNIZED : this.type));
            map.put("unpluggable", this.unpluggable == null ? false : this.unpluggable);
            map.put("storage_lock", this.storageLock == null ? false : this.storageLock);
            map.put("empty", this.empty == null ? false : this.empty);
            map.put("other_config", this.otherConfig == null ? new HashMap() : this.otherConfig);
            map.put("currently_attached", this.currentlyAttached == null ? false : this.currentlyAttached);
            map.put("status_code", this.statusCode == null ? 0L : this.statusCode);
            map.put("status_detail", this.statusDetail == null ? "" : this.statusDetail);
            map.put("runtime_properties", this.runtimeProperties == null ? new HashMap() : this.runtimeProperties);
            map.put("qos_algorithm_type", this.qosAlgorithmType == null ? "" : this.qosAlgorithmType);
            map.put("qos_algorithm_params", this.qosAlgorithmParams == null ? new HashMap() : this.qosAlgorithmParams);
            map.put("qos_supported_algorithms", this.qosSupportedAlgorithms == null ? new HashSet() : this.qosSupportedAlgorithms);
            map.put("metrics", this.metrics == null ? VBDMetrics.getInstFromRef("OpaqueRef:NULL") : this.metrics);
            return map;
        }
    }
}

