/*
 * Decompiled with CFR 0.152.
 */
package com.xensource.xenapi;

import com.xensource.xenapi.Marshalling;
import com.xensource.xenapi.Types;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Map;
import org.apache.xmlrpc.XmlRpcException;
import org.apache.xmlrpc.client.XmlRpcClient;
import org.apache.xmlrpc.client.XmlRpcClientConfig;
import org.apache.xmlrpc.client.XmlRpcClientConfigImpl;

public class Connection {
    public Boolean rioConnection = false;
    private String sessionReference;
    private final XmlRpcClient client;

    public Connection(String client, String username, String password) throws MalformedURLException, XmlRpcException, Types.BadServerResponse, Types.SessionAuthenticationFailed {
        String ApiVersion = "1.2";
        this.client = this.getClientFromURL(client);
        try {
            this.sessionReference = Connection.loginWithPassword(this.client, username, password, "1.2");
        }
        catch (Types.BadServerResponse e) {
            Object[] errDesc = (Object[])e.response.get("ErrorDescription");
            if (0 == ((String)errDesc[0]).compareTo("MESSAGE_PARAMETER_COUNT_MISMATCH") && 0 == ((String)errDesc[1]).compareTo("session.login_with_password") && 0 == ((String)errDesc[2]).compareTo("2") && 0 == ((String)errDesc[3]).compareTo("3")) {
                this.sessionReference = Connection.loginWithPassword(this.client, username, password);
                this.rioConnection = true;
            }
            throw e;
        }
    }

    protected void finalize() throws Throwable {
        this.dispose();
        super.finalize();
    }

    public void dispose() throws Types.BadServerResponse, XmlRpcException {
        if (this.sessionReference != null) {
            String method_call = "session.logout";
            Object[] method_params = new Object[]{Marshalling.toXMLRPC(this.sessionReference)};
            Map response = (Map)this.client.execute(method_call, method_params);
            this.sessionReference = null;
            if (response.get("Status").equals("Success")) {
                return;
            }
            throw new Types.BadServerResponse(response);
        }
    }

    private static String loginWithPassword(XmlRpcClient client, String username, String password) throws Types.BadServerResponse, XmlRpcException, Types.SessionAuthenticationFailed {
        Object[] error;
        String method_call = "session.login_with_password";
        Object[] method_params = new Object[]{Marshalling.toXMLRPC(username), Marshalling.toXMLRPC(password)};
        Map response = (Map)client.execute(method_call, method_params);
        if (response.get("Status").equals("Success")) {
            return (String)response.get("Value");
        }
        if (response.get("Status").equals("Failure") && (error = (Object[])response.get("ErrorDescription"))[0].equals("SESSION_AUTHENTICATION_FAILED")) {
            throw new Types.SessionAuthenticationFailed();
        }
        throw new Types.BadServerResponse(response);
    }

    private static String loginWithPassword(XmlRpcClient client, String username, String password, String ApiVersion) throws Types.BadServerResponse, XmlRpcException, Types.SessionAuthenticationFailed {
        Object[] error;
        String method_call = "session.login_with_password";
        Object[] method_params = new Object[]{Marshalling.toXMLRPC(username), Marshalling.toXMLRPC(password), Marshalling.toXMLRPC(ApiVersion)};
        Map response = (Map)client.execute(method_call, method_params);
        if (response.get("Status").equals("Success")) {
            return (String)response.get("Value");
        }
        if (response.get("Status").equals("Failure") && (error = (Object[])response.get("ErrorDescription"))[0].equals("SESSION_AUTHENTICATION_FAILED")) {
            throw new Types.SessionAuthenticationFailed();
        }
        throw new Types.BadServerResponse(response);
    }

    private XmlRpcClient getClientFromURL(String s) throws MalformedURLException {
        URL url = new URL(s);
        XmlRpcClientConfigImpl config = new XmlRpcClientConfigImpl();
        config.setServerURL(url);
        XmlRpcClient client = new XmlRpcClient();
        client.setConfig((XmlRpcClientConfig)config);
        return client;
    }

    String getSessionReference() {
        return this.sessionReference;
    }

    Map dispatch(String method_call, Object[] method_params) throws XmlRpcException {
        return (Map)this.client.execute(method_call, method_params);
    }
}

