/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.lather.xcode;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.hyperic.lather.LatherRemoteException;
import org.hyperic.lather.LatherValue;

public class LatherXCoder {
    private final int HAS_STRINGS = 1;
    private final int HAS_INTS = 2;
    private final int HAS_DOUBLES = 4;
    private final int HAS_BYTEAS = 8;
    private final int HAS_STRINGLS = 16;
    private final int HAS_INTLS = 32;
    private final int HAS_DOUBLELS = 64;
    private final int HAS_BYTEALS = 128;
    private final int HAS_OBJECTS = 256;
    private final int HAS_OBJECTLS = 512;
    private final int HAS_LONGS = 1024;
    private final int HAS_SERIALAIZABLES = 2048;

    public void encode(LatherValue value, DataOutputStream out) throws IOException {
        Iterator j;
        List vals;
        int contents = 0;
        Map stringVals = value.getStringVals();
        Map intVals = value.getIntVals();
        Map longVals = value.getLongVals();
        Map doubleVals = value.getDoubleVals();
        Map byteaVals = value.getByteAVals();
        Map objectVals = value.getObjectVals();
        Map stringLists = value.getStringLists();
        Map intLists = value.getIntLists();
        Map doubleLists = value.getDoubleLists();
        Map byteaLists = value.getByteALists();
        Map objectLists = value.getObjectLists();
        if (stringVals.size() > 0) {
            contents |= 1;
        }
        if (intVals.size() > 0) {
            contents |= 2;
        }
        if (longVals.size() > 0) {
            contents |= 0x400;
        }
        if (doubleVals.size() > 0) {
            contents |= 4;
        }
        if (byteaVals.size() > 0) {
            contents |= 8;
        }
        if (stringLists.size() > 0) {
            contents |= 0x10;
        }
        if (intLists.size() > 0) {
            contents |= 0x20;
        }
        if (doubleLists.size() > 0) {
            contents |= 0x40;
        }
        if (byteaLists.size() > 0) {
            contents |= 0x80;
        }
        if (objectVals.size() > 0) {
            contents |= 0x100;
        }
        if (objectLists.size() > 0) {
            contents |= 0x200;
        }
        if (value.getSerializableMap().size() > 0) {
            contents |= 0x800;
        }
        out.writeInt(contents);
        if ((contents & 1) != 0) {
            out.writeInt(stringVals.size());
            for (Map.Entry ent : stringVals.entrySet()) {
                out.writeUTF((String)ent.getKey());
                out.writeUTF((String)ent.getValue());
            }
        }
        if ((contents & 2) != 0) {
            out.writeInt(intVals.size());
            for (Map.Entry ent : intVals.entrySet()) {
                out.writeUTF((String)ent.getKey());
                out.writeInt((Integer)ent.getValue());
            }
        }
        if ((contents & 4) != 0) {
            out.writeInt(doubleVals.size());
            for (Map.Entry ent : doubleVals.entrySet()) {
                out.writeUTF((String)ent.getKey());
                out.writeDouble((Double)ent.getValue());
            }
        }
        if ((contents & 8) != 0) {
            out.writeInt(byteaVals.size());
            for (Map.Entry ent : byteaVals.entrySet()) {
                out.writeUTF((String)ent.getKey());
                byte[] val = (byte[])ent.getValue();
                out.writeInt(val.length);
                out.write(val, 0, val.length);
            }
        }
        if ((contents & 0x10) != 0) {
            out.writeInt(stringLists.size());
            for (Map.Entry ent : stringLists.entrySet()) {
                vals = (List)ent.getValue();
                out.writeUTF((String)ent.getKey());
                out.writeInt(vals.size());
                j = vals.iterator();
                while (j.hasNext()) {
                    out.writeUTF((String)j.next());
                }
            }
        }
        if ((contents & 0x20) != 0) {
            out.writeInt(intLists.size());
            for (Map.Entry ent : intLists.entrySet()) {
                vals = (List)ent.getValue();
                out.writeUTF((String)ent.getKey());
                out.writeInt(vals.size());
                j = vals.iterator();
                while (j.hasNext()) {
                    out.writeInt((Integer)j.next());
                }
            }
        }
        if ((contents & 0x40) != 0) {
            out.writeInt(doubleLists.size());
            for (Map.Entry ent : doubleLists.entrySet()) {
                vals = (List)ent.getValue();
                out.writeUTF((String)ent.getKey());
                out.writeInt(vals.size());
                j = vals.iterator();
                while (j.hasNext()) {
                    out.writeDouble((Double)j.next());
                }
            }
        }
        if ((contents & 0x80) != 0) {
            out.writeInt(byteaLists.size());
            for (Map.Entry ent : byteaLists.entrySet()) {
                vals = (List)ent.getValue();
                out.writeUTF((String)ent.getKey());
                out.writeInt(vals.size());
                for (byte[] val : vals) {
                    out.writeInt(val.length);
                    out.write(val, 0, val.length);
                }
            }
        }
        if ((contents & 0x100) != 0) {
            out.writeInt(objectVals.size());
            for (Map.Entry ent : objectVals.entrySet()) {
                ByteArrayOutputStream bOs = new ByteArrayOutputStream();
                DataOutputStream subDoS = new DataOutputStream(bOs);
                this.encode((LatherValue)ent.getValue(), subDoS);
                out.writeUTF((String)ent.getKey());
                out.writeUTF(ent.getValue().getClass().getName());
                byte[] data = bOs.toByteArray();
                out.writeInt(data.length);
                out.write(data, 0, data.length);
            }
        }
        if ((contents & 0x200) != 0) {
            out.writeInt(objectLists.size());
            for (Map.Entry ent : objectLists.entrySet()) {
                vals = (List)ent.getValue();
                out.writeUTF((String)ent.getKey());
                out.writeInt(vals.size());
                for (LatherValue val : vals) {
                    ByteArrayOutputStream bOs = new ByteArrayOutputStream();
                    DataOutputStream subDoS = new DataOutputStream(bOs);
                    this.encode(val, subDoS);
                    out.writeUTF(val.getClass().getName());
                    byte[] data = bOs.toByteArray();
                    out.writeInt(data.length);
                    out.write(data, 0, data.length);
                }
            }
        }
        if ((contents & 0x400) != 0) {
            out.writeInt(longVals.size());
            for (Map.Entry ent : longVals.entrySet()) {
                out.writeUTF((String)ent.getKey());
                out.writeLong((Long)ent.getValue());
            }
        }
        if ((contents & 0x800) != 0) {
            out.writeInt(value.getSerializableMap().size());
            for (Map.Entry<String, Serializable> entry : value.getSerializableMap().entrySet()) {
                out.writeUTF(entry.getKey());
                ByteArrayOutputStream b = new ByteArrayOutputStream();
                ObjectOutputStream oos = new ObjectOutputStream(b);
                oos.writeObject(entry.getValue());
                byte[] data = b.toByteArray();
                out.writeInt(data.length);
                out.write(data);
            }
        }
    }

    public LatherValue decode(DataInputStream in, Class cl) throws IOException, LatherRemoteException {
        Class<?> valClass;
        DataInputStream subDiS;
        byte[] bytes;
        String className;
        byte[] bytes2;
        ArrayList<Object> newList;
        int nListVals;
        String listName;
        int i;
        Map<String, Serializable> map;
        int nVals;
        LatherValue res;
        if (!LatherValue.class.isAssignableFrom(cl)) {
            throw new IllegalArgumentException("Passed class (" + cl + ") is not a subclass of " + "LatherValue");
        }
        try {
            res = (LatherValue)cl.newInstance();
        }
        catch (Exception exc) {
            throw new IllegalArgumentException("Passed class is not accessable: " + exc);
        }
        int contents = in.readInt();
        if ((contents & 1) != 0) {
            nVals = in.readInt();
            map = res.getStringVals();
            for (i = 0; i < nVals; ++i) {
                map.put(in.readUTF(), (Serializable)((Object)in.readUTF()));
            }
        }
        if ((contents & 2) != 0) {
            nVals = in.readInt();
            map = res.getIntVals();
            for (i = 0; i < nVals; ++i) {
                map.put(in.readUTF(), new Integer(in.readInt()));
            }
        }
        if ((contents & 4) != 0) {
            nVals = in.readInt();
            map = res.getDoubleVals();
            for (i = 0; i < nVals; ++i) {
                map.put(in.readUTF(), new Double(in.readDouble()));
            }
        }
        if ((contents & 8) != 0) {
            nVals = in.readInt();
            map = res.getByteAVals();
            for (i = 0; i < nVals; ++i) {
                listName = in.readUTF();
                byte[] bytes3 = new byte[in.readInt()];
                in.readFully(bytes3);
                map.put(listName, (Serializable)bytes3);
            }
        }
        if ((contents & 0x10) != 0) {
            nVals = in.readInt();
            map = res.getStringLists();
            for (i = 0; i < nVals; ++i) {
                listName = in.readUTF();
                nListVals = in.readInt();
                newList = new ArrayList<Object>(nListVals);
                for (int j = 0; j < nListVals; ++j) {
                    newList.add(in.readUTF());
                }
                map.put(listName, newList);
            }
        }
        if ((contents & 0x20) != 0) {
            nVals = in.readInt();
            map = res.getIntLists();
            for (i = 0; i < nVals; ++i) {
                listName = in.readUTF();
                nListVals = in.readInt();
                newList = new ArrayList(nListVals);
                for (int j = 0; j < nListVals; ++j) {
                    newList.add(new Integer(in.readInt()));
                }
                map.put(listName, newList);
            }
        }
        if ((contents & 0x40) != 0) {
            nVals = in.readInt();
            map = res.getDoubleLists();
            for (i = 0; i < nVals; ++i) {
                listName = in.readUTF();
                nListVals = in.readInt();
                newList = new ArrayList(nListVals);
                for (int j = 0; j < nListVals; ++j) {
                    newList.add(new Double(in.readDouble()));
                }
                map.put(listName, newList);
            }
        }
        if ((contents & 0x80) != 0) {
            nVals = in.readInt();
            map = res.getByteALists();
            for (i = 0; i < nVals; ++i) {
                listName = in.readUTF();
                nListVals = in.readInt();
                newList = new ArrayList(nListVals);
                for (int j = 0; j < nListVals; ++j) {
                    bytes2 = new byte[in.readInt()];
                    in.readFully(bytes2);
                    newList.add(bytes2);
                }
                map.put(listName, newList);
            }
        }
        if ((contents & 0x100) != 0) {
            nVals = in.readInt();
            map = res.getObjectVals();
            for (i = 0; i < nVals; ++i) {
                listName = in.readUTF();
                className = in.readUTF();
                bytes = new byte[in.readInt()];
                in.readFully(bytes);
                ByteArrayInputStream bIs = new ByteArrayInputStream(bytes);
                subDiS = new DataInputStream(bIs);
                try {
                    valClass = Class.forName(className);
                }
                catch (ClassNotFoundException exc) {
                    throw new LatherRemoteException("Unable to locate '" + className + "' to decode " + "LatherValue");
                }
                map.put(listName, (Serializable)((Object)this.decode(subDiS, valClass)));
            }
        }
        if ((contents & 0x200) != 0) {
            nVals = in.readInt();
            map = res.getObjectLists();
            for (i = 0; i < nVals; ++i) {
                listName = in.readUTF();
                nListVals = in.readInt();
                newList = new ArrayList(nListVals);
                for (int j = 0; j < nListVals; ++j) {
                    className = in.readUTF();
                    bytes = new byte[in.readInt()];
                    in.readFully(bytes);
                    ByteArrayInputStream bIs = new ByteArrayInputStream(bytes);
                    subDiS = new DataInputStream(bIs);
                    try {
                        valClass = Class.forName(className);
                    }
                    catch (ClassNotFoundException exc) {
                        throw new LatherRemoteException("Unable to locate '" + className + "' to decode " + "LatherValue");
                    }
                    newList.add(this.decode(subDiS, valClass));
                }
                map.put(listName, newList);
            }
        }
        if ((contents & 0x400) != 0) {
            nVals = in.readInt();
            map = res.getLongVals();
            for (i = 0; i < nVals; ++i) {
                String key = in.readUTF();
                Long test = new Long(in.readLong());
                map.put(key, test);
            }
        }
        if ((contents & 0x800) != 0) {
            nVals = in.readInt();
            map = res.getSerializableMap();
            for (int i2 = 0; i2 < nVals; ++i2) {
                String key = in.readUTF();
                try {
                    bytes2 = new byte[in.readInt()];
                    ByteArrayInputStream b = new ByteArrayInputStream(bytes2);
                    in.readFully(bytes2);
                    ObjectInputStream ois = new ObjectInputStream(b);
                    Serializable obj = (Serializable)ois.readObject();
                    map.put(key, obj);
                    continue;
                }
                catch (ClassNotFoundException e) {
                    // empty catch block
                }
            }
        }
        res.validate();
        return res;
    }
}

