/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.hq.plugin.postgresql;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hyperic.hq.plugin.postgresql.PostgreSQL;
import org.hyperic.hq.product.AutoServerDetector;
import org.hyperic.hq.product.GenericPlugin;
import org.hyperic.hq.product.PluginException;
import org.hyperic.hq.product.ServerDetector;
import org.hyperic.hq.product.ServerResource;
import org.hyperic.hq.product.ServiceResource;
import org.hyperic.util.config.ConfigResponse;
import org.hyperic.util.jdbc.DBUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PostgreSQLServerDetector
extends ServerDetector
implements AutoServerDetector {
    private Log log = LogFactory.getLog(PostgreSQLServerDetector.class);
    private static final String PTQL_QUERY = "State.Name.re=post(master|gres),State.Name.Pne=$1,Args.0.re=.*post(master|gres)(.exe)?$";
    protected static final String DB_QUERY = "SELECT datname FROM pg_database WHERE datistemplate IS FALSE AND datallowconn IS TRUE";
    private static final String TABLE_QUERY = "SELECT relname, schemaname FROM pg_stat_user_tables";
    private static final String INDEX_QUERY = "SELECT indexrelname, schemaname FROM pg_stat_user_indexes";

    public List getServerResources(ConfigResponse platformConfig) throws PluginException {
        ArrayList<ServerResource> servers = new ArrayList<ServerResource>();
        long[] pids = PostgreSQLServerDetector.getPids((String)PTQL_QUERY);
        this.log.debug((Object)("[getServerProcessList] pids.length=" + pids.length));
        for (int i = 0; i < pids.length; ++i) {
            boolean isHQ;
            String exe = PostgreSQLServerDetector.getProcExe((long)pids[i]);
            List<String> args = Arrays.asList(PostgreSQLServerDetector.getProcArgs((long)pids[i]));
            this.log.debug((Object)("[getServerProcessList] pid=" + pids[i] + " exec=" + exe + " args=" + args));
            if (exe == null) continue;
            String version = this.getVersion(exe);
            String expectedVersion = this.getTypeProperty("version");
            String pgData = this.getArgument("-D", args);
            try {
                pgData = new File(pgData).getCanonicalPath();
            }
            catch (IOException ex) {
                this.log.debug((Object)ex, (Throwable)ex);
            }
            boolean correctVersion = Pattern.compile(expectedVersion).matcher(version).find();
            this.log.debug((Object)("[getServerProcessList] version=" + version + " correctVersion=" + correctVersion));
            boolean bl = isHQ = exe.indexOf("hqdb") != -1;
            if (correctVersion) {
                File vflicense = new File(new File(exe).getParent(), "vflicense");
                if (this.getTypeInfo().getName().startsWith("vPostgres")) {
                    correctVersion = vflicense.exists();
                } else if (this.getTypeInfo().getName().startsWith("HQ")) {
                    correctVersion = isHQ;
                } else {
                    boolean bl2 = correctVersion = !vflicense.exists() && !isHQ;
                }
            }
            if (correctVersion) {
                ServerResource server = this.createServerResource(exe);
                server.setMeasurementConfig();
                if (!isHQ) {
                    server.setControlConfig();
                }
                server.setIdentifier(server.getIdentifier() + "$" + pgData);
                ConfigResponse cprop = new ConfigResponse();
                cprop.setValue("version", version);
                this.setCustomProperties(server, cprop);
                ConfigResponse productConfig = this.prepareConfig(pgData, args);
                this.populateListeningPorts(pids[i], productConfig, true);
                this.setProductConfig(server, productConfig);
                String basename = PostgreSQLServerDetector.getPlatformName() + " " + this.getTypeInfo().getName();
                server.setName(this.prepareName(basename + " " + (isHQ ? "" : PostgreSQL.SERVER_NAME), server.getProductConfig(), null));
                servers.add(server);
                continue;
            }
            this.log.debug((Object)("[getServerProcessList] pid='" + pids[i] + "' Is not a '" + this.getTypeInfo().getName() + "'"));
        }
        return servers;
    }

    protected List discoverServices(ConfigResponse serverConfig) throws PluginException {
        this.log.debug((Object)("[discoverServices] config=" + serverConfig));
        boolean isHQ = this.getTypeInfo().getName().startsWith("HQ");
        ArrayList<ServiceResource> services = new ArrayList<ServiceResource>();
        String user = serverConfig.getValue("postgresql.user");
        String pass = serverConfig.getValue("postgresql.pass");
        String url = PostgreSQL.prepareUrl(serverConfig.toProperties(), null);
        try {
            Class.forName("org.postgresql.Driver");
        }
        catch (ClassNotFoundException e) {
            throw new PluginException("Unable to load JDBC Driver: " + e.getMessage());
        }
        Connection conn = null;
        Statement stmt = null;
        ResultSet rs = null;
        ArrayList<String> dataBases = new ArrayList<String>();
        try {
            conn = DriverManager.getConnection(url, user, pass);
            stmt = conn.createStatement();
            rs = stmt.executeQuery(DB_QUERY);
            while (rs != null && rs.next()) {
                dataBases.add(rs.getString(1));
            }
        }
        catch (SQLException e) {
            try {
                throw new PluginException("Error querying for DataBases: " + e.getMessage(), (Throwable)e);
            }
            catch (Throwable throwable) {
                DBUtil.closeJDBCObjects((Object)this.log, (Connection)conn, (Statement)stmt, rs);
                throw throwable;
            }
        }
        DBUtil.closeJDBCObjects((Object)this.log, (Connection)conn, (Statement)stmt, (ResultSet)rs);
        Pattern table_reg = null;
        boolean table_all = serverConfig.getValue("postgresql.table.regex").equalsIgnoreCase("ALL");
        boolean table_off = serverConfig.getValue("postgresql.table.regex").equalsIgnoreCase("OFF");
        if (!table_all && !table_off) {
            table_reg = Pattern.compile(serverConfig.getValue("postgresql.table.regex"));
        }
        Pattern index_reg = null;
        boolean index_all = serverConfig.getValue("postgresql.index.regex").equalsIgnoreCase("ALL");
        boolean index_off = serverConfig.getValue("postgresql.index.regex").equalsIgnoreCase("OFF");
        if (!index_all && !index_off) {
            index_reg = Pattern.compile(serverConfig.getValue("postgresql.index.regex"));
        }
        this.log.debug((Object)("[discoverServices] databases: " + dataBases));
        for (int i = 0; i < dataBases.size(); ++i) {
            String dataBase = (String)dataBases.get(i);
            ServiceResource db = new ServiceResource();
            db.setType((GenericPlugin)this, "DataBase");
            ConfigResponse dbPC = new ConfigResponse();
            dbPC.setValue("db", dataBase);
            db.setProductConfig(dbPC);
            db.setMeasurementConfig();
            db.setControlConfig();
            db.setServiceName(this.prepareName(isHQ ? "DataBase ${db}" : PostgreSQL.DB_NAME, serverConfig, dbPC));
            services.add(db);
            try {
                ServiceResource service;
                String schemaname;
                conn = DriverManager.getConnection(PostgreSQL.prepareUrl(serverConfig.toProperties(), dataBase), user, pass);
                stmt = conn.createStatement();
                rs = stmt.executeQuery(TABLE_QUERY);
                while (rs != null && rs.next()) {
                    String tablename = rs.getString(1);
                    schemaname = rs.getString(2);
                    if (!this.isValidName(tablename, table_all, table_off, table_reg)) continue;
                    service = new ServiceResource();
                    service.setType((GenericPlugin)this, "Table");
                    ConfigResponse tablePC = new ConfigResponse();
                    tablePC.setValue("db", dataBase);
                    tablePC.setValue("table", tablename);
                    tablePC.setValue("schema", schemaname);
                    service.setProductConfig(tablePC);
                    service.setMeasurementConfig();
                    service.setControlConfig();
                    service.setServiceName(this.prepareName(isHQ ? "Table ${table}" : PostgreSQL.TABLE_NAME, serverConfig, tablePC));
                    services.add(service);
                }
                DBUtil.closeJDBCObjects((Object)this.log, null, (Statement)stmt, (ResultSet)rs);
                stmt = conn.createStatement();
                rs = stmt.executeQuery(INDEX_QUERY);
                while (rs != null && rs.next()) {
                    String indexname = rs.getString(1);
                    schemaname = rs.getString(2);
                    if (!this.isValidName(indexname, index_all, index_off, index_reg)) continue;
                    service = new ServiceResource();
                    service.setType((GenericPlugin)this, "Index");
                    ConfigResponse indexPC = new ConfigResponse();
                    indexPC.setValue("db", dataBase);
                    indexPC.setValue("index", indexname);
                    indexPC.setValue("schema", schemaname);
                    service.setProductConfig(indexPC);
                    service.setMeasurementConfig();
                    service.setControlConfig();
                    service.setServiceName(this.prepareName(isHQ ? PostgreSQL.INDEX_NAME : PostgreSQL.INDEX_NAME, serverConfig, indexPC));
                    services.add(service);
                }
                continue;
            }
            catch (SQLException e) {
                throw new PluginException("Error querying for services: " + e.getMessage(), (Throwable)e);
            }
            finally {
                DBUtil.closeJDBCObjects((Object)this.log, (Connection)conn, (Statement)stmt, (ResultSet)rs);
            }
        }
        return services;
    }

    private String prepareName(String pattern, ConfigResponse serverConf, ConfigResponse serviceConf) {
        ArrayList<ConfigResponse> props = new ArrayList<ConfigResponse>();
        String res = pattern;
        props.add(serverConf);
        if (serviceConf != null) {
            props.add(serviceConf);
        }
        for (int i = 0; i < props.size(); ++i) {
            ConfigResponse cfg = (ConfigResponse)props.get(i);
            for (String key : cfg.getKeys()) {
                String val = cfg.getValue(key);
                if (val == null) {
                    val = "";
                }
                res = res.replace("${" + key + "}", val);
            }
        }
        return res.trim();
    }

    private String getVersion(String exec) {
        String[] command = new String[]{exec, "--version"};
        this.log.debug((Object)("[getVersionString] command= '" + Arrays.asList(command) + "'"));
        String version = "";
        try {
            Process cmd = Runtime.getRuntime().exec(command);
            cmd.getOutputStream().close();
            cmd.waitFor();
            String out = this.inputStreamAsString(cmd.getInputStream());
            String err = this.inputStreamAsString(cmd.getErrorStream());
            if (this.log.isDebugEnabled()) {
                if (cmd.exitValue() != 0) {
                    this.log.error((Object)("[getVersionString] exit=" + cmd.exitValue()));
                    this.log.error((Object)("[getVersionString] out=" + out));
                    this.log.error((Object)("[getVersionString] err=" + err));
                } else {
                    this.log.debug((Object)("[getVersionString] out=" + out));
                }
            }
            version = out;
        }
        catch (InterruptedException ex) {
            this.log.debug((Object)("[getVersionString] Error:" + ex.getMessage()), (Throwable)ex);
        }
        catch (IOException ex) {
            this.log.debug((Object)("[getVersionString] Error:" + ex.getMessage()), (Throwable)ex);
        }
        return version;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String inputStreamAsString(InputStream stream) throws IOException {
        BufferedReader br = new BufferedReader(new InputStreamReader(stream));
        StringBuilder sb = new StringBuilder();
        try {
            String line;
            while ((line = br.readLine()) != null) {
                sb.append(line).append("\n");
            }
        }
        finally {
            br.close();
        }
        return sb.toString().trim();
    }

    private String getArgument(String opt, List<String> args) {
        String res = "";
        int i = args.indexOf(opt);
        if (i > -1) {
            res = args.get(i + 1);
        }
        return res.trim();
    }

    private String getConfiguration(String regex, String config) {
        String res = "";
        Matcher m = Pattern.compile(regex, 10).matcher(config);
        if (m.find()) {
            res = m.group(1).trim();
            res = res.replaceAll("=", "");
            res = res.replaceAll("'", "");
            res = res.replaceAll("\"", "");
        }
        return res.trim();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String loadConfiguration(String pgData) {
        String configuration = "";
        File configFile = new File(pgData, "postgresql.conf");
        if (configFile.exists() && configFile.canRead()) {
            FileInputStream in = null;
            try {
                in = new FileInputStream(configFile);
                configuration = this.inputStreamAsString(in);
            }
            catch (IOException ex) {
                this.log.error((Object)("Error reading file '" + configFile + "': " + ex.getMessage()), (Throwable)ex);
            }
            finally {
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (IOException ex) {
                        this.log.error((Object)("Error closing file '" + configFile + "'"));
                    }
                }
            }
        }
        return configuration;
    }

    private ConfigResponse prepareConfig(String pgData, List<String> args) {
        ConfigResponse cf = new ConfigResponse();
        cf.setValue("postgresql.pgdata", pgData);
        String configuration = this.loadConfiguration(pgData);
        String addr = this.getConfiguration("^ *listen_addresses([^#]*)", configuration);
        if (addr.length() > 0) {
            if (addr.equals("*")) {
                addr = "localhost";
            }
            cf.setValue("postgresql.host", addr);
        } else {
            addr = this.getArgument("-h", args);
            if (addr.length() > 0) {
                cf.setValue("postgresql.host", addr);
            }
        }
        String port = this.getConfiguration("^ *port([^#]*)", configuration);
        if (port.length() > 0) {
            cf.setValue("postgresql.port", port);
        } else {
            port = this.getArgument("-p", args);
            if (port.length() > 0) {
                cf.setValue("postgresql.port", port);
            }
        }
        return cf;
    }

    private boolean isValidName(String name, boolean all, boolean off, Pattern reg) {
        boolean res = all ? true : (off ? false : reg.matcher(name).matches());
        return res;
    }

    private void populateListeningPorts(long pid, ConfigResponse productConfig, boolean b) {
        try {
            Class<?> du = Class.forName("org.hyperic.hq.product.DetectionUtil");
            Method plp = du.getMethod("populateListeningPorts", Long.TYPE, ConfigResponse.class, Boolean.TYPE);
            plp.invoke(null, pid, productConfig, b);
        }
        catch (ClassNotFoundException ex) {
            this.log.debug((Object)"[populateListeningPorts] Class 'DetectionUtil' not found", (Throwable)ex);
        }
        catch (NoSuchMethodException ex) {
            this.log.debug((Object)"[populateListeningPorts] Method 'populateListeningPorts' not found", (Throwable)ex);
        }
        catch (Exception ex) {
            this.log.debug((Object)"[populateListeningPorts] Problem with Method 'populateListeningPorts'", (Throwable)ex);
        }
    }
}

