/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.hq.plugin.postgresql;

import java.util.List;
import java.util.Properties;
import org.hyperic.hq.product.PluginException;

public class PostgreSQL {
    protected static final String PROP_TABLE = "table";
    protected static final String PROP_INDEX = "index";
    protected static final String PROP_SCHEMA = "schema";
    protected static final String PROP_DB = "db";
    protected static final String PROP_USER = "postgresql.user";
    protected static final String PROP_PASS = "postgresql.pass";
    protected static final String PROP_HOST = "postgresql.host";
    protected static final String PROP_PORT = "postgresql.port";
    protected static final String PROP_DFDB = "postgresql.dfdb";
    protected static final String PROP_DATA = "postgresql.pgdata";
    protected static final String PROP_TABLE_REG = "postgresql.table.regex";
    protected static final String PROP_INDEX_REG = "postgresql.index.regex";
    protected static final String PROP_PROGRAM = "postgresql.program";
    protected static final String PROP_PREFIX = "postgresql.prefix";
    protected static final String PROP_TIMEOUT = "postgresql.timeout";
    protected static final String SERVER_NAME = System.getProperty("postgresql.server.name.format", "${postgresql.host}:${postgresql.port}");
    protected static final String DB_NAME = System.getProperty("postgresql.database.name.format", "DataBase ${db}");
    protected static final String TABLE_NAME = System.getProperty("postgresql.table.name.format", "Table ${db}.${schema}.${table}");
    protected static final String INDEX_NAME = System.getProperty("postgresql.index.format", "Index ${db}.${schema}.${index}");
    protected static final String HQ_SERVER_NAME = "";
    protected static final String HQ_DB_NAME = "DataBase ${db}";
    protected static final String HQ_TABLE_NAME = "Table ${table}";
    protected static final String HQ_INDEX_NAME = "Index ${index}";

    protected static String prepareUrl(Properties config, String db) throws PluginException {
        String host = config.getProperty(PROP_HOST);
        String port = config.getProperty(PROP_PORT);
        if (db == null) {
            db = config.getProperty(PROP_DFDB);
        }
        if (db == null || host == null || port == null) {
            throw new PluginException("invalid configuration.");
        }
        return "jdbc:postgresql://" + host + ":" + port + "/" + db;
    }

    protected static String listToString(List list, String glue) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < list.size(); ++i) {
            if (i > 0) {
                sb.append(glue);
            }
            sb.append("'").append(list.get(i)).append("'");
        }
        return sb.toString();
    }
}

